jQuery(document).ready(function($) {
	$('#hm_sbp_field_report_time').change(function() {
			$('.hm_sbp_custom_time').toggle(this.value == 'custom');
	});
	$('#hm_sbp_field_report_time').change();

	$('#hm_sbp_field_report_preset').change(function() {
		$(this).closest('form').submit();
	});

	$('#hm-psr-button-add-field').click(function() {
		var $fieldsSelect = $('#hm_psr_custom_field');
		var $selectedOption = $fieldsSelect.find('option:selected:first');
		var isOtherOption = $selectedOption.hasClass('hm-psr-select-other-option');
		if (isOtherOption) {
			var otherFieldName = $fieldsSelect.siblings('.hm-psr-select-other-field:first').val();
			if (!otherFieldName.length) {
				return;
			}
		}
		hm_psr_add_custom_field($selectedOption.val(), isOtherOption ? otherFieldName : $selectedOption.text());
		if (isOtherOption) {
			$fieldsSelect.val($fieldsSelect.find('option:first').val()).change();
		}
	});
	
	$('.hm_psr_variations_fld').change(function() {
		if ($(this).val() == 0) {
			$('#hm_psr_report_fields .hm_psr_variation_field input[type="checkbox"]').prop('checked', false).prop('disabled', true);
			$('#hm_psr_custom_field .hm_psr_variation_field').prop('disabled', true);
		} else {
			$('#hm_psr_report_fields .hm_psr_variation_field input[type="checkbox"]').prop('disabled', false);
			$('#hm_psr_custom_field .hm_psr_variation_field').prop('disabled', false);
		}
	});
	$('.hm_psr_variations_fld:checked').change();
	
	$('#hm_psr_order_meta_filter_op, #hm_psr_order_meta_filter_2_op, #hm_psr_order_item_meta_filter_1_op, #hm_psr_order_item_meta_filter_2_op').change(function() {
		var $opSelect = $(this);
		
		switch ($opSelect.val()) {
			case 'NOTEXISTS':
				$opSelect.siblings('.hm_psr_filter_value_container')
					.hide()
					.val('');
				$opSelect.siblings('[id$="_value_2"]')
					.hide()
					.find('input')
					.val('');
				break;
			case 'BETWEEN':
				$opSelect.siblings('.hm_psr_filter_value_container, [id$="_value_2"]')
					.show();
				break;
			default:
				$opSelect.siblings('.hm_psr_filter_value_container')
					.show();
				$opSelect.siblings('[id$="_value_2"]')
					.hide()
					.find('input')
					.val('');
		}
	});
	$('#hm_psr_order_meta_filter_op, #hm_psr_order_meta_filter_2_op, #hm_psr_order_item_meta_filter_1_op, #hm_psr_order_item_meta_filter_2_op').change();
	
	
	$('#hm_psr_customer_meta_filter_op').change(function() {
		switch ($(this).val()) {
			case 'NOTEXISTS':
				$('#hm_psr_customer_meta_filter_value')
					.hide()
					.val('');
				$('#hm_psr_customer_meta_filter_value_2')
					.hide()
					.find('input')
					.val('');
				break;
			case 'BETWEEN':
				$('#hm_psr_customer_meta_filter_value,#hm_psr_customer_meta_filter_value_2')
					.show();
				break;
			default:
				$('#hm_psr_customer_meta_filter_value')
					.show();
				$('#hm_psr_customer_meta_filter_value_2')
					.hide()
					.find('input')
					.val('');
		}
	});
	$('#hm_psr_customer_meta_filter_op').change();
	
	
	$('#hm_psr_product_meta_filter_op').change(function() {
		var isBetween = ( $(this).val() == 'BETWEEN' ),
			$metaFilterValue2 = $('#hm_psr_product_meta_filter_value_2'),
			$valuePreset = $metaFilterValue2.siblings('.hm-psr-value-preset:first');
		
		if ( isBetween && $valuePreset.val() ) {
			$valuePreset.val('').change();
		}
		
		$metaFilterValue2.toggle(isBetween);
		$valuePreset.toggle(!isBetween);
		
	});
	$('#hm_psr_product_meta_filter_op').change();
	
	$('#hm_psr_report_fields').sortable({
		update: hm_psr_update_sort_options
	});
	
	$('#hm_psr_field_groupby, #hm_psr_field_groupby2, #hm_psr_field_groupby3').change(function() {
		var $field = $(this), fieldId = $field.attr('id'), fieldNum = fieldId.length == 20 ? '' : fieldId[20];
		
		if ($field.val() == '') {
			jQuery('#hm_psr_report_fields .hm_psr_groupby_field' + fieldNum).css('display', 'none').children('input[type="hidden"]').remove();
		} else {
			jQuery('#hm_psr_report_fields .hm_psr_groupby_field' + fieldNum).remove();
			hm_psr_add_custom_field('builtin::groupby_field' + fieldNum, $field.find('option:selected:first').text());
		}
	});
	
	$('#hm_psr_tabs > a').click(function() {
		$('#hm_psr_tab_panels > .hm_psr_tab_panel').hide();
		$('#hm_psr_tabs > a').removeClass('nav-tab-active');
		$('#' + $(this).attr('id') + '_panel').show();
		$(this).addClass('nav-tab-active');
	});
	if (location.hash.length > 1 && $('#hm_psr_tab_' + location.hash.substring(1)).length) {
		$('#hm_psr_tab_' + location.hash.substring(1)).click();
	} else {
		$('#hm_psr_tabs > a:first-child').click();
	}
	
	$('#hm_psr_product_tag_filter_select').change(function() {
		var thisTag = $(this).val();
		if (thisTag != '') {
			var currentTags = $('#hm_psr_product_tag_filter').val();
			$('#hm_psr_product_tag_filter').val((currentTags == '' ? '' : currentTags + ', ') + thisTag);
		}
		$(this).val('');
	});
	
	$('#hm_psr_field_include_totals').change(function() {
		$('.hm_psr_total_field').toggle( $(this).is(':checked') );
	});
	$('#hm_psr_field_include_totals').change();
	
	$('.hm-psr-date-dynamic-toggle').click(function() {
		var $this = $(this);
		var $dynamicField = $this.siblings('.hm-psr-date-dynamic-field');
		if ($dynamicField.hasClass('hidden')) {
			$dynamicField.siblings('input:first').prop('disabled', true);
			$dynamicField.val($dynamicField.hasClass('hm-psr-date-dynamic-field-with-format') ? 'now|Y-m-d H:i:s' : 'today').removeClass('hidden').change();
			$this.text('fixed value');
		} else {
			$dynamicField.addClass('hidden').val('');
			$dynamicField.siblings('input:first').prop('disabled', false);
			$this.text('dynamic date');
		}
	});
	
	$('.hm-psr-date-dynamic-field').change(function() {
		var $this = $(this);
		$.post(ajaxurl, {
			'action': 'hm_psr_calc_dynamic_date',
			'date': $this.val(),
			'allowFormat': $this.hasClass('hm-psr-date-dynamic-field-with-format'),
			'use_wp_date': $('#hm_psr_use_wp_date:checked:first').length
		}, function(result) {
			if (result.success && result.data) {
				$this.siblings('input:first').val(result.data);
			} else {
				alert('Unable to calculate date from expression: ' + $this.val());
			}
		}).fail(function() {
			alert('Unable to calculate date from expression: ' + $this.val());
		});
	});
	
	$('#hm_psr_use_wp_date').change(function() {
		$('.hm-psr-date-dynamic-field:not(.hidden)').change();
	});
	
	$('#hm_psr_field_format').change(function() {
		$('.hm_psr_format_options').hide();
		$('#hm_psr_format_options_' + $(this).val()).show();
	});
	$('#hm_psr_field_format').change();
	
	hm_psr_update_sort_options();
	
	$('#hm_psr_tab_panels .hm-psr-select-other')
		.append($('<option>').html('Other...').addClass('hm-psr-select-other-option'))
		.closest('select')
		.change(function() {
			var $this = $(this);
			var $selectedOtherOption = $this.find('option.hm-psr-select-other-option:selected')
			if ($this.hasClass('hm-psr-select-other-selected')) {
					$this.removeClass('hm-psr-select-other-selected').siblings('.hm-psr-select-other-field').remove();
					$selectedOtherOption.html('Other...');
			}
			if ($selectedOtherOption.length) {
				var selectName = $this.attr('name');
				var $optGroup = $selectedOtherOption.closest('optgroup');
				var $otherField = $('<input>')
									.attr({placeholder: '(enter value)', type: 'text'})
									.addClass('hm-psr-select-other-field')
									.change(function() {
										var $this = $(this);
										var thisValue = $(this).val();
										var otherFieldPrefix = $optGroup.data('hm-psr-other-field-prefix');
										$selectedOtherOption.val((otherFieldPrefix ? otherFieldPrefix : '') + thisValue);
										
										// Special handling for the Group By fields
										if ($this.siblings('#hm_psr_field_groupby').length) {
											$('#hm_psr_report_fields .hm_psr_groupby_field .hm_psr_field_name').val(thisValue);
										} else if ($this.siblings('#hm_psr_field_groupby2').length) {
											$('#hm_psr_report_fields .hm_psr_groupby_field2 .hm_psr_field_name').val(thisValue);
										} else if ($this.siblings('#hm_psr_field_groupby3').length) {
											$('#hm_psr_report_fields .hm_psr_groupby_field3 .hm_psr_field_name').val(thisValue);
										}
									});
				
				$selectedOtherOption.text(($optGroup.length ? $optGroup.attr('label') + ' - ' : '') + 'Other:');
				
				$this
					.addClass('hm-psr-select-other-selected')
					.after($otherField);
			}
		});
		
		$('.hm-psr-value-preset')
			.each(function() {
				var $preset = $(this),
					forFieldName = $preset.data('hm-psr-for');
				
				if (forFieldName) {
					var $forField = $('[name="' + forFieldName + '"]');
					if ($forField.length) {
						
						$preset.change(function() {
							var presetValue = $preset.val();
							$forField
								.val(presetValue)
								.toggle(!presetValue);
						});
						
						$preset
							.children( '[value="' + $forField.val() + '"]:first' )
							.attr('selected', true);
						
						if ($preset.val()) {
							$preset.change();
						}
						
							
					}
				}
			});
			
			
	
	$('#hm_psr_product_meta_filter_settings [name="product_meta_filter_key"]:first').change(function() {
		var $filterKey = $(this);
		var $filterOp = $('#hm_psr_product_meta_filter_op');
		
		var $preset = $filterKey.siblings('.hm-psr-value-preset:first');
		
		var triggerPresetChange = $preset.has('.ags-psr-taxonomy-terms :selected').length;
		
		$preset.children('.ags-psr-taxonomy-terms').remove();
		
		if ($filterKey.val().substr(0, 10) == 'taxonomy::') {
			if ( $filterOp.val() != '=' && $filterOp.val() != '!=' ) {
				$filterOp.val('=');
			}
			$filterOp.children(':not([value="="]):not([value="!="])').hide();
			
			var terms = $filterKey.find('option:selected').data('ags-terms');
			
			if (terms) {
				var $termsGroup = $('<optgroup>').attr('label', $filterKey.val().substr(10)).addClass('ags-psr-taxonomy-terms');
				terms = terms.split(',');
			
				for (var i = 0; i < terms.length; ++i) {
					terms[i] = terms[i].replaceAll(/_AGS_COMMA_/g, ',');
					
					$('<option>')
						.val(terms[i])
						.text(terms[i])
						.appendTo($termsGroup);
				}
				
				$termsGroup.appendTo($preset);
				
				var currentValue = $filterKey.siblings('[name="product_meta_filter_value"]:first').val();
				
				$preset.val( terms.indexOf(currentValue) == -1 ? terms[0] : currentValue );
				triggerPresetChange = true;
			}
			
		} else {
			$filterOp.children().show();
		}
		
		if (triggerPresetChange) {
			$preset.change();
		}
	}).change();
	
	
	$('#hm_psr_disable_product_grouping').change(function() {
		var state = $(this).is(':checked');
		$('#hm_psr_custom_field .hm-psr-product-fields, #hm_psr_custom_field .hm-psr-product-field').toggle(!state);
		if (state) {
			$('#hm_psr_custom_field .hm-psr-product-fields option, #hm_psr_custom_field .hm-psr-product-field').each(function() {
				$('#hm_psr_report_fields > div > input[value="' + this.value + '"]').parent().remove();
			});
			if ( $('#hm_psr_custom_field .hm-psr-product-field:selected:first, #hm_psr_custom_field .hm-psr-product-fields option:selected:first').length ) {
				$('#hm_psr_custom_field').val( $('#hm_psr_custom_field :not(.hm-psr-product-fields) option:not(.hm-psr-product-field):first').val() );
			}
		}
	}).change();
	
});

function hm_psr_add_custom_field(fieldId, fieldName) {
	var customFieldBox = jQuery('#hm_psr_report_fields > div:last-child').clone().removeClass('hm_psr_groupby_field hm_psr_groupby_field2 hm_psr_groupby_field3 hm_psr_variation_field');
	customFieldBox.children('input[type="hidden"]').attr('value', fieldId);
	customFieldBox.children('input[type="text"]').attr('name', 'field_names[' + fieldId + ']').val(fieldName);

	if (fieldId == 'builtin::groupby_field' || fieldId == 'builtin::groupby_field2' || fieldId == 'builtin::groupby_field3') {
		customFieldBox.addClass( 'hm_psr_groupby_field' + (fieldId == 'builtin::groupby_field' ? '' : fieldId[22]) );
	} else if (fieldId == 'builtin::variation_id' || fieldId == 'builtin::variation_sku' || fieldId == 'builtin::variation_attributes' || fieldId.substr(0, 11) == 'variation::') {
		customFieldBox.addClass('hm_psr_variation_field');
	}
	customFieldBox.children('.hm_psr_total_field').toggleClass('no-total', jQuery('#hm_psr_custom_field option[value="' + fieldId.replace('"', '\\"') + '"]').hasClass('no-total-field')).children('input').prop('checked', false).attr('value', fieldId);
	jQuery('#hm_psr_report_fields').append(customFieldBox);
	hm_psr_update_sort_options();
	jQuery("#hm_psr_report_fields").scrollTop(jQuery("#hm_psr_report_fields")[0].scrollHeight)
}

function hm_psr_remove_field(btn) {
	var $field = jQuery(btn).parent();
	if ($field.hasClass('hm_psr_groupby_field')) {
		alert('This field is a grouping field. To remove this field, please change the Group By 1 setting in the Grouping & Sorting tab.');
		return;
	}
	if ($field.hasClass('hm_psr_groupby_field2')) {
		alert('This field is a grouping field. To remove this field, please change the Group By 2 setting in the Grouping & Sorting tab.');
		return;
	}
	if ($field.hasClass('hm_psr_groupby_field3')) {
		alert('This field is a grouping field. To remove this field, please change the Group By 3 setting in the Grouping & Sorting tab.');
		return;
	}
	$field.remove();
	hm_psr_update_sort_options();
}

function hm_psr_update_sort_options() {
	var $select = jQuery('#hm_sbp_field_orderby');
	var currentValue = $select.val();
	$select.empty();
	
	jQuery('#hm_psr_report_fields > div').each(function() {
		var $field = jQuery(this);
		var fieldId = $field.find('input[type="hidden"]').val();
		jQuery('<option>')
			.attr('value', fieldId)
			.text($field.find('input[type="text"]').val())
			.attr('selected', fieldId == currentValue)
			.appendTo($select);
	});
}