<?php
/*
    Product Sales Report Pro for WooCommerce
    Copyright (C) 2021  Aspen Grove Studios

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/


if (!defined('ABSPATH')) exit;
?>

<div id="ags-psr-settings-container">
    <div id="ags-psr-settings">
        <div id="ags-psr-settings-header">
            <div class="ags-psr-settings-logo">
                <h3><?php echo esc_html(HM_PSR_ITEM_NAME); ?></h3>
            </div>
            <div id="ags-psr-settings-header-links">
                <a id="ags-psr-settings-header-link-support"
                   href="https://support.aspengrovestudios.com/article/413-product-sales-report-pro"
                   target="_blank">Documentation</a>
            </div>
        </div>

        <?php if (HM_Product_Sales_Report_Pro::licenseCheck() === true) { // check if license is active ?>
            <ul id="ags-psr-settings-tabs">
                <li class="ags-psr-settings-active"><a href="#settings">Report Settings</a></li>
                <li><a href="#license">License</a></li>
                <li><a href="#addons">Addons</a></li>
            </ul>
        <?php } ?>

        <div id="ags-psr-settings-tabs-content">

            <?php
// Check for WooCommerce
if (!class_exists('WooCommerce')) {
                echo('<div class="ags-psr-notification ags-psr-notification-error"><p>This plugin requires that WooCommerce is installed and activated.</p></div></div>');
	return;
} else if (!function_exists('wc_get_order_types')) {
                echo('<div class="ags-psr-notification ags-psr-notification-error"><p>The Product Sales Report plugin requires WooCommerce 2.2 or higher. Please update your WooCommerce install.</p></div></div>');
	return;
}

// Check for license
            if (HM_PSR_IS_PRO && !HM_Product_Sales_Report_Pro::licenseCheck()) {
                HM_Product_Sales_Report_Pro::licenseActivateForm();
	return;
            }
// Print form
//HM_Product_Sales_Report_Pro::loadPresetField($savedReportSettings);

// XLS format is no longer supported by this plugin
if ($reportSettings['format'] == 'xls') {
	$reportSettings['format'] = 'xlsx';
}

$canEditReportCSS = current_user_can('edit_theme_options');
$orderBy = (in_array($reportSettings['orderby'], array('product_id', 'quantity', 'gross', 'gross_after_discount')) ? 'builtin::'.$reportSettings['orderby'] : $reportSettings['orderby']);

            echo('
            <div id="ags-psr-settings-settings" class="ags-psr-settings-active">
            <form action="" method="post" id="hm_psr_form">
			<div id="hm_psr-current-preset">
				<input type="text" name="preset_name" placeholder="Preset Name"'.(isset($_GET['preset']) && isset($savedReportSettings[$_GET['preset']]['preset_name']) ? ' value="'.esc_attr($savedReportSettings[$_GET['preset']]['preset_name']).'"' : '').' class="hm-psr-input-fullwidth"/>
'.(isset($_GET['preset']) ? '<button class="button-primary" name="hm_psr_action" value="preset-save" onclick="jQuery(this).closest(\'form\').attr(\'target\', \'\'); return true;">Save Changes</button>
							<button class="button-secondary" type="button" onclick="location.href=\'?page=hm_sbp\';">Close Preset</button>' : '').'
				<button class="button-secondary" name="hm_psr_action" value="preset-create" onclick="jQuery(this).closest(\'form\').attr(\'target\', \'\'); return true;">Create New Preset</button>
			    </div>');
			
            if (isset($hm_psr_email_result)) {
                if ($hm_psr_email_result) {
                    echo('<div class="ags-psr-notification ags-psr-notification-success"><p>The report has been emailed to <strong>' . esc_html($_POST['email_to']) . '</strong>.</p></div>');
                } else {
                    echo('<div class="ags-psr-notification ags-psr-notification-error"><p>An error occurred while emailing the report. Please try again.</p></div>');
                }
            }

            echo('<h2 id="hm_psr_tabs" class="nav-tab-wrapper">
				'.(count($savedReportSettings) > 1 ? '<a id="hm_psr_tab_presets" class="nav-tab" href="#presets">Presets</a>' : '').'
				<a id="hm_psr_tab_orders" class="nav-tab" href="#orders">Order Filtering</a>
				<a id="hm_psr_tab_products" class="nav-tab" href="#products">Product Filtering</a>
				<a id="hm_psr_tab_groupsort" class="nav-tab" href="#groupsort">Grouping &amp; Sorting</a>
				<a id="hm_psr_tab_fields" class="nav-tab" href="#fields">Report Fields</a>
				<a id="hm_psr_tab_display" class="nav-tab" href="#display">Display &amp; Format</a>
				<a id="hm_psr_tab_advanced" class="nav-tab" href="#advanced">Advanced</a>
			</h2>
			
			<div id="hm_psr_tab_panels">
                <table id="hm_psr_tab_presets_panel" class="hm_psr_tab_panel">
				<tbody>');
	$runNonce = wp_create_nonce('hm-psr-run');
	foreach ($savedReportSettings as $presetId => $preset) {
		if ($presetId == 0) continue;
		echo('<tr>
			<td>'.esc_html($preset['preset_name']).'</td>
			<td>
                            <a href="?page=hm_sbp&amp;hm_psr_action=run&amp;preset=' . ( (int) $presetId ) . '&amp;hm-psr-nonce=' . esc_attr($runNonce) . '" target="_blank" class="dashicons dashicons-download" />
				<a href="?page=hm_sbp&amp;preset='.((int) $presetId ).'#orders" class="dashicons dashicons-edit" />
				<a href="?page=hm_sbp&amp;hm_psr_action=preset-del&amp;preset='.((int) $presetId ).'" class="dashicons dashicons-trash" onclick="return confirm(\'Are you sure that you want to delete this preset?\');" />
			</td>
		</tr>');
	}
echo('
			</tbody>
		</table>
			
            <div id="hm_psr_tab_orders_panel" class="hm_psr_tab_panel">
            
                <div class="ags-psr-settings-box">
                    <label for="hm_sbp_field_report_time">
                       <span class="label">Order Period:</span>
						<select name="report_time" id="hm_sbp_field_report_time">
							<option value="0d"'.($reportSettings['report_time'] == '0d' ? ' selected="selected"' : '').'>Today</option>
							<option value="1d"'.($reportSettings['report_time'] == '1d' ? ' selected="selected"' : '').'>Yesterday</option>
							<option value="7d"'.($reportSettings['report_time'] == '7d' ? ' selected="selected"' : '').'>Previous 7 days (excluding today)</option>
							<option value="30d"'.($reportSettings['report_time'] == '30d' ? ' selected="selected"' : '').'>Previous 30 days (excluding today)</option>
							<option value="0cm"'.($reportSettings['report_time'] == '0cm' ? ' selected="selected"' : '').'>Current calendar month</option>
							<option value="1cm"'.($reportSettings['report_time'] == '1cm' ? ' selected="selected"' : '').'>Previous calendar month</option>
							<option value="+7d"'.($reportSettings['report_time'] == '+7d' ? ' selected="selected"' : '').'>Next 7 days (future dated orders)</option>
							<option value="+30d"'.($reportSettings['report_time'] == '+30d' ? ' selected="selected"' : '').'>Next 30 days (future dated orders)</option>
							<option value="+1cm"'.($reportSettings['report_time'] == '+1cm' ? ' selected="selected"' : '').'>Next calendar month (future dated orders)</option>
							<option value="all"'.($reportSettings['report_time'] == 'all' ? ' selected="selected"' : '').'>All time</option>
							<option value="custom"'.($reportSettings['report_time'] == 'custom' ? ' selected="selected"' : '').'>Custom date range</option>
						</select>
                    </label>
                </div>
                
                <div class="ags-psr-settings-box hm_sbp_custom_time">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title">
                           <span class="label">Start Date &amp; Time:</span>
                         </label>
                        <div class="ags-psr-settings-content">
                       
							<input type="date" name="report_start" id="hm_sbp_field_report_start" value="'.esc_attr(empty($reportSettings['report_start_dynamic']) ? $reportSettings['report_start'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['report_start_dynamic'], false, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['report_start_dynamic']) ? '' : ' disabled="disabled"').' />
							<input type="text" class="hm-psr-date-dynamic-field'.(empty($reportSettings['report_start_dynamic']) ? ' hidden' : '').'" name="report_start_dynamic" value="'.esc_attr($reportSettings['report_start_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['report_start_dynamic']) ? 'dynamic' : 'fixed').' date</a>
						
						<input type="text" name="report_start_time" id="hm_sbp_field_report_start_time" value="'.esc_attr($reportSettings['report_start_time']).'" />
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box hm_sbp_custom_time">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title" for="hm_sbp_field_report_end">
                           <span class="label">End Date &amp; Time:</span>
                         </label>
                        <div class="ags-psr-settings-content">
                       
							<input type="date" name="report_end" id="hm_sbp_field_report_end" value="'.esc_attr(empty($reportSettings['report_end_dynamic']) ? $reportSettings['report_end'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['report_end_dynamic'], false, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['report_end_dynamic']) ? '' : ' disabled="disabled"').' />
							<input type="text" class="hm-psr-date-dynamic-field'.(empty($reportSettings['report_end_dynamic']) ? ' hidden' : '').'" name="report_end_dynamic" value="'.esc_attr($reportSettings['report_end_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['report_end_dynamic']) ? 'dynamic' : 'fixed').' date</a>
                     
						<input type="text" name="report_end_time" id="hm_sbp_field_report_end_time" value="'.esc_attr($reportSettings['report_end_time']).'" />
                        </div>
                    </div>
                    <p class="ags-psr-settings-description">Enter dates in the format YYYY-MM-DD and times in the format hour:minute:second (AM/PM optional). The end time is exclusive.</p>
                </div>
                
                 <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-cb-list">
                        <label class="ags-psr-settings-title">
                           <span class="label">Include Orders With Status:</span>
                         </label>
                        <div class="ags-psr-settings-content">');
foreach (wc_get_order_statuses() as $status => $statusName) {
                echo('<label class="ags-psr-settings-cb-list-item"><input type="checkbox" name="order_statuses[]"' . (in_array($status, $reportSettings['order_statuses']) ? ' checked="checked"' : '') . ' value="' . esc_attr($status) . '" /> ' . esc_html($statusName) . '</label>');
}
            echo('</div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Only Orders With Field:</span>
						</label>
                        <div id="hm_psr_order_meta_filter_settings" class="ags-psr-settings-content">
                            <input type="checkbox" name="order_meta_filter_on" value="1"' . (empty($reportSettings['order_meta_filter_on']) ? '' : ' checked="checked"') . ' />
						<select name="order_meta_filter_key" class="hm-psr-select-other">
			');
            $orderFieldFound = false;
			foreach (HM_Product_Sales_Report_Pro::getOrderFieldNames() as $orderField) {
				$orderFieldFound = $orderFieldFound || $reportSettings['order_meta_filter_key'] == $orderField;
				echo('<option value="'.esc_attr($orderField).'"'.($reportSettings['order_meta_filter_key'] == $orderField ? ' selected="selected"' : '').'>'.esc_html($orderField).'</option>');
			}
            if (!$orderFieldFound) {
				echo('<option value="'.esc_attr($reportSettings['order_meta_filter_key']).'" selected>'.esc_html($reportSettings['order_meta_filter_key']).'</option>');
			}
			echo('
						</select>
						<select id="hm_psr_order_meta_filter_op" name="order_meta_filter_op">
							<option value="="'.($reportSettings['order_meta_filter_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['order_meta_filter_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['order_meta_filter_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['order_meta_filter_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['order_meta_filter_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['order_meta_filter_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['order_meta_filter_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
							<option value="NOTEXISTS"'.($reportSettings['order_meta_filter_op'] == 'NOTEXISTS' ? ' selected="selected"' : '').'>does not exist</option>
						</select>
						<span class="hm_psr_filter_value_container">
							<input type="text" id="hm_psr_order_meta_filter_value" name="order_meta_filter_value" value="'.esc_attr(empty($reportSettings['order_meta_filter_value_dynamic']) ? $reportSettings['order_meta_filter_value'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_meta_filter_value_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_meta_filter_value_dynamic']) ? '' : ' disabled="disabled"').' />
							<input type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_meta_filter_value_dynamic']) ? ' hidden' : '').'" name="order_meta_filter_value_dynamic" value="'.esc_attr($reportSettings['order_meta_filter_value_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_meta_filter_value_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
						</span>
						<span id="hm_psr_order_meta_filter_value_2" style="display: none;">
							and
							<span class="hm_psr_order_meta_filter_value_container">
								<input type="text" name="order_meta_filter_value_2" value="'.esc_attr(empty($reportSettings['order_meta_filter_value_2_dynamic']) ? $reportSettings['order_meta_filter_value_2'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_meta_filter_value_2_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_meta_filter_value_2_dynamic']) ? '' : ' disabled="disabled"').' />
								<input type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_meta_filter_value_2_dynamic']) ? ' hidden' : '').'" name="order_meta_filter_value_2_dynamic" value="'.esc_attr($reportSettings['order_meta_filter_value_2_dynamic']).'" placeholder="e.g. -7 days" />
								<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_meta_filter_value_2_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
							</span>
						</span>
                        </div>
                    </div>
					<div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label" style="display: none;">Only Orders With Field 2:</span>
						</label>
                        <div id="hm_psr_order_meta_filter_2_settings" class="ags-psr-settings-content">
                            <input type="checkbox" name="order_meta_filter_2_on" value="1"' . (empty($reportSettings['order_meta_filter_2_on']) ? '' : ' checked="checked"') . ' />
							
						<select style="width: auto;" name="order_meta_filter_2_logic">
							<option value="AND"'.($reportSettings['order_meta_filter_2_logic'] == 'AND' ? ' selected="selected"' : '').'>and</option>
							<option value="OR"'.($reportSettings['order_meta_filter_2_logic'] == 'OR' ? ' selected="selected"' : '').'>or</option>
						</select>
						<select name="order_meta_filter_2_key" class="hm-psr-select-other">
			');
            $orderFieldFound = false;
			foreach (HM_Product_Sales_Report_Pro::getOrderFieldNames() as $orderField) {
				$orderFieldFound = $orderFieldFound || $reportSettings['order_meta_filter_2_key'] == $orderField;
				echo('<option value="'.esc_attr($orderField).'"'.($reportSettings['order_meta_filter_2_key'] == $orderField ? ' selected="selected"' : '').'>'.esc_html($orderField).'</option>');
			}
            if (!$orderFieldFound) {
				echo('<option value="'.esc_attr($reportSettings['order_meta_filter_2_key']).'" selected>'.esc_html($reportSettings['order_meta_filter_2_key']).'</option>');
			}
			echo('
						</select>
						<select id="hm_psr_order_meta_filter_2_op" name="order_meta_filter_2_op">
							<option value="="'.($reportSettings['order_meta_filter_2_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['order_meta_filter_2_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['order_meta_filter_2_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['order_meta_filter_2_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['order_meta_filter_2_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['order_meta_filter_2_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['order_meta_filter_2_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
							<option value="NOTEXISTS"'.($reportSettings['order_meta_filter_2_op'] == 'NOTEXISTS' ? ' selected="selected"' : '').'>does not exist</option>
						</select>
						<span class="hm_psr_filter_value_container">
							<input type="text" id="hm_psr_order_meta_filter_2_value" name="order_meta_filter_2_value" value="'.esc_attr(empty($reportSettings['order_meta_filter_2_value_dynamic']) ? $reportSettings['order_meta_filter_2_value'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_meta_filter_2_value_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_meta_filter_2_value_dynamic']) ? '' : ' disabled="disabled"').' />
							<input type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_meta_filter_2_value_dynamic']) ? ' hidden' : '').'" name="order_meta_filter_2_value_dynamic" value="'.esc_attr($reportSettings['order_meta_filter_2_value_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_meta_filter_2_value_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
						</span>
						<span id="hm_psr_order_meta_filter_2_value_2" style="display: none;">
							and
							<span class="hm_psr_order_meta_filter_2_value_container">
								<input type="text" name="order_meta_filter_2_value_2" value="'.esc_attr(empty($reportSettings['order_meta_filter_2_value_2_dynamic']) ? $reportSettings['order_meta_filter_2_value_2'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_meta_filter_2_value_2_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_meta_filter_2_value_2_dynamic']) ? '' : ' disabled="disabled"').' />
								<input type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_meta_filter_2_value_2_dynamic']) ? ' hidden' : '').'" name="order_meta_filter_2_value_2_dynamic" value="'.esc_attr($reportSettings['order_meta_filter_2_value_2_dynamic']).'" placeholder="e.g. -7 days" />
								<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_meta_filter_2_value_2_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
							</span>
						</span>
                        </div>
                    </div>
                </div>
				
				<div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Only Order Items With Field:</span>
						</label>
                        <div id="hm_psr_order_item_meta_filter_settings_1" class="ags-psr-settings-content">
                            <input type="checkbox" name="order_item_meta_filter_1_on" value="1"' . (empty($reportSettings['order_item_meta_filter_1_on']) ? '' : ' checked="checked"') . ' />
						<select name="order_item_meta_filter_1_key" class="hm-psr-select-other" style="width: auto;">
			');
			$orderItemFields = hm_psr_get_order_item_fields();
			
            $orderItemFieldFound = false;
			foreach ($orderItemFields as $orderItemField) {
				$orderItemFieldFound = $orderItemFieldFound || $reportSettings['order_item_meta_filter_1_key'] == $orderItemField;
				echo('<option value="'.esc_attr($orderItemField).'"'.($reportSettings['order_item_meta_filter_1_key'] == $orderItemField ? ' selected="selected"' : '').'>'.esc_html($orderItemField).'</option>');
			}
            if (!$orderItemFieldFound) {
				echo('<option value="'.esc_attr($reportSettings['order_item_meta_filter_1_key']).'" selected>'.esc_html($reportSettings['order_item_meta_filter_1_key']).'</option>');
			}
			echo('
						</select>
						<select style="width: auto;" id="hm_psr_order_item_meta_filter_1_op" name="order_item_meta_filter_1_op">
							<option value="="'.($reportSettings['order_item_meta_filter_1_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['order_item_meta_filter_1_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['order_item_meta_filter_1_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['order_item_meta_filter_1_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['order_item_meta_filter_1_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['order_item_meta_filter_1_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['order_item_meta_filter_1_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
							<option value="NOTEXISTS"'.($reportSettings['order_item_meta_filter_1_op'] == 'NOTEXISTS' ? ' selected="selected"' : '').'>does not exist</option>
						</select>
						<span class="hm_psr_filter_value_container">
							<input type="text" style="width: auto;" id="hm_psr_order_item_meta_filter_1_value" name="order_item_meta_filter_1_value" value="'.esc_attr(empty($reportSettings['order_item_meta_filter_1_value_dynamic']) ? $reportSettings['order_item_meta_filter_1_value'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_item_meta_filter_1_value_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_item_meta_filter_1_value_dynamic']) ? '' : ' disabled="disabled"').' />
							<input type="text" style="width: auto;" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_item_meta_filter_1_value_dynamic']) ? ' hidden' : '').'" name="order_item_meta_filter_1_value_dynamic" value="'.esc_attr($reportSettings['order_item_meta_filter_1_value_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_item_meta_filter_1_value_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
						</span>
						<span id="hm_psr_order_item_meta_filter_1_value_2" style="display: none;">
							and
							<span class="hm_psr_order_item_meta_filter_1_value_container">
								<input type="text" style="width: auto;" name="order_item_meta_filter_1_value_2" value="'.esc_attr(empty($reportSettings['order_item_meta_filter_1_value_2_dynamic']) ? $reportSettings['order_item_meta_filter_1_value_2'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_item_meta_filter_1_value_2_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_item_meta_filter_1_value_2_dynamic']) ? '' : ' disabled="disabled"').' />
								<input type="text" style="width: auto;" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_item_meta_filter_1_value_2_dynamic']) ? ' hidden' : '').'" name="order_item_meta_filter_1_value_2_dynamic" value="'.esc_attr($reportSettings['order_item_meta_filter_1_value_2_dynamic']).'" placeholder="e.g. -7 days" />
								<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_item_meta_filter_1_value_2_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
							</span>
						</span>
						</div>
						</div>
						
						
						 <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label" style="display: none;">Only Order Items With Field 2:</span>
						</label>
                        <div id="hm_psr_order_item_meta_filter_settings_2" class="ags-psr-settings-content">
						<select style="width: auto;" name="order_item_meta_filter_2_logic">
							<option value="AND"'.($reportSettings['order_item_meta_filter_2_logic'] == 'AND' ? ' selected="selected"' : '').'>and</option>
							<option value="OR"'.($reportSettings['order_item_meta_filter_2_logic'] == 'OR' ? ' selected="selected"' : '').'>or</option>
						</select>
						<input type="checkbox" name="order_item_meta_filter_2_on" value="1"' . (empty($reportSettings['order_item_meta_filter_2_on']) ? '' : ' checked="checked"') . ' />
						
						<select style="width: auto;" name="order_item_meta_filter_2_key" class="hm-psr-select-other">
			');
			$orderItemFields = hm_psr_get_order_item_fields();
			
            $orderItemFieldFound = false;
			foreach ($orderItemFields as $orderItemField) {
				$orderItemFieldFound = $orderItemFieldFound || $reportSettings['order_item_meta_filter_2_key'] == $orderItemField;
				echo('<option value="'.esc_attr($orderItemField).'"'.($reportSettings['order_item_meta_filter_2_key'] == $orderItemField ? ' selected="selected"' : '').'>'.esc_html($orderItemField).'</option>');
			}
            if (!$orderItemFieldFound) {
				echo('<option value="'.esc_attr($reportSettings['order_item_meta_filter_2_key']).'" selected>'.esc_html($reportSettings['order_item_meta_filter_2_key']).'</option>');
			}
			echo('
						</select>
						<select style="width: auto;" id="hm_psr_order_item_meta_filter_2_op" name="order_item_meta_filter_2_op">
							<option value="="'.($reportSettings['order_item_meta_filter_2_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['order_item_meta_filter_2_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['order_item_meta_filter_2_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['order_item_meta_filter_2_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['order_item_meta_filter_2_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['order_item_meta_filter_2_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['order_item_meta_filter_2_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
							<option value="NOTEXISTS"'.($reportSettings['order_item_meta_filter_2_op'] == 'NOTEXISTS' ? ' selected="selected"' : '').'>does not exist</option>
						</select>
						<span class="hm_psr_filter_value_container">
							<input style="width: auto;" type="text" id="hm_psr_order_item_meta_filter_2_value" name="order_item_meta_filter_2_value" value="'.esc_attr(empty($reportSettings['order_item_meta_filter_2_value_dynamic']) ? $reportSettings['order_item_meta_filter_2_value'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_item_meta_filter_2_value_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_item_meta_filter_2_value_dynamic']) ? '' : ' disabled="disabled"').' />
							<input style="width: auto;" type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_item_meta_filter_2_value_dynamic']) ? ' hidden' : '').'" name="order_item_meta_filter_2_value_dynamic" value="'.esc_attr($reportSettings['order_item_meta_filter_2_value_dynamic']).'" placeholder="e.g. -7 days" />
							<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_item_meta_filter_2_value_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
						</span>
						<span id="hm_psr_order_item_meta_filter_2_value_2" style="display: none;">
							and
							<span class="hm_psr_order_item_meta_filter_2_value_container">
								<input style="width: auto;" type="text" name="order_item_meta_filter_2_value_2" value="'.esc_attr(empty($reportSettings['order_item_meta_filter_2_value_2_dynamic']) ? $reportSettings['order_item_meta_filter_1_value_2'] : HM_Product_Sales_Report_Pro::resolveDynamicDate($reportSettings['order_item_meta_filter_2_value_2_dynamic'], true, $reportSettings['use_wp_date'])).'"'.(empty($reportSettings['order_item_meta_filter_2_value_2_dynamic']) ? '' : ' disabled="disabled"').' />
								<input style="width: auto;" type="text" class="hm-psr-date-dynamic-field hm-psr-date-dynamic-field-with-format'.(empty($reportSettings['order_item_meta_filter_2_value_2_dynamic']) ? ' hidden' : '').'" name="order_item_meta_filter_2_value_2_dynamic" value="'.esc_attr($reportSettings['order_item_meta_filter_2_value_2_dynamic']).'" placeholder="e.g. -7 days" />
								<a href="javascript:void(0);" class="hm-psr-date-dynamic-toggle">'.(empty($reportSettings['order_item_meta_filter_2_value_2_dynamic']) ? 'dynamic date' : 'fixed value').'</a>
							</span>
						</span>
                        </div>
                    </div>
                    
                    <div class="ags-psr-settings-tooltip tooltip-visible">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Note: If you are including line-item refunds in the report, the order item field filtering settings will apply to the refund line items using the fields on those line items, not the original line items. The order item field filtering settings do not affect shipping items.                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
                    <label>
                       <span class="label">Include Orders by Customer Role:</span>
						<select name="customer_role">
							<option value="0"'.(empty($reportSettings['customer_role']) ? ' selected="selected"' : '').'>(All Customers)</option>
							<option value="-1"'.($reportSettings['customer_role'] == -1 ? ' selected="selected"' : '').'>(Guest Customers)</option>');
							foreach ($wp_roles->roles as $roleId => $role) {
								echo('<option value="'.esc_attr($roleId).'"'.($reportSettings['customer_role'] === $roleId ? ' selected="selected"' : '').'>'.esc_html($role['name']).'</option>');
							}
echo('						</select>
						</label>
                </div>');
				
				$wcMemberships = hm_psr_get_wc_membership_plans();
				if ($wcMemberships) {
				
echo('
				<div class="ags-psr-settings-box">
                    <label>
                       <span class="label">Include Orders by Customer Membership:</span>
						<select name="wc_membership">
							<option value="0"'.(empty($reportSettings['wc_membership']) ? ' selected="selected"' : '').'>(All Customers)</option>
							<option value="-1"'.($reportSettings['wc_membership'] == -1 ? ' selected="selected"' : '').'>(Customers Without Membership)</option>
							<option value="-2"'.($reportSettings['wc_membership'] == -1 ? ' selected="selected"' : '').'>(Customers With Any Membership)</option>');
							foreach ($wcMemberships as $membershipId => $membershipName) {
								echo('<option value="'.((int) $membershipId).'"'.($reportSettings['wc_membership'] == $membershipId ? ' selected="selected"' : '').'>'.esc_html($membershipName).'</option>');
							}
echo('						</select>
						</label>
						<div class="ags-psr-settings-tooltip tooltip-hover">
							<div class="ags-psr-settings-tooltiptext ">
								<span>Help</span>
								This feature works with the WooCommerce Memberships plugin. Filtering is based on the customer\'s current active membership(s), which may be different than the memberships active at the time of the order.
							</div>
						</div>
                </div>
				
				');
				
				}
echo('
                
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Only Orders from Customers With Field:</span>
                         </label>
                        <div id="hm_psr_customer_meta_filter_settings" class="ags-psr-settings-content">
                            <input type="checkbox" name="customer_meta_filter_on" value="1"' . (empty($reportSettings['customer_meta_filter_on']) ? '' : ' checked="checked"') . ' />
						<select name="customer_meta_filter_key" class="hm-psr-select-other">
			');
			$customerFieldFound = false;
			foreach (HM_Product_Sales_Report_Pro::getCustomerFieldNames() as $customerField) {
				$customerFieldFound = $customerFieldFound || $reportSettings['customer_meta_filter_key'] == $customerField;
				echo('<option value="'.esc_attr($customerField).'"'.($reportSettings['customer_meta_filter_key'] == $customerField ? ' selected="selected"' : '').'>'.esc_html($customerField).'</option>');
			}
            if (!$customerFieldFound) {
				echo('<option value="'.esc_attr($reportSettings['customer_meta_filter_key']).'" selected>'.esc_html($reportSettings['customer_meta_filter_key']).'</option>');
			}
			echo('
						</select>
						<select id="hm_psr_customer_meta_filter_op" name="customer_meta_filter_op">
							<option value="="'.($reportSettings['customer_meta_filter_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['customer_meta_filter_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['customer_meta_filter_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['customer_meta_filter_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['customer_meta_filter_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['customer_meta_filter_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['customer_meta_filter_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
							<option value="NOTEXISTS"'.($reportSettings['customer_meta_filter_op'] == 'NOTEXISTSs' ? ' selected="selected"' : '').'>does not exist</option>
						</select>
						<input type="text" id="hm_psr_customer_meta_filter_value" name="customer_meta_filter_value" value="'.esc_attr($reportSettings['customer_meta_filter_value']).'" />
						<span id="hm_psr_customer_meta_filter_value_2" style="display: none;">
							and
							<input type="text" name="customer_meta_filter_value_2" value="'.esc_attr($reportSettings['customer_meta_filter_value_2']).'" />
						</span>
                        </div>
                    </div>
                </div>
			
            </div> <!-- hm_psr_tab_orders_panel -->
			
			<div id="hm_psr_tab_products_panel" class="hm_psr_tab_panel">
			
			  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-cb-list">
                        <label class="ags-psr-settings-title">
                           <span class="label">Include Products:</span>
                         </label>
                        <div class="ags-psr-settings-content">
                            <label class="ags-psr-settings-cb-list-item">
                                <input type="radio" name="products" value="all"' . ($reportSettings['products'] == 'all' ? ' checked="checked"' : '') . ' /> All products
                            </label>
						    <label class="ags-psr-settings-cb-list-item">
						        <input type="radio" name="products" value="cats"' . ($reportSettings['products'] == 'cats' ? ' checked="checked"' : '') . ' /> Products in categories:
						    </label>
						    <label class="ags-psr-settings-cb-list-item ags-psr-settings-cb-list-item-child">
						<ul id="hm-psr-product-cats">
					');
					wp_terms_checklist(0, array('selected_cats' => $reportSettings['product_cats'], 'taxonomy' => 'product_cat', 'checked_ontop' => false));
			echo('
						</ul>
						</label>
                            <label class="ags-psr-settings-cb-list-item">
                                <input type="radio" name="products" value="ids"' . ($reportSettings['products'] == 'ids' ? ' checked="checked"' : '') . ' /> Product ID(s):
                            </label> 
                            <label class="ags-psr-settings-cb-list-item ags-psr-settings-cb-list-item-child">
                                <input type="text" name="product_ids" placeholder="Use commas to separate multiple product IDs" value="' . esc_attr($reportSettings['product_ids']) . '" />
                            </label>
                        </div>
                    </div>
                </div>
                
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Only Products Tagged:</span>
                         </label>
                        <div id="hm_psr_product_tag_filter_settings" class="ags-psr-settings-content">
                            <input type="checkbox" name="product_tag_filter_on" value="1"' . (empty($reportSettings['product_tag_filter_on']) ? '' : ' checked="checked"') . ' />
                            <input type="text" id="hm_psr_product_tag_filter" name="product_tag_filter" value="' . esc_attr($reportSettings['product_tag_filter']) . '" />
			
							<select id="hm_psr_product_tag_filter_select">
								<option value="">Select tag...</option>');
							foreach (get_terms(array('taxonomy' => 'product_tag', 'hide_empty' => false, 'fields' => 'names')) as $term) {
								echo('<option value="'.esc_attr($term).'">'.esc_html($term).'</option>');
							}
						echo('</select>
						</div>
                    </div>
                </div>
				
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Only Products With Field:</span>
						</label>
                        <div id="hm_psr_product_meta_filter_settings" class="ags-psr-settings-content">
                            <input type="checkbox" name="product_meta_filter_on" value="1"' . (empty($reportSettings['product_meta_filter_on']) ? '' : ' checked="checked"') . ' />
						<select name="product_meta_filter_key" class="hm-psr-select-other">
			');
			$productFieldFound = false;
			foreach (HM_Product_Sales_Report_Pro::getCustomFieldNames(false, true) as $customField) {
				
				$productFieldFound = $productFieldFound || $reportSettings['product_meta_filter_key'] == $customField;
				$taxonomy = substr($customField, 0, 10) == 'taxonomy::' ? substr($customField, 10) : null;
				echo(
					'<option value="'.esc_attr($customField).'"'.($reportSettings['product_meta_filter_key'] == $customField ? ' selected="selected"' : '')
					.($taxonomy ? ' data-ags-terms="'.esc_attr(implode(',', array_map(function($term) {
						return str_replace(',', '_AGS_COMMA_', $term);
					}, get_terms(['taxonomy' => $taxonomy, 'fields' => 'names'])))).'"' : '')
					.'>'
					.esc_html($taxonomy ? 'Taxonomy '.$taxonomy : $customField )
					.'</option>'
				);
			}
            if (!$productFieldFound) {
				echo(
					'<option value="'.esc_attr($reportSettings['product_meta_filter_key']).'" selected>'
					.esc_html( $reportSettings['product_meta_filter_key'] )
					.'</option>'
				);
			}
			echo('
						</select>
						<select id="hm_psr_product_meta_filter_op" name="product_meta_filter_op">
							<option value="="'.($reportSettings['product_meta_filter_op'] == '=' ? ' selected="selected"' : '').'>equal to</option>
							<option value="!="'.($reportSettings['product_meta_filter_op'] == '!=' ? ' selected="selected"' : '').'>not equal to</option>
							<option value="&lt;"'.($reportSettings['product_meta_filter_op'] == '<' ? ' selected="selected"' : '').'>less than</option>
							<option value="&lt;="'.($reportSettings['product_meta_filter_op'] == '<=' ? ' selected="selected"' : '').'>less than or equal to</option>
							<option value="&gt;"'.($reportSettings['product_meta_filter_op'] == '>' ? ' selected="selected"' : '').'>greater than</option>
							<option value="&gt;="'.($reportSettings['product_meta_filter_op'] == '>=' ? ' selected="selected"' : '').'>greater than or equal to</option>
							<option value="BETWEEN"'.($reportSettings['product_meta_filter_op'] == 'BETWEEN' ? ' selected="selected"' : '').'>between</option>
						</select>
						<select class="hm-psr-value-preset" data-hm-psr-for="product_meta_filter_value">
							<option value="">value:</option>
							<option value="@@HM_PSR_USER_ID">current user ID</option>
						</select>
						<input type="text" name="product_meta_filter_value" value="'.esc_attr($reportSettings['product_meta_filter_value']).'" />
						<span id="hm_psr_product_meta_filter_value_2" style="display: none;"> and
							<input type="text" name="product_meta_filter_value_2" value="'.esc_attr($reportSettings['product_meta_filter_value_2']).'" />
						</span>
                        </div>
						
                    </div>
						
					<div class="ags-psr-settings-tooltip tooltip-visible">
						<div class="ags-psr-settings-tooltiptext">
							<span>Help</span>
							Product field filtering is only applied on the main product, not product variations.
						</div>
					</div>
					
                </div>
                
                <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-cb-list">
                        <label class="ags-psr-settings-title">
                           <span class="label">Product Variations:</span>
                         </label>
                        <div class="ags-psr-settings-content">
                            <label class="ags-psr-settings-cb-list-item">
							<input type="radio" name="variations" value="0"'.(empty($reportSettings['variations']) ? ' checked="checked"' : '').' class="hm_psr_variations_fld" />
							Group product variations together
                            </label>
                            <label class="ags-psr-settings-cb-list-item">
							<input type="radio" name="variations" value="1"'.(empty($reportSettings['variations']) ? '' : ' checked="checked"').(HM_PSR_IS_PRO ? '' : ' disabled="disabled"').' class="hm_psr_variations_fld" />
							Report on each variation separately
						</label>
                        </div>
                    </div>
                </div>
				
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include products with no sales matching the filtering criteria</span>
							<input type="checkbox" name="include_nil" value="1"'.(empty($reportSettings['include_nil']) ? '' : ' checked="checked"').' />
						</label>
                </div>   
				
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include unpublished products</span>
							<input type="checkbox" name="include_unpublished" value="1"'.(empty($reportSettings['include_unpublished']) ? '' : ' checked="checked"').' />
						</label>
                </div>   
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Exclude free products</span>
							<input type="checkbox" name="exclude_free" value="1"'.(empty($reportSettings['exclude_free']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-visible">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            If checked, order line items with a total amount of zero (after discounts) will be excluded from the report calculations.
                        </div>
                    </div>
                </div>   
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include shipping</span>
							<input type="checkbox" name="include_shipping" value="1"'.(empty($reportSettings['include_shipping']) ? '' : ' checked="checked"').' />
						</label>
                </div>  
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include line-item refunds</span>
							<input type="checkbox" name="refunds" value="1"'.(empty($reportSettings['refunds']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-visible">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
							Note: This setting <strong>only applies to refunds that are entered on a line-item basis</strong>. This means that refund orders generated by changing the order status to Refunded, and refund orders created by simply entering a total refund amount instead of line-item specific amounts and/or quantities, will not be reflected by this setting. Fully refunded orders (i.e. Refunded status) can be included/excluded from the report using the <strong>Order Filtering &gt; Include Orders With Status</strong> setting. If a Refunded status order also has a line-item refund, it may still be deducted from the report if this option is enabled and the Refunded order status is included.<br><br>
                            If checked, sales amounts and quantities will include deductions for refunds <b>entered</b> during the report date range (regardless of the original order date).<br /><br />
						If unchecked, line-item refunds will not be reflected in the report (except in specifically refund-related fields such as &quot;Quantity Refunded&quot;).<br /><br />
						In either case, only refunds with &quot;Completed&quot; status (made on orders with the statuses defined in the Order Filtering tab) are included in the applicable data.<br /><br />
						For shipping items, while refund amounts are reflected in the report, quantities are not.
                        </div>
                    </div>
                </div> 
			
            </div> <!-- hm_psr_tab_products_panel -->
			
			');
			
			$groupByFields = hm_psr_get_groupby_fields();
			
			echo('
			
			<div id="hm_psr_tab_groupsort_panel" class="hm_psr_tab_panel">
			
			  <div class="ags-psr-settings-box">
			  
			  ');
			
			for ($i = 1; $i < 4; ++$i) {
				$fieldName = 'groupby'.($i == 1 ? '' : $i);
				echo('
						<div class="ags-psr-settings-cb-list">
							<label class="ags-psr-settings-title" for="hm_psr_field_'.esc_attr($fieldName).'">
							   <span class="label">Group By '.((int) $i).':</span>
							 </label>
							<div class="ags-psr-settings-content">
								<label class="ags-psr-settings-cb-list-item">
							<select name="'.esc_attr($fieldName).'" id="hm_psr_field_'.esc_attr($fieldName).'">
								<option value="">(None)</option>
								<optgroup label="Order" class="hm-psr-select-other" data-hm-psr-other-field-prefix="o_">');
				$foundGroupByField = false;
				foreach ($groupByFields as $optionId => $optionName) {
					if ($optionId[0] == 'i' && empty($isOrderItemField)) {
						if (!$foundGroupByField && !empty($reportSettings[$fieldName]) && $reportSettings[$fieldName][0] == 'o') {
							$foundGroupByField = true;
							echo('<option value="'.esc_attr($reportSettings[$fieldName]).'" selected>'.esc_html(substr($reportSettings[$optionName], 2)).'</option>');
						}
						echo('</optgroup><optgroup label="Order Line Item" class="hm-psr-select-other" data-hm-psr-other-field-prefix="i_">');
						$isOrderItemField = true;
					}
					$foundGroupByField = $foundGroupByField || $reportSettings[$fieldName] == $optionId;
					echo('<option value="'.esc_attr($optionId).'"'.($reportSettings[$fieldName] == $optionId ? ' selected="selected"' : '').'>'.esc_html($optionName).'</option>');
				}
				if (!$foundGroupByField && !empty($reportSettings[$fieldName])) {
					echo('<option value="'.esc_attr($reportSettings[$fieldName]).'" selected>'.esc_html(substr($reportSettings[$fieldName], 2)).'</option>');
				}
				echo('			</optgroup>
							</select>
								</label>
							</div>
						</div>
				');
			}
			echo('
                    <div class="ags-psr-settings-description">
                        <p><b>Important:</b> Do not choose a field that is already included in the report or that a field in the report from the <strong>Built-in Fields</strong> category may depend on.</p>
                        <p>For example:</p>
                        <ul>
                            <li>Do not use the <b>Order Line Item &gt; _qty</b> field for grouping if the report has that field or the <b>Quantity Sold</b> or <b>Quantity Refunded</b> fields are in use.</li>
                            <li>Do not use the <b>Order Line Item &gt; _line_subtotal</b> field if that field or any of the following fields are in use: <b>Gross Sales</b>, <b>Total Discount Amount</b>, <b>Gross Amount Refunded (Excl. Tax)</b>, <b>Gross Amount Refunded (Incl. Tax)</b>.</li>
                            <li>Do not use the <b>Order Line Item &gt; _line_total</b> field if that field or any of the following fields are in use: Gross Sales (After Discounts), Total Discount Amount, Total Sales Including Tax.</li>
                            <li>Do not use the <b>Order Line Item &gt; _line_tax field</b> if that field or any of the following fields are in use: Taxes, Total Sales Including Tax, Gross Amount Refunded (Incl. Tax), Tax Refunded</li> 
                        </ul>
                        <p>This is not an exhaustive list of built-in fields that may conflict with fields in the group by dropdown. If you are unsure whether your Group By setting may conflict with a built-in field that you are using in the same report, please contact support.</p>
						The Group By field will also appear in the report. You can change its label and position in the Report Fields tab.<br>
                        <p>If you have enabled inclusion of line item refunds, please note that the Group By setting will be applied to the selected field in the line item refund (shop_order_refund post and line items), not in the original order.</p>
                        <p>Field names containing spaces or dashes (-) may not be supported.</p>
                    </div>
                </div>
				
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title" for="hm_sbp_field_orderby">
                           <span class="label">Product Grouping:</span>
                         </label>
                        <div class="ags-psr-settings-content">
							<label>
								<input id="hm_psr_disable_product_grouping" type="checkbox" name="disable_product_grouping" value="1"'.(empty($reportSettings['disable_product_grouping']) ? '' : ' checked' ).'>
								Don\'t group by products/variations
							</label>
							
                        </div>
                    </div>
					<div class="ags-psr-settings-tooltip tooltip-visible">
							<div class="ags-psr-settings-tooltiptext">
								<span>Help</span>
								This option is currently <strong>experimental</strong>. Please be sure to check the output to ensure it is what you expect!<br>
								If this option is enabled, the following options will be of no effect or disabled:
								<ul>
									<li>Product Variations (Group product variations together / Report on each variation separately)</li>
									<li>Include products with no sales matching the filtering criteria</li>
									<li>Include line-item refunds</li>
								</ul>
								Also, product related fields will not be accessible and any product related fields already in your report will be removed.
							</div>
						</div>
                </div>
                
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title" for="hm_sbp_field_orderby">
                           <span class="label">Sort By:</span>
                         </label>
                        <div class="ags-psr-settings-content">
						<select name="orderby" id="hm_sbp_field_orderby" class="hm-psr-input-fullwidth">
							<option value="'.esc_attr($orderBy).'">'.esc_html($orderBy).'</option>
						</select>
						<select name="orderdir" class="hm-psr-input-fullwidth">
							<option value="asc"'.($reportSettings['orderdir'] == 'asc' ? ' selected="selected"' : '').'>ascending</option>
							<option value="desc"'.($reportSettings['orderdir'] == 'desc' ? ' selected="selected"' : '').'>descending</option>
						</select>
                        </div>
                    </div>
                </div>
            
            </div> <!-- hm_psr_tab_groupsort_panel -->
			
			<div id="hm_psr_tab_fields_panel" class="hm_psr_tab_panel">
			
			  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-cb-list">
                        <label class="ags-psr-settings-title">
                           <span class="label">Report Fields:</span>
                         </label>
                        <div class="ags-psr-settings-content">
                            <div id="hm_psr_report_field_selection">
                                <div id="hm_psr_report_fields">');
$customFields = HM_Product_Sales_Report_Pro::getCustomFieldNames(true);
$addonFields = HM_Product_Sales_Report_Pro::getAddonFields();
$noTotalFields = array('builtin::product_id', 'builtin::product_sku', 'builtin::product_name', 'builtin::variation_id', 'builtin::variation_sku', 'builtin::variation_attributes',
						'builtin::product_categories', 'order_id', 'order_status', 'order_date', 'billing_name', 'billing_phone',
						'builtin::publish_time', 'builtin::product_desc', 'builtin::product_excerpt', 'builtin::product_menu_order');
foreach ($reportSettings['fields'] as $fieldId) {
	if (!isset($fieldOptions[$fieldId]) && !isset($customFields[$fieldId]) && !isset($addonFields[$fieldId]) && $fieldId != 'builtin::groupby_field') {
		
		// Compatibility with pre-1.6.9 versions that didn't have the builtin:: prefix
		if (isset($fieldOptions['builtin::'.$fieldId])) {
			if (isset($reportSettings['field_names'][$fieldId])) {
				$reportSettings['field_names']['builtin::'.$fieldId] = $reportSettings['field_names'][$fieldId];
			}
			$fieldId = 'builtin::'.$fieldId;
		}
		
	}
	echo('<div'.(in_array($fieldId, array('builtin::variation_id', 'builtin::variation_sku', 'builtin::variation_attributes')) || substr($fieldId, 0, 11) == 'variation::' ? ' class="hm_psr_variation_field"' : ($fieldId == 'builtin::groupby_field' || $fieldId == 'builtin::groupby_field2' || $fieldId == 'builtin::groupby_field3' ? ' class="hm_psr_'.substr($fieldId, 9).'"' : '')).'>
			<input type="hidden" name="fields[]" value="'.esc_attr($fieldId).'" />
			<button type="button" onclick="hm_psr_remove_field(this);"><span class="dashicons dashicons-no"></span></button>
			<input type="text" class="hm_psr_field_name" name="field_names['.esc_attr($fieldId).']" value="'.esc_attr(isset($reportSettings['field_names'][$fieldId]) ? $reportSettings['field_names'][$fieldId] : (isset($fieldOptions[$fieldId]) ? $fieldOptions[$fieldId] : $fieldId)).'" />
			<span class="ags-xoiwcp-drag-drop"></span>
			<label class="hm_psr_total_field'.(in_array($fieldId, $noTotalFields) ? ' no-total' : '').'"><span>Total</span><input type="checkbox" name="total_fields[]" value="'.esc_attr($fieldId).'"'.(in_array($fieldId, $reportSettings['total_fields']) ? ' checked="checked"' : '').' /></label>'
			.'</div>');
}

            echo('</div>
			<p class="instructions">Click and drag to the right of the field name text box to re-order fields.</p>
            <div id="hm_psr_report_add_custom_field">
                <strong>Add Field:</strong> <select id="hm_psr_custom_field">');
foreach (array_merge(array('Built-in Fields' => $fieldOptions), $customFields) as $fieldGroupName => $fields) {
	switch ($fieldGroupName) {
		case 'Product Variation':
			$fieldGroupPrefix = 'variation::';
			break;
		case 'Order Item':
			$fieldGroupPrefix = 'order_item_total::';
			break;
	}
	
	$optgroupClasses = [];
	if ( $fieldGroupName != 'Built-in Fields' && $fieldGroupName != 'Product Taxonomies' ) {
		$optgroupClasses[] = 'hm-psr-select-other';
	}
	
	if ( $fieldGroupName == 'Product' || $fieldGroupName == 'Product Taxonomies' || $fieldGroupName == 'Product Variation' ) {
		$optgroupClasses[] = 'hm-psr-product-fields';
	}
	
	echo('<optgroup label="'.esc_attr($fieldGroupName).'"'.($optgroupClasses ? ' class="'.implode(' ', $optgroupClasses).'"' : '').(isset($fieldGroupPrefix) ? ' data-hm-psr-other-field-prefix="'.esc_attr($fieldGroupPrefix).'"' : '').'>');
	foreach ($fields as $fieldId => $fieldDisplay) {
		$fieldClasses = '';
		if (in_array($fieldId, array('builtin::variation_id', 'builtin::variation_sku', 'builtin::variation_attributes')) || substr($fieldId, 0, 11) == 'variation::') {
			$fieldClasses = 'hm_psr_variation_field';
		}
		if (in_array($fieldId, [
															'builtin::product_id', 'builtin::variation_id', 'builtin::variation_sku', 'builtin::variation_attributes', 'builtin::product_sku',
															'builtin::product_categories', 'builtin::product_price', 'builtin::product_price_with_tax',
															'builtin::product_menu_order', 'builtin::product_stock', 'builtin::publish_time', 'builtin::product_desc', 'builtin::product_excerpt'
								]
		)) {
			$fieldClasses .= (empty($fieldClasses) ? '' : ' ').'hm-psr-product-field';
		}
		if (in_array($fieldId, $noTotalFields)) {
			$fieldClasses .= (empty($fieldClasses) ? '' : ' ').'no-total-field';
		}
		echo('<option value="'.esc_attr($fieldId).'"'.(empty($fieldClasses) ? '' : ' class="'.esc_attr($fieldClasses).'"').'>'.esc_html($fieldDisplay).'</option>');
	}
	echo('</optgroup>');
}
$addonFields = array_diff_key($addonFields, $fieldOptions, $customFields);
if (!empty($addonFields)) {
	echo('<optgroup label="Addon Fields">');
	foreach ($addonFields as $fieldId => $fieldData) {
		echo('<option value="'.esc_attr($fieldId).'">'.esc_html($fieldData['label']).'</option>');
	}
	echo('</optgroup>');
}
            echo('</select>
                                    <button type="button" class="ags-psr-button-dark" id="hm-psr-button-add-field">Add</button>
									<div class="ags-psr-settings-tooltip tooltip-visible">
										<div class="ags-psr-settings-tooltiptext">
											<span>Help</span>
											Note: The Quantity Refunded, Gross Amount Refunded, and Tax Refunded fields only work with line-item refunds. For more information, please see the note below the <strong>Product Filtering &gt; Include line-item refunds</strong> setting.
										</div>
									</div>
                                    <div class="ags-psr-settings-tooltip tooltip-hover">
                                        <div class="ags-psr-settings-tooltiptext ">
                                            <span>Help</span>
                                            Order Item field names containing spaces or dashes (-) are not supported.
                                        </div>
                                    </div>
                                 </div>
                                 
                            </div>
                        </div>
                    </div>
                    
                </div>

            </div> <!-- hm_psr_tab_fields_panel -->
			
			<div id="hm_psr_tab_display_panel" class="hm_psr_tab_panel">
			
			  <div class="ags-psr-settings-box">
                <div class="ags-psr-settings-multirow has-checkbox">
                    <label class="ags-psr-settings-title">
                       <span class="label">Products number</span>
                     </label>
                    <div class="ags-psr-settings-content">
							<input type="checkbox" name="limit_on" value="1"'.(empty($reportSettings['limit_on']) ? '' : ' checked="checked"').' />
							Show only the first
                        <input  id="hm_psr_limit_number" type="number" name="limit" value="' . esc_attr($reportSettings['limit']) . '" min="0" step="1" class="small-text" />
							products
                    </div>
                </div>
              </div>
              
              <div class="ags-psr-settings-box">
                     <div class="ags-psr-settings-multirow has-checkbox">
                        <label class="ags-psr-settings-title">
                           <span class="label">Include title:</span>
						</label>
                        <div class="ags-psr-settings-content">
							<input type="checkbox" name="report_title_on" value="1"'.(empty($reportSettings['report_title_on']) ? '' : ' checked="checked"').' />
                            <input type="text" name="report_title" value="' . esc_attr($reportSettings['report_title']) . '" class="hm-psr-input-fullwidth"/>
                        </div>
                    </div>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Dynamic field examples: [preset] [start] [start Y-m-d H:i:s] [end] [created]. Note: The start and end timestamps used here for display are both inclusive, so the end value may be different than what you set if you are using a custom date range.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include header row</span>
							<input type="checkbox" name="include_header" value="1"'.(empty($reportSettings['include_header']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            If checked, the first row of the report will contain the field names.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Include totals row</span>
							<input type="checkbox" id="hm_psr_field_include_totals" name="include_totals" value="1"'.(empty($reportSettings['include_totals']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            If checked, the last row of the report will contain totals.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Display amounts with two decimal places</span>
							<input type="checkbox" name="format_amounts" value="1"'.(empty($reportSettings['format_amounts']) ? '' : ' checked="checked"').' />
                    </label>
                    <div class="ags-psr-settings-tooltip tooltip-visible">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            All calculations are done based on the amounts stored in the WooCommerce database without intermediate rounding (except when the intermediate rounding option is enabled and applicable), so selecting this option may introduce small rounding variances.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Intermediate rounding</span>
							<input type="checkbox" name="intermediate_rounding" value="2"'.(empty($reportSettings['intermediate_rounding']) ? '' : ' checked="checked"').' />
                    </label>
                    <div class="ags-psr-settings-tooltip tooltip-visible">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Enabling this option will round certain order line item amounts to two decimal places before they are added to the total amount on any given row. This only applies to the following built-in fields: Gross Sales, Gross Sales (After Discounts), Total Discount Amount, Taxes, Total Sales Including Tax, Gross Amount Refunded (Excl. Tax), Gross Amount Refunded (Incl. Tax), Tax Refunded. Some of these fields are derived from other fields by addition or subtraction; for those fields, the rounding occurs before addition or subtraction.
                        </div>
                    </div>
                </div>
                
                  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-cb-list">
                        <label class="ags-psr-settings-title" for="hm_psr_field_format">
                           <span class="label">Format:</span>
                         </label>
                        <div id="hm_psr_field_format_settings" class="ags-psr-settings-content">
						<select name="format" id="hm_psr_field_format">
							<option value="csv"'.($reportSettings['format'] == 'csv' ? ' selected="selected"' : '').'>CSV</option>
							<option value="xlsx"'.($reportSettings['format'] == 'xlsx' ? ' selected="selected"' : '').'>XLSX</option>
							<option value="html"'.($reportSettings['format'] == 'html' ? ' selected="selected"' : '').'>HTML</option>
							<option value="html-enhanced"'.($reportSettings['format'] == 'html-enhanced' ? ' selected="selected"' : '').'>HTML (enhanced)</option>
						</select>
						<div id="hm_psr_format_options_csv" class="hm_psr_format_options">
							<label>
								Separate fields with:
								<input type="text" name="format_csv_delimiter" maxlength="1"'.(empty($reportSettings['format_csv_delimiter']) ? '' : ' value="'.esc_attr($reportSettings['format_csv_delimiter']).'"').'>
                                </label>
							<label>
								Surround fields with:
								<input type="text" name="format_csv_surround" maxlength="1"'.(empty($reportSettings['format_csv_surround']) ? '' : ' value="'.esc_attr($reportSettings['format_csv_surround']).'"').'>
                                </label>
							<label>
								Escape surround character with:
								<input type="text" name="format_csv_escape" maxlength="1"'.(empty($reportSettings['format_csv_escape']) ? '' : ' value="'.esc_attr($reportSettings['format_csv_escape']).'"').'>
							</label>
						</div>
                        </div>
                    </div>
                </div>
                
              <div class="ags-psr-settings-box">
                    <label for="hm_psr_field_filename">
                       <span class="label">Filename:</span>
						<input type="text" name="filename" id="hm_psr_field_filename" class="hm-psr-field-300" value="'.esc_attr($reportSettings['filename']).'" />
                    </label>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            An extension (e.g. &quot;.csv&quot;) will be added automatically. See the &quot;Include title&quot; setting for dynamic field examples and other information.
                        </div>
                    </div>
                </div>  
			
            </div> <!-- hm_psr_tab_display_panel -->
			
			<div id="hm_psr_tab_advanced_panel" class="hm_psr_tab_panel">
			
			  <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title" for="hm_psr_field_time_limit">
                           <span class="label">Time Limit:</span>
                         </label>
                        <div class="ags-psr-settings-content">
							Allow report to run for up to
							<input type="number" id="hm_psr_field_time_limit" name="time_limit" class="small-text" min="0" step="1" value="'.esc_attr($reportSettings['time_limit']).'" />
							seconds
                        </div>
                    </div>
                </div>
               
               <div class="ags-psr-settings-box">
                    <div class="ags-psr-settings-multirow">
                        <label class="ags-psr-settings-title" for="hm_psr_field_time_limit2">
                           <span class="label">Sort Buffer Size:</span>
						</label>
                        <div class="ags-psr-settings-content">
							Attempt to set MySQL sort buffer size to
							<input type="number" id="hm_psr_field_time_limit2" name="db_sort_buffer_size" class="small-text" min="0" step="1" value="' . esc_attr($reportSettings['db_sort_buffer_size']) . '" /> K
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Plugin Conflicts:</span>
							<input type="checkbox" name="report_unfiltered"'.(empty($reportSettings['report_unfiltered']) ? '' : ' checked="checked"').'>
							Attempt to prevent other plugins or code from changing the export query or output
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-visible ags-psr-mt-10">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Enabling this option can help resolve issues caused by conflicting plugins, but be sure to verify the accuracy and completeness of the export output when using this option.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Disable WordPress object caching</span>
							<input type="checkbox" name="object_caching_disable" value="1"'.(empty($reportSettings['object_caching_disable']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Enable this option if you are encountering memory limit errors while running reports.
                        </div>
                    </div>
                </div>
				
				 <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Use WordPress date formatting functionality for dynamic date values</span>
							<input type="checkbox" id="hm_psr_use_wp_date" name="use_wp_date" value="1"'.(empty($reportSettings['use_wp_date']) ? '' : ' checked="checked"').' />
						</label>
                    <div class="ags-psr-settings-tooltip tooltip-hover">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            If the dynamic date feature is not producing output in the language that your field values are using, and your WordPress language is set to that language, try enabling this option.
                        </div>
                    </div>
                </div>
                
                <div class="ags-psr-settings-box">
						<label>
                       <span class="label">Enable debug mode</span>
							<input type="checkbox" name="hm_psr_debug" value="1"'.(empty($reportSettings['hm_psr_debug']) ? '' : ' checked="checked"').' />
                    </label>
                </div>
                
                <div class="ags-psr-settings-box">
                    <label for="hm_psr_field_report_css">
                       <span class="label">Report CSS:</span>
                       <textarea id="hm_psr_field_report_css" name="report_css" rows="11"' . ($canEditReportCSS ? '' : ' disabled="disabled"') . '>' . esc_textarea($reportSettings['report_css']) . '</textarea>
                    </label>
                    
                     <div class="ags-psr-settings-tooltip tooltip-visible ags-psr-mt-20">
                        <div class="ags-psr-settings-tooltiptext">
                            <span>Help</span>
                            Applies to HTML report formats only.' . ($canEditReportCSS ? '' : '<br />You do not have the necessary permissions to edit the report preset\'s CSS.') . '
                        </div>
                     </div>
                </div>
               
            </div> <!-- hm_psr_tab_advanced_panel -->
			
			</div> <!-- /hm_psr_tab_panels -->');
			
			//HM_Product_Sales_Report_Pro::savePresetField();
			
			wp_nonce_field('hm-psr-run', 'hm-psr-nonce');
			
            echo('<div class="hm_psr_submit_wrapper">
                    <button type="submit" class="ags-psr-button-primary" name="hm_psr_action" value="run" onclick="jQuery(this).closest(\'form\').attr(\'target\', \'_blank\'); return true;">Download Report</button>

                    <div class="hm_psr_email_report">
				<input type="email" name="email_to" placeholder="Email address" value="'.esc_attr(get_option('hm_psr_last_email_to', get_bloginfo('admin_email'))).'" class="hm-psr-input-fullwidth"/>
                        <button type="submit" class="ags-psr-button-dark" name="hm_psr_action" value="email" onclick="jQuery(this).closest(\'form\').attr(\'target\', \'\'); return true;">Email Report</button>
                    </div>
                </div>
            </form>
        </div>
        <div id="ags-psr-settings-license">');
		
		HM_Product_Sales_Report_Pro::pluginCreditBox();
            ?>
		
        </div>
        <div id="ags-psr-settings-addons">
            <?php
                define('AGS_PSRP_XOIWC_Addons_URL', 'https://divi.space/wp-content/uploads/product-addons/product-sales-report-pro.json');
                require_once(dirname(__FILE__) . '/addons/addons.php');
                AGS_PSRP_XOIWC_Addons::outputList();
           ?>
        </div>  <!-- #ags-xoiwc-settings-addons -->
    </div> <!-- ags-psr-settings-tabs-content -->
</div> <!-- ags-psr-settings -->
</div> <!-- ags-psr-settings-container-->

		
<script type="text/javascript"
        src="<?php echo esc_url( plugins_url('../js/hm-product-sales-report.js?v=' . HM_PSR_VERSION, __FILE__) ); ?>"></script>
	
<script>
    var ags_psr_tabs_navigate = function () {
        var tabs = [
                {
                    tabsContainerId: 'ags-psr-settings-tabs',
                    contentIdPrefix: 'ags-psr-settings-'
                }
                // {
                //     tabsContainerId: 'ags-psr-settings-sub-tabs',
                //     contentIdPrefix: 'ags-psr-settings-sub-'
                // }
            ],
            activeClass = 'ags-psr-settings-active';
        for (var i = 0; i < tabs.length; ++i) {
            var $tabContent = jQuery('#' + tabs[i].contentIdPrefix + location.hash.substr(1));
            if ($tabContent.length) {
                var $tabs = jQuery('#' + tabs[i].tabsContainerId + ' > li');
                $tabContent
                    .siblings()
                    .add($tabs)
                    .removeClass(activeClass);
                $tabContent.addClass(activeClass);
                $tabs
                    .filter(':has(a[href="' + location.hash + '"])')
                    .addClass(activeClass);
                break;
            }
        }
    };
    if (location.hash) {
        ags_psr_tabs_navigate();
    }

    jQuery(window).on('hashchange', ags_psr_tabs_navigate);
</script>
