/**
 * Listen to value changes into the setup wizard
 * and toggle steps when needed.
 */
window.addEventListener('barn2_setup_wizard_changed', ( dispatchedEvent ) => {

	const anyone = dispatchedEvent.detail.anyone === '1' || dispatchedEvent.detail.anyone === true;
	const logged = dispatchedEvent.detail.logged === '1' || dispatchedEvent.detail.logged === true;

	const showStep = dispatchedEvent.detail.showStep
	const hideStep = dispatchedEvent.detail.hideStep

	if ( anyone === true && logged === true ) {
		showStep( 'password-protection' )
		showStep( 'user-protection' )
	} else if ( anyone === true ) {
		showStep( 'password-protection' )
		hideStep( 'user-protection' )
	} else if ( logged === true ) {
		hideStep( 'password-protection', true )
		showStep( 'user-protection', false )
	}

}, false);