<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard;

use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\Access_Types;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\Completed;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\License_Verification;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\Password_Protection;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\Upsell;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\User_Protection;
use Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps\Visibility;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Setup_Wizard;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Util;
use Barn2\PPC_Lib\Plugin\License\EDD_Licensing;
use Barn2\PPC_Lib\Plugin\License\Plugin_License;
use Barn2\PPC_Lib\Plugin\Licensed_Plugin;
use Barn2\PPC_Lib\Registerable;

class Service implements Registerable {

	/**
	 * Plugin instance
	 *
	 * @var Licensed_Plugin
	 */
	private $plugin;

	/**
	 * Wizard instance
	 *
	 * @var Wizard
	 */
	private $wizard;

	/**
	 * Setup the setup wizard. Pun intended.
	 *
	 * @param Licensed_Plugin $plugin
	 */
	public function __construct( Licensed_Plugin $plugin ) {

		$this->plugin = $plugin;

		$steps = [
			new License_Verification(),
			new Visibility(),
			new Access_Types(),
			new Password_Protection(),
			new User_Protection(),
			new Upsell(),
			new Completed(),
		];

		$wizard = new Setup_Wizard( $this->plugin, $steps, false );

		$wizard->configure(
			[
				'skip_url'        => admin_url( 'options-general.php?page=protected_categories' ),
				'license_tooltip' => esc_html__( 'The licence key is contained in your order confirmation email.', 'password-protected-categories' ),
				'utm_id'          => 'ppc',
			]
		);

		$wizard->add_edd_api( EDD_Licensing::class );
		$wizard->add_license_class( Plugin_License::class );

		$wizard->add_custom_asset(
			$plugin->get_dir_url() . 'assets/js/ppc-wizard.min.js',
			Util::get_script_dependencies( $this->plugin, './assets/js/ppc-wizard.min.js' )
		);

		$this->wizard = $wizard;

	}

	/**
	 * Boot the wizard.
	 *
	 * @return void
	 */
	public function register() {
		$this->wizard->boot();
	}

}
