<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Api;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Step;

class Access_Types extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'access-types' );
		$this->set_name( __( 'Access Types', 'password-protected-categories' ) );
		$this->set_description( __( 'How will people access your protected categories?', 'password-protected-categories' ) );
		$this->set_title( __( 'Unlocking protected categories', 'password-protected-categories' ) );
	}

	/**
	 * {@inheritdoc}
	 */
	public function setup_fields() {
		$fields = [];

		$fields['anyone'] = [
			'type'  => 'checkbox',
			'label' => esc_html__( 'Anyone with a valid password', 'password-protected-categories' ),
			'value' => get_option( 'ppc_wizard_with_password' )
		];

		$fields['logged'] = [
			'type'  => 'checkbox',
			'label' => esc_html__( 'Logged in users', 'password-protected-categories' ),
			'value' => get_option( 'ppc_wizard_logged' )
		];

		return $fields;
	}

	/**
	 * {@inheritdoc}
	 */
	public function submit( array $values ) {

		$logged        = isset( $values['logged'] ) && $values['logged'] === '1' ? true : false;
		$with_password = isset( $values['anyone'] ) && $values['anyone'] === '1' ? true : false;

		update_option( 'ppc_wizard_logged', $logged );
		update_option( 'ppc_wizard_with_password', $with_password );

		return Api::send_success_response();

	}
}
