<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Steps\Welcome;

/**
 * License verification step.
 */
class License_Verification extends Welcome {

	/**
	 * Setup step.
	 */
	public function __construct() {
		parent::__construct();
		$this->set_title( 'Welcome to Password Protected Categories' );
		$this->set_name( esc_html__( 'Welcome', 'password-protected-categories' ) );
		$this->set_description( esc_html__( 'Start creating protected categories in no time', 'password-protected-categories' ) );
		$this->set_tooltip( esc_html__( 'Use this setup wizard to quickly configure the most popular options for your protected categories. You can easily change these options later on the plugin settings page or by relaunching the setup wizard.', 'password-protected-categories' ) );
	}
}
