<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Api;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Step;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Util;
use Barn2\Plugin\Password_Protected_Categories\PPC_Util;

class User_Protection extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'user-protection' );
		$this->set_name( __( 'User/role protection', 'password-protected-categories' ) );
		$this->set_description( __( 'Control the behavior of your user and role protected categories', 'password-protected-categories' ) );
		$this->set_title( __( 'User/role protection', 'password-protected-categories' ) );
		$this->set_hidden( 'true' );
	}

	/**
	 * {@inheritdoc}
	 */
	public function setup_fields() {
		$fields = [];

		$options = [
			'404'     => esc_html__( 'Show 404 error', 'password-protected-categories' ),
			'wplogin' => esc_html__( 'Show WordPress login page', 'password-protected-categories' ),
			'page'    => esc_html__( 'Show custom page', 'password-protected-categories' ),
		];

		$selected_protection = PPC_Util::get_option( 'ppc_user_protected' );

		$fields['ppc_user_protected'] = [
			'type'        => 'select',
			'label'       => __( 'When logged out', 'password-protected-categories' ),
			'alt_label'   => esc_html__( 'Select an option', 'password-protected-categories' ),
			'description' => __( 'What logged out users see when they try to access a category that is protected by role or user.', 'password-protected-categories' ),
			'options'     => Util::parse_array_for_dropdown( $options ),
			'value'       => $selected_protection,
		];

		$pages         = PPC_Util::get_pages( true );
		$selected_page = PPC_Util::get_option( 'ppc_user_protected_redirect' );

		$fields['ppc_user_protected_redirect'] = [
			'type'       => 'select',
			'label'      => __( 'Custom page', 'password-protected-categories' ),
			'alt_label'  => esc_html__( 'Select page', 'password-protected-categories' ),
			'options'    => Util::parse_array_for_dropdown( PPC_Util::get_pages( true ) ),
			'conditions' => [
				'ppc_user_protected' => [
					'op'    => 'eq',
					'value' => 'page',
				]
			],
			'value'      => $selected_page
		];

		return $fields;
	}

	/**
	 * {@inheritdoc}
	 */
	public function submit( array $values ) {

		$options = PPC_Util::get_options();

		$logged_out = $values['ppc_user_protected'];
		$page       = $values['ppc_user_protected_redirect'];

		if ( $logged_out ) {
			$options['ppc_user_protected'] = $logged_out;
		}

		if ( $page ) {
			$options['ppc_user_protected_redirect'] = $page;
		}

		PPC_Util::update_options( $options );

		return Api::send_success_response();

	}

}
