<?php
namespace Barn2\Plugin\Password_Protected_Categories;

use Barn2\PPC_Lib\Registerable;

/**
 * Theme and plugin integrations for Password Protected Categories.
 *
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Integrations implements Registerable {

	public function register() {
		add_action( 'ppc_protected_category_template', [ $this, 'the_events_calendar' ] );
	}

	public function the_events_calendar() {
		// Prevent The Events Calendar running its template customisations.
		\remove_filter( 'template_include', [ 'Tribe__Events__Templates', 'templateChooser' ] );
		\remove_action( 'template_redirect', 'tribe_initialize_view' );
		\remove_action( 'wp_head', [ 'Tribe__Events__Templates', 'maybeSpoofQuery' ], 100 );

		if ( function_exists( 'tribe' ) ) {
			remove_filter( 'template_include', [ tribe( \Tribe\Events\Views\V2\Hooks::class ), 'filter_template_include' ], 50 );
		}
	}

}
