<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Steps\Cross_Selling;

class Upsell extends Cross_Selling {

	public function __construct() {
		parent::__construct();
		$this->set_name( esc_html__( 'More', 'password-protected-categories' ) );
		$this->set_description(
			sprintf(
				__( 'Enhance your website with these fantastic plugins from Barn2, or get them all by upgrading to an <a href="%1$s" target="_blank">All Access Pass<a/>! <a href="%2$s" target="_blank">(learn how here)</a>', 'password-protected-categories' ),
				'https://barn2.com/wordpress-plugins/bundles/',
				'https://barn2.com/kb/how-to-upgrade-license/'
			)
		);
		$this->set_title( esc_html__( 'Extra features', 'password-protected-categories' ) );
	}

	public function get_upsells() {
		$this->get_wizard()->set_as_completed();
		parent::get_upsells();
	}

}
