<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Step;
use Barn2\Plugin\Password_Protected_Categories\PPC_Util;

/**
 * Visibility step.
 */
class Visibility extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'visibility' );
		$this->set_name( esc_html__( 'Visibility', 'password-protected-categories' ) );
		$this->set_description( esc_html__( 'Do you want to hide protected categories from public view?', 'password-protected-categories' ) );
		$this->set_title( esc_html__( 'Protected category visibility', 'password-protected-categories' ) );
	}

	/**
	 * Setup fields for the step.
	 *
	 * @return array
	 */
	public function setup_fields() {

		$fields = [];

		$fields['show_protected'] = [
			'type'        => 'checkbox',
			'label'       => esc_html__( 'Show protected categories and posts', 'password-protected-categories' ),
			'description' => esc_html__( 'Tick to show protected categories in public areas of your site (e.g. widgets and navigation menus). Untick to hide them.', 'password-protected-categories' ),
			'value'       => (bool) PPC_Util::get_option( 'show_protected' ) === '1',
		];

		return $fields;
	}

	/**
	 * Handle step submission.
	 *
	 * @return void
	 */
	public function submit() {
		check_ajax_referer( 'barn2_setup_wizard_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			$this->send_error( esc_html__( 'You are not authorized.', 'password-protected-categories' ) );
		}

		$values  = $this->get_submitted_values();
		$options = PPC_Util::get_options();

		$expiry         = isset( $values['password_expires'] ) && ! empty( $values['password_expires'] ) ? absint( $values['password_expires'] ) : false;
		$show_protected = isset( $values['show_protected'] ) && $values['show_protected'] === 'true' ? '1' : false;

		$options['password_expires'] = $expiry;
		$options['show_protected']   = $show_protected;

		PPC_Util::update_options( $options );

		wp_send_json_success();
	}

}
