<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Step;

class Access_Types extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'access-types' );
		$this->set_name( __( 'Access Types', 'password-protected-categories' ) );
		$this->set_description( __( 'How will people access your protected categories?', 'password-protected-categories' ) );
		$this->set_title( __( 'Unlocking protected categories', 'password-protected-categories' ) );
	}

	/**
	 * {@inheritdoc}
	 */
	public function setup_fields() {
		$fields = [];

		$fields['anyone'] = [
			'type'  => 'checkbox',
			'label' => esc_html__( 'Anyone with a valid password', 'password-protected-categories' ),
			'value' => get_option( 'ppc_wizard_with_password' )
		];

		$fields['logged'] = [
			'type'  => 'checkbox',
			'label' => esc_html__( 'Logged in users', 'password-protected-categories' ),
			'value' => get_option( 'ppc_wizard_logged' )
		];

		return $fields;
	}

	/**
	 * Update options in the database if needed.
	 *
	 * @return void
	 */
	public function submit() {

		check_ajax_referer( 'barn2_setup_wizard_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			$this->send_error( esc_html__( 'You are not authorized.', 'password-protected-categories' ) );
		}

		$values = $this->get_submitted_values();

		$logged        = isset( $values['logged'] ) && $values['logged'] === 'true' ? true : false;
		$with_password = isset( $values['anyone'] ) && $values['anyone'] === 'true' ? true : false;

		$options['wizard_logged']        = $logged;
		$options['wizard_with_password'] = $with_password;

		update_option( 'ppc_wizard_logged', $logged );
		update_option( 'ppc_wizard_with_password', $with_password );

		wp_send_json_success();

	}
}
