<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Interfaces\Restartable;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Setup_Wizard;

/**
 * PPC Setup wizard class.
 */
class Wizard extends Setup_Wizard implements Restartable {

	/**
	 * Handles the restart of the wizard.
	 *
	 * @return void
	 */
	public function on_restart() {
		check_ajax_referer( 'barn2_setup_wizard_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( [ 'error_message' => __( 'You are not authorized.', 'password-protected-categories' ) ], 403 );
		}

		$toggle = [];
		$logged = get_option( 'ppc_wizard_logged' );
		$anyone = get_option( 'ppc_wizard_with_password' );

		if ( $anyone ) {
			$toggle[] = 'anyone';
		}

		if ( $logged ) {
			$toggle[] = 'logged';
		}

		wp_send_json_success(
			[
				'toggle' => $toggle
			]
		);
	}

}
