<?php
/**
 * The main plugin file for Password Protected Categories.
 *
 * This file is included during the WordPress bootstrap process if the plugin is active.
 *
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.co.uk>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 *
 * @wordpress-plugin
 * Plugin Name:     Password Protected Categories
 * Plugin URI:      https://barn2.co.uk/wordpress-plugins/password-protected-categories/
 * Description:     Protect any category or custom taxonomy with a password.
 * Version:         2.1.9
 * Author:          Barn2 Plugins
 * Author URI:      https://barn2.co.uk
 * Text Domain:     password-protected-categories
 * Domain Path:     /languages
 *
 * Copyright:       Barn2 Media Ltd
 * License:         GNU General Public License v3.0
 * License URI:     http://www.gnu.org/licenses/gpl-3.0.html
 */
namespace Barn2\Plugin\Password_Protected_Categories;

// Prevent direct file access
if ( ! \defined( 'ABSPATH' ) ) {
	exit;
}

const PLUGIN_VERSION = '2.1.9';
const PLUGIN_FILE    = __FILE__;

// Include autoloader.
require_once __DIR__ . '/vendor/autoload.php';

function ppc() {
	return Plugin_Factory::create( PLUGIN_FILE, PLUGIN_VERSION );
}

/**
 * Helper function to access the shared plugin instance.
 *
 * @return Plugin The plugin instance.
 * @deprecated 1.4.3 Renamed ppc().
 */
function password_protected_categories() {
	_deprecated_function( __FUNCTION__, '1.4.3', 'Barn2\\Plugin\\Password_Protected_Categories\\ppc()' );
	return ppc();
}

// Load the plugin.
ppc()->register();
