<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Steps\Ready;

/**
 * The last step.
 */
class Completed extends Ready {

	/**
	 * Setup the step.
	 */
	public function __construct() {
		parent::__construct();
		$this->set_name( esc_html__( 'Ready', 'password-protected-categories' ) );
		$this->set_title( esc_html__( 'Complete Setup', 'password-protected-categories' ) );
		$this->set_description( esc_html__( 'Congratulations, you have finished setting up the plugin! To start creating protected categories, simply add or edit a category and use the ‘Visibility’ options.', 'password-protected-categories' ) );
	}
}
