<?php
/**
 * @package   Barn2\password-protected-categories
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
namespace Barn2\Plugin\Password_Protected_Categories\Admin\Wizard\Steps;

use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Step;
use Barn2\Plugin\Password_Protected_Categories\Dependencies\Barn2\Setup_Wizard\Util;
use Barn2\Plugin\Password_Protected_Categories\PPC_Util;

class User_Protection extends Step {

	/**
	 * Configure the step.
	 */
	public function __construct() {
		$this->set_id( 'user-protection' );
		$this->set_name( __( 'User/role protection', 'password-protected-categories' ) );
		$this->set_description( __( 'Control the behavior of your user and role protected categories', 'password-protected-categories' ) );
		$this->set_title( __( 'User/role protection', 'password-protected-categories' ) );
		$this->set_hidden( 'true' );
	}

	/**
	 * {@inheritdoc}
	 */
	public function setup_fields() {
		$fields = [];

		$options = [
			'404'     => esc_html__( 'Show 404 error', 'password-protected-categories' ),
			'wplogin' => esc_html__( 'Show WordPress login page', 'password-protected-categories' ),
			'page'    => esc_html__( 'Show custom page', 'password-protected-categories' ),
		];

		$selected_protection = PPC_Util::get_option( 'ppc_user_protected' );
		$value               = [];

		if ( is_array( $selected_protection ) && isset( $selected_protection[0]['key'] ) ) {
			$selected_protection = $selected_protection[0]['key'];
		}

		if ( ! empty( $selected_protection ) ) {
			$value = [
				[
					'key'   => $selected_protection,
					'label' => $options[ $selected_protection ]
				]
			];
		}

		$fields['ppc_user_protected'] = [
			'type'        => 'select',
			'label'       => __( 'When logged out', 'password-protected-categories' ),
			'alt_label'   => esc_html__( 'Select an option', 'password-protected-categories' ),
			'description' => __( 'What logged out users see when they try to access a category that is protected by role or user.', 'password-protected-categories' ),
			'options'     => Util::parse_array_for_dropdown( $options ),
			'value'       => $value,
		];

		$pages         = PPC_Util::get_pages( true );
		$custom_page   = [];
		$selected_page = PPC_Util::get_option( 'ppc_user_protected_redirect' );

		if ( is_array( $selected_page ) && isset( $selected_page[0]['key'] ) ) {
			$selected_page = $selected_page[0]['key'];
		}

		if ( ! empty( $selected_page ) && isset( $pages[ $selected_page ] ) ) {
			$custom_page = [
				[
					'key'   => absint( $selected_page ),
					'label' => $pages[ $selected_page ]
				]
			];
		}

		$fields['ppc_user_protected_redirect'] = [
			'type'       => 'select',
			'label'      => __( 'Custom page', 'password-protected-categories' ),
			'alt_label'  => esc_html__( 'Select page', 'password-protected-categories' ),
			'options'    => Util::parse_array_for_dropdown( PPC_Util::get_pages( true ) ),
			'conditions' => [
				'ppc_user_protected' => [
					'op'    => 'eq',
					'value' => 'page',
				]
			],
			'value'      => $custom_page
		];

		return $fields;
	}

	/**
	 * {@inheritdoc}
	 */
	public function submit() {

		check_ajax_referer( 'barn2_setup_wizard_nonce', 'nonce' );

		if ( ! current_user_can( 'manage_options' ) ) {
			$this->send_error( esc_html__( 'You are not authorized.', 'password-protected-categories' ) );
		}

		$values  = $this->get_submitted_values();
		$options = PPC_Util::get_options();

		$logged_out = $values['ppc_user_protected'];
		$page       = $values['ppc_user_protected_redirect'];

		if ( is_array( $logged_out ) && isset( $logged_out[0]['key'] ) ) {
			$logged_out = $logged_out[0]['key'];
		}

		if ( is_array( $page ) && isset( $page[0]['key'] ) ) {
			$page = $page[0]['key'];
		}

		if ( $logged_out ) {
			$options['ppc_user_protected'] = $logged_out;
		}

		if ( $page ) {
			$options['ppc_user_protected_redirect'] = $page;
		}

		PPC_Util::update_options( $options );

		wp_send_json_success();

	}

}
