import apiFetch                     from '@wordpress/api-fetch';
import { TailSpin }                 from 'react-loader-spinner';
import React, { useState }          from 'react';
import LoggingService               from '../../frontend/Services/LoggingService';
import cfwFormatFormValuesForSave   from '../../functions/cfwFormatFormValuesForSave';

const SettingsFormContainer = ( { children } ) => {
    const [ isLoading, setIsLoading ] = useState( false );
    const [ searchTerm, setSearchTerm ] = useState( '' );

    const saveSettings = async ( values ) => {
        setIsLoading( true );
        try {
            await apiFetch( {
                path: '/checkoutwc/v1/settings',
                method: 'POST',
                data: {
                    settings: cfwFormatFormValuesForSave( values ),
                },
            } );
        } catch ( error ) {
            alert( `Failed to save settings. Error: ${error.message}` );
            LoggingService.logError( 'Failed to save settings.', error );
        } finally {
            setIsLoading( false );
        }
    };

    return (
        <div className={'cfw-tw'}>
            {isLoading && (
                <div className="h-screen w-full fixed top-0 left-0 z-[1000]">
                    <div style={{ position: 'absolute', top: '50%', left: '50%', transform: 'translate(-50%, -50%)' }}>
                        <TailSpin
                            height="80"
                            width="80"
                            color="#277dcc"
                            ariaLabel="tail-spin-loading"
                            radius="1"
                            wrapperStyle={{}}
                            wrapperClass=""
                            visible={true}
                        />
                    </div>
                </div>
            )}

            <div className={'mb-6'}>
                <label htmlFor="default-search" className="mb-2 text-sm font-medium text-gray-900 sr-only dark:text-white">Search</label>

                <div className="relative">
                    <div className="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg className="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"/>
                        </svg>
                    </div>

                    <input
                        type="search"
                        id="cfw_form_search"
                        value={searchTerm}
                        onChange={( e ) => setSearchTerm( e.target.value )}
                        className="block w-full !p-2 !ps-8 text-sm text-gray-900 border border-gray-300 !rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Search Fields..."
                    />
                </div>
            </div>

            {React.cloneElement( children, { saveSettings, isLoading, searchTerm } )}
        </div>
    );
};

export default SettingsFormContainer;
