<?php

namespace Objectiv\Plugins\Checkout\Admin\Notices;

use Objectiv\Plugins\Checkout\Managers\UpdatesManager;

class WelcomeNotice extends NoticeAbstract {
	public function __construct() {}

	public function maybe_show() {
		if ( empty( $_GET['cfw_welcome'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return;
		}

		$updates_manager = UpdatesManager::instance();

		if ( $updates_manager->get_field_value( 'key_status' ) === 'valid' && get_transient( 'cfw_auto_activated' ) ) {
			?>
			<div id="cfw_welcome_notice" style="display:block !important" class="notice notice-info">
				<p>
					<h2>
						<?php cfw_e( 'Welcome', 'checkout-wc' ); ?>
					</h2>
					<?php cfw_e( 'Thank you for installing CheckoutWC! We automatically activated your license. You are all set!', 'checkout-wc' ); ?>
				</p>
			</div>
			<?php

			delete_transient( 'cfw_auto_activated' );

			return;
		}

		if (  $updates_manager->get_field_value( 'key_status' ) === 'valid' ) {
			return;
		}
		?>
		<div id="cfw_welcome_notice" style="display:block !important" class="notice notice-info">
			<p>
				<h2>
					<?php cfw_e( 'Welcome', 'checkout-wc' ); ?>
				</h2>
				<?php cfw_e( 'Thank you for installing CheckoutWC! To get started, enter your <strong>License Key</strong> below, save, and click <strong>Activate Site</strong>.', 'checkout-wc' ); ?>
			</p>
		</div>
		<?php
	}
}
