<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Gateways;

use Objectiv\Plugins\Checkout\Compatibility\CompatibilityAbstract;

class Oppcw extends CompatibilityAbstract {
	public function is_available(): bool {
		return function_exists( 'woocommerce_oppcw_add_errors' );
	}

	public function pre_init() {
		if ( ! $this->is_available() ) {
			return;
		}

		add_filter( 'cfw_is_checkout', function( $is_checkout ) {
			global $post;

			if ( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'woocommerce_oppcw') ) {
				return false;
			}

			return $is_checkout;
		} );

	}
}
