<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Gateways;

use Exception;
use Objectiv\Plugins\Checkout\Compatibility\CompatibilityAbstract;
use PaymentPlugins\WooCommerce\PPCP\Main;
use PaymentPlugins\WooCommerce\PPCP\Payments\PaymentGateways;

class PaymentPluginsPayPal extends CompatibilityAbstract {
	public function is_available(): bool {
		return class_exists( '\PaymentPlugins\WooCommerce\PPCP\PluginValidation' );
	}

	/**
	 * Run the compatibility code
	 *
	 * @throws Exception
	 */
	public function run() {
		add_filter( 'wc_ppcp_add_payment_method_data', array( $this, 'add_payment_method_data' ), 10  );
	}

	public function add_payment_method_data( $data  ): array {
		if ( ! is_cfw_page() ) {
			return $data;
		}

		if ( ! isset( $data['buttons'] ) ) {
			return $data;
		}

		foreach ( $data['buttons'] as $index => $button ) {
			$data['buttons'][ $index ]['height'] = '42';
		}

		return $data;
	}

	public function typescript_class_and_params( array $compatibility ): array {
		$compatibility[] = array(
			'class'  => 'PaymentPluginsPayPal',
			'params' => array(),
		);

		return $compatibility;
	}
}
