<?php

namespace Objectiv\Plugins\Checkout\Compatibility\Plugins;

use Objectiv\Plugins\Checkout\Compatibility\CompatibilityAbstract;

class Polylang extends CompatibilityAbstract {
	public function is_available(): bool {
		return defined( 'POLYLANG_VERSION' );
	}

	public function run() {
		add_filter(
			'cfw_header_home_url',
			function ( $url ) {
				return function_exists( 'pll_home_url' ) ? pll_home_url() : $url;
			}
		);
	}

	public function run_on_thankyou() {
		$this->run();
	}
}
