<?php

if ( ! defined( 'WPINC' ) ) {
	die;
}

use Objectiv\Plugins\Checkout\Factories\BumpFactory;
use Objectiv\Plugins\Checkout\Managers\PlanManager;
use Objectiv\Plugins\Checkout\Managers\SettingsManager;

/**
 * @return bool
 */
function cfw_is_thank_you_view_order_page_active(): bool {
	return cfw_is_thank_you_page_active() && PlanManager::can_access_feature( 'override_view_order_template' );
}

/**
 * @throws Exception
 */
function cfw_get_all_order_bumps(): array {
	return BumpFactory::get_all();
}

/**
 * Automatically applies filter with prefixing for setting name
 *
 * @param $setting
 * @param $value
 * @return void
 */
function cfw_add_setting_value_override( $setting, $value ) {
	add_filter( 'cfw_get_setting_' . $setting, function() use( $value ) {
		return $value;
	} );
}

function cfw_debug_log( string $message ) {
	if ( 'yes' !== SettingsManager::instance()->get_setting( 'enable_debug_log' ) ) {
		return;
	}

	wc_get_logger()->debug( $message, array( 'source' => 'checkout-wc' ) );
}