<?php

namespace Objectiv\Plugins\Checkout\Admin\Pages;

use Objectiv\Plugins\Checkout\Admin\Pages\Traits\TabbedAdminPageTrait;
use Objectiv\Plugins\Checkout\Managers\SettingsManager;
use Objectiv\Plugins\Checkout\Managers\UpdatesManager;
use WP_Admin_Bar;

/**
 * Start Here admin page
 *
 * @link checkoutwc.com
 * @since 5.0.0
 * @package Objectiv\Plugins\Checkout\Admin\Pages
 */
class General extends PageAbstract {
	use TabbedAdminPageTrait;

	protected $appearance_page;

	public function __construct( Appearance $appearance_page ) {
		$this->appearance_page = $appearance_page;
		parent::__construct( cfw__( 'Start Here', 'checkout-wc' ), 'cfw_manage_general' );
	}

	public function init() {
		parent::init();

		add_action( 'admin_bar_menu', array( $this, 'add_parent_node' ), 100 );
		add_action( 'admin_menu', array( $this, 'setup_main_menu_page' ), $this->priority - 5 );
	}

	public function setup_menu() {
		add_submenu_page( self::$parent_slug, $this->title, $this->title, $this->capability, $this->slug, null, $this->priority );
	}

	public function setup_main_menu_page() {
		add_menu_page( 'CheckoutWC', 'CheckoutWC', 'cfw_manage_general', self::$parent_slug, array( $this, 'output_with_wrap' ), 'data:image/svg+xml;base64,' . base64_encode( file_get_contents( CFW_PATH . '/build/images/cfw.svg' ) ) );
	}

	public function output() {
		if ( isset( $_GET['upgrade'] ) && '90' === $_GET['upgrade'] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$this->output_upgrade_notice();
			return;
		}

		?>
		<div class="max-w-3xl pb-8">
			<div>
				<p class="text-5xl font-bold text-gray-900">
					<?php cfw_e( 'Welcome to the new standard for WooCommerce stores.', 'checkout-wc' ); ?>
				</p>
				<p class="max-w-xl mt-5 text-2xl text-gray-500">
					<?php cfw_e( 'We hate complex configurations too. Get up and running with CheckoutWC in 5 minutes or less. ⚡️', 'checkout-wc' ); ?>
				</p>
				<p class="mt-6">
					<a href="https://kb.checkoutwc.com" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
						<?php cfw_e( 'Read Our Documentation', 'checkout-wc' ); ?>
					</a>
				</p>
			</div>
		</div>
		<?php

		$this->getting_started_tab();
	}

	public function output_upgrade_notice() {
		?>
		<div class="max-w-5xl pb-8">
			<div>
				<p class="text-5xl font-bold text-gray-900">
					<?php cfw_e( 'Welcome to CheckoutWC 9.0', 'checkout-wc' ); ?>
				</p>
				<p class="max-w-xl mt-5 text-2xl text-gray-500">
					<?php cfw_e( 'CheckoutWC 9.0 is a major update with new features and optimizations to make your WooCommerce store run better.', 'checkout-wc' ); ?>
				</p>

				<p class="max-w-xl mt-5 text-2xl text-gray-500">
					<?php cfw_e( 'Just how big is 9.0? We checked in 477 separate commits on the way to releasing 9.0 - by far our most ambitious update since version 2.0! There’s a lot to explore.', 'checkout-wc' ); ?>
				</p>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'Don\'t Over React', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( '9.0 embraces the power of React. We are using React to power most of the admin and frontend components, including the Side Cart and most dynamic portions of the checkout page. This means faster, more responsive pages and simpler code. And we maintained backwards compatibility so your existing plugins and customizations should continue to work just like they always have.', 'checkout-wc' ); ?>
						</p>
					</div>
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/9d0a6780-394a-11eb-9fd1-6296a684b124.jpeg" alt="React" />
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/Xnapper-2024-03-07-14.34.15-2.png" alt="New Trust Badge Editor" />
					</div>
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'New Trust Badge Editor', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( "Our new Trust Badge editor makes it easier than ever to design badges. And we added a new Review template to make it easy to feature customer testimonials.", 'checkout-wc' ); ?>
						</p>
						<p class="mt-5">
							<a href="<?php echo esc_attr( add_query_arg( array('page' => 'cfw-settings-trust-badges' ), admin_url( 'admin.php' ) ) ); ?>" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
								<?php cfw_e( 'Customize Trust Badges', 'checkout-wc' ); ?>
							</a>
						</p>
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'New Order Bumps Editor', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( 'The Order Bumps editor now uses Gutenberg so that you can see your changes in real time. We also added new Order Bump features such as full-screen design options for Post Purchase Upsells (After Checkout Submit), and you can even set an Order Bump to automatically be added to the cart if your conditions are met.', 'checkout-wc' ); ?>
						</p>
						<p class="mt-5">
							<a href="<?php echo esc_attr( add_query_arg( array('page' => 'cfw-settings-order_bumps' ), admin_url( 'admin.php' ) ) ); ?>" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
								<?php cfw_e( 'Configure Order Bumps', 'checkout-wc' ); ?>
							</a>
						</p>
					</div>
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/Xnapper-2024-03-07-14.39.05.png" alt="New Order Bumps Editor" />
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/IMG_1405.jpg" alt="Compatibility Assists" />
					</div>
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'More Helpful', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( '9.0 tries to help you solve compatibility and configuration problems before they happen. We now offer proactive advice for the best gateways to leverage our Express Checkout feature and show notices when we detect a theme or plugin that requires additional configuration. We also detect incompatible configurations and warn you, saving you time and headaches.', 'checkout-wc' ); ?>
						</p>
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'A New Mobile Cart Summary', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( 'For mobile device users, we have a new mobile cart summary at the bottom of the first checkout step - now your users can interact with the cart without any extra hassle.', 'checkout-wc' ); ?>
						</p>
						<p class="mt-5">
							<a href="<?php echo esc_attr( add_query_arg( array('page' => 'cfw-settings-checkout' ), admin_url( 'admin.php' ) ) ); ?>" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
								<?php cfw_e( 'Configure Mobile Cart Summary', 'checkout-wc' ); ?>
							</a>
						</p>
					</div>
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/Xnapper-2024-03-07-14.48.23.png" alt="A New Mobile Cart Summary" />
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<img src="https://www.checkoutwc.com/wp-content/uploads/2024/03/Xnapper-2024-03-07-14.49.38.png" alt="Abandoned Cart Recovery Templates" />
					</div>
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'Abandoned Cart Recovery Templates', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( 'For new installs, or sites without existing emails configured, we now install 3 sample emails to help you get started with recovering abandoned carts.', 'checkout-wc' ); ?>
						</p>
						<p class="mt-5">
							<a href="<?php echo esc_attr( add_query_arg( array('page' => 'cfw-settings-acr' ), admin_url( 'admin.php' ) ) ); ?>" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
								<?php cfw_e( 'Configure Abandoned Cart Recovery', 'checkout-wc' ); ?>
							</a>
						</p>
					</div>
				</div>

				<div class="grid grid-cols-2 gap-8 mt-12">
					<div>
						<p class="text-4xl font-bold text-gray-900">
							<?php cfw_e( 'And a lot more', 'checkout-wc' ); ?>
						</p>
						<p class="max-w-xl mt-5 text-2xl text-gray-500">
							<?php cfw_e( 'There are too many new features to describe them all here, but we have added much more including a new Auto-select Free Shipping feature, better free order handling,  new Order Bump settings, and new options to disable features like Express Checkout. See our change log for full information.', 'checkout-wc' ); ?>
						</p>
						<p class="mt-5">
							<a href="https://www.checkoutwc.com/documentation/change-log/" target="_blank" class="inline-flex items-center px-6 py-3 border border-transparent text-lg shadow font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
								<?php cfw_e( 'Read Our Change Log', 'checkout-wc' ); ?>
							</a>
						</p>
					</div>
				</div>
			</div>
		</div>
		<?php
	}

	public function getting_started_tab() {
		$this->output_form_open();
		?>
		<div class="space-y-8 mt-4">
			<?php
			cfw_admin_page_section(
				cfw__( 'Step 1: Activate Your License', 'checkout-wc' ),
				cfw__( 'Enter your license key. An active license is required for all functionality.', 'checkout-wc' ),
				$this->get_licensing_settings()
			);

			cfw_admin_page_section(
				cfw__( 'Step 2: Pick a Template', 'checkout-wc' ),
				cfw__( 'Choose which design to use for your checkout and thank you page.', 'checkout-wc' ),
				$this->get_pick_template_content()
			);

			cfw_admin_page_section(
				cfw__( 'Step 3: Customize Logo and Colors', 'checkout-wc' ),
				cfw__( 'Review your logo and set your brand colors.', 'checkout-wc' ),
				$this->get_design_content()
			);

			cfw_admin_page_section(
				cfw__( 'Step 4: Review Your Checkout Page', 'checkout-wc' ),
				cfw__( 'Test your checkout page and make sure everything is working correctly.', 'checkout-wc' ),
				$this->get_preview_content()
			);

			cfw_admin_page_section(
				cfw__( 'Step 5: Go Live', 'checkout-wc' ),
				cfw__( 'Enable templates for all visitors.', 'checkout-wc' ),
				$this->get_activation_settings()
			);

			echo cfw_get_sendwp_admin_banner( true );
			?>
		</div>
		<?php
		$this->output_form_close();

		if ( isset( $_GET['cfw_debug_settings'] ) ) {
			$all_settings = SettingsManager::instance()->get_settings_obj();

			echo '<div class="max-w-lg">';
			foreach ( $all_settings as $key => $value ) {
				echo '<h3 class="text-base font-bold mb-4">' . $key . '</h3>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo '<pre class="shadow-sm bg-white p-6 focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md mb-6">' . $value . '</pre>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
			echo '</div>';
		}
	}

	public function get_activation_settings() {
		ob_start();

		$this->output_toggle_checkbox(
			'enable',
			cfw__( 'Activate CheckoutWC Templates', 'checkout-wc' ),
			cfw__( 'Requires a valid and active license key. CheckoutWC Templates are always activated for admin users, even without a valid license.', 'checkout-wc' )
		);

		return ob_get_clean();
	}

	public function get_licensing_settings() {
		ob_start();

		UpdatesManager::instance()->admin_page_fields();

		return ob_get_clean();
	}

	public function get_pick_template_content() {
		ob_start();
		?>
		<div class="flex flex-row items-center">
			<a href="<?php echo esc_attr( add_query_arg( array( 'subpage' => 'templates' ), $this->appearance_page->get_url() ) ); ?>" target="_blank" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
				<?php cfw_e( 'Choose a Template', 'checkout-wc' ); ?>
			</a>
			<svg xmlns="http://www.w3.org/2000/svg" class="ml-2 h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-label="<?php cfw_e( 'Opens in new tab' ); ?>">
				<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
			</svg>
		</div>
		<?php
		return ob_get_clean();
	}

	public function get_design_content() {
		ob_start();
		?>
		<div class="flex flex-row items-center">
			<a href="<?php echo esc_attr( $this->appearance_page->get_url() ); ?>" target="_blank" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
				<?php cfw_e( 'Customize Logo and Colors', 'checkout-wc' ); ?>
			</a>
			<svg xmlns="http://www.w3.org/2000/svg" class="ml-2 h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-label="<?php cfw_e( 'Opens in new tab' ); ?>">
				<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
			</svg>
		</div>
		<?php
		return ob_get_clean();
	}

	public function get_preview_content() {
		$url = wc_get_checkout_url();

		$products = wc_get_products(
			array(
				'limit'        => 1,
				'status'       => 'publish',
				'type'         => array( 'simple' ),
				'stock_status' => 'instock',
			)
		);

		if ( empty( $products ) ) {
			$products = wc_get_products(
				array(
					'parent_exclude' => 0,
					'limit'          => 1,
					'status'         => 'publish',
					'type'           => array( 'variable' ),
					'stock_status'   => 'instock',
				)
			);
		}

		// Get any simple or variable woocommerce product
		if ( ! empty( $products ) ) {
			$product = $products[0];

			$url = add_query_arg( array( 'add-to-cart' => $product->get_id() ), $url );
		}

		ob_start();
		?>
		<div class="flex flex-row items-center">
			<a href="<?php echo esc_attr( $url ); ?>" target="_blank" class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
				<?php cfw_e( 'Preview Your Checkout Page', 'checkout-wc' ); ?>
			</a>
			<svg xmlns="http://www.w3.org/2000/svg" class="ml-2 h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-label="<?php cfw_e( 'Opens in new tab' ); ?>">
				<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
			</svg>
		</div>
		<?php
		return ob_get_clean();
	}

	/**
	 * Add parent node
	 *
	 * @param WP_Admin_Bar $admin_bar
	 */
	public function add_parent_node( WP_Admin_Bar $admin_bar ) {
		if ( ! $this->can_show_admin_bar_button() ) {
			return;
		}

		if ( cfw_is_checkout() ) {
			// Remove irrelevant buttons
			$admin_bar->remove_node( 'new-content' );
			$admin_bar->remove_node( 'updates' );
			$admin_bar->remove_node( 'edit' );
			$admin_bar->remove_node( 'comments' );
		}

		$url = $this->get_url();

		$admin_bar->add_node(
			array(
				'id'     => self::$parent_slug,
				'title'  => '<span class="ab-icon dashicons dashicons-cart"></span>' . cfw__( 'CheckoutWC', 'checkout-wc' ),
				'href'   => $url,
				'parent' => false,
			)
		);

		if ( ! is_cfw_page() ) {
			return;
		}

		$admin_bar->add_node(
			array(
				'id'     => self::$parent_slug . '-bypass',
				'title'  => isset( $_GET['bypass-cfw'] ) ? '<span class="ab-icon dashicons dashicons-controls-play"></span>' . cfw__( 'Unbypass CheckoutWC Template', 'checkout-wc' ) : '<span class="ab-icon dashicons dashicons-controls-pause"></span>' . cfw__( 'Bypass CheckoutWC Template', 'checkout-wc' ),
				'href'   => isset( $_GET['bypass-cfw'] ) ? remove_query_arg( 'bypass-cfw' ) : add_query_arg( 'bypass-cfw', 'true' ),
				'parent' => false,
				'meta'   => array(
					'onclick' => ! isset( $_GET['bypass-cfw'] ) ? 'alert("' . esc_js( cfw__( 'CheckoutWC template and functionality will be temporarily bypassed (just for you!). This is helpful for testing and debugging. You can click Unbypass CheckoutWC Template once you are done.', 'checkout-wc' ) ) . '")' : '',
				),
			)
		);
	}

	/**
	 * Add admin bar menu node
	 *
	 * @param WP_Admin_Bar $admin_bar
	 */
	public function add_admin_bar_menu_node( WP_Admin_Bar $admin_bar ) {
		if ( ! $this->can_show_admin_bar_button() ) {
			return;
		}

		$admin_bar->add_node(
			array(
				'id'     => $this->slug . '-general',
				'title'  => $this->title,
				'href'   => $this->get_url(),
				'parent' => self::$parent_slug,
			)
		);
	}
}
