<?php

namespace Objectiv\Plugins\Checkout\Admin\Pages;

use Objectiv\Plugins\Checkout\Managers\PlanManager;
use Objectiv\Plugins\Checkout\Managers\SettingsManager;
use Objectiv\Plugins\Checkout\Managers\UpdatesManager;

/**
 * @link checkoutwc.com
 * @since 5.0.0
 * @package Objectiv\Plugins\Checkout\Admin\Pages
 * @author Clifton Griffin <clif@checkoutwc.com>
 */
class TrustBadges extends PageAbstract {
	public function __construct() {
		parent::__construct( cfw__( 'Trust Badges', 'checkout-wc' ), 'cfw_manage_trust_badges', 'trust-badges' );
	}

	public function output() {
		?>
		<div id="cfw-new-trust-badge-settings-page"></div>
		<?php
	}

	public function maybe_set_script_data() {
		if ( ! $this->is_current_page() ) {
			return;
		}

		$trust_badges = cfw_get_setting( 'trust_badges', null, array() );

		// Seed store policies with internal ID that won't change
		foreach ( $trust_badges as $index => $badge ) {
			// Handle edge case where badges end up set to array where 0 element = false
			// Ticket https://secure.helpscout.net/conversation/2311670760/16562?folderId=2454654
			if ( ! $badge ) {
				continue;
			}

			$badge['id'] = 'tb-' . $index;

			$trust_badges[ $index ] = $badge;
		}

		$this->set_script_data( array(
			'settings' => array(
				'enable_trust_badges'  => SettingsManager::instance()->get_setting( 'enable_trust_badges' ) === 'yes',
				'trust_badge_position' => SettingsManager::instance()->get_setting( 'trust_badge_position' ),
				'trust_badges_title'   => SettingsManager::instance()->get_setting( 'trust_badges_title' ),
				'trust_badges'         => array_values( $trust_badges ),
			),
			'plan'     => array(
				'plan_id'          => UpdatesManager::instance()->get_license_price_id(),
				'has_premium_plan' => PlanManager::has_premium_plan(),
				'premium_plans'    => PlanManager::get_english_list_of_required_plans_html(),
			),
		) );
	}
}
