<?php

namespace Objectiv\Plugins\Checkout;

use Objectiv\Plugins\Checkout\Managers\SettingsManager;
use WP_Roles;

class Install {
	public function __construct() {}

	public function init() {
		self::maybe_migrate_lite_settings();
		self::add_capabilities();
		self::add_settings();
	}

	public static function maybe_migrate_lite_settings() {
		$settings_manager = SettingsManager::instance();

		// Maybe update from lite version
		$lite_settings = get_option( '_cfwlite__settings', false );

		if ( ! empty( $lite_settings ) ) {
			foreach ( $lite_settings as $key => $value ) {
				$settings_manager->add_setting( $key, $value ); // don't overwrite pro settings
			}
		}
	}

	public static function add_capabilities() {
		global $wp_roles;

		if ( ! class_exists( 'WP_Roles' ) ) {
			return;
		}

		if ( ! isset( $wp_roles ) ) {
			$wp_roles = new WP_Roles(); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
		}

		$capabilities = array(
			'cfw_manage_order_bumps',
			'cfw_view_acr_reports',
			'cfw_manage_pages',
			'cfw_manage_trust_badges',
			'cfw_manage_side_cart',
			'cfw_manage_local_pickup',
			'cfw_manage_order_bumps',
			'cfw_manage_integrations',
			'cfw_manage_general', // start here
			'cfw_manage_express_checkout',
			'cfw_manage_appearance',
			'cfw_manage_advanced',
			'cfw_export_settings',
			'cfw_import_settings',
			'cfw_manage_acr',
			'cfw_manage_options', // required to modify settings
		);

		foreach ( $capabilities as $capability ) {
			$wp_roles->add_cap( 'administrator', $capability );
		}
	}

	public static function add_settings() {
		$settings_manager = SettingsManager::instance();

		$settings_manager->add_setting( 'enable', 'no' );
		$settings_manager->add_setting( 'login_style', 'enhanced' );
		$settings_manager->add_setting( 'registration_style', 'enhanced' );
		$settings_manager->add_setting( 'cart_item_link', 'disabled' );
		$settings_manager->add_setting( 'cart_item_data_display', 'short' );
		$settings_manager->add_setting( 'skip_shipping_step', 'no' );
		$settings_manager->add_setting( 'enable_order_notes', 'no' );
		$settings_manager->add_setting( 'active_template', 'groove' );
		$settings_manager->add_setting( 'allow_checkout_field_editor_address_modification', 'no' );
		$settings_manager->add_setting( 'enable_elementor_pro_support', 'no' );
		$settings_manager->add_setting( 'enable_beaver_themer_support', 'no' );
		$settings_manager->add_setting( 'template_loader', 'redirect' );
		$settings_manager->add_setting( 'override_view_order_template', 'yes' );
		$settings_manager->add_setting( 'show_logos_mobile', 'no' );
		$settings_manager->add_setting( 'show_mobile_coupon_field', 'no' );
		$settings_manager->add_setting( 'enable_mobile_cart_summary', 'yes' );
		$settings_manager->add_setting( 'enable_mobile_totals', 'yes' );
		$settings_manager->add_setting( 'enable_order_pay', 'no' );
		$settings_manager->add_setting( 'enable_thank_you_page', 'no' );
		$settings_manager->add_setting( 'thank_you_order_statuses', 'no' );
		$settings_manager->add_setting( 'enable_map_embed', 'no' );
		$settings_manager->add_setting( 'override_view_order_template', 'no' );
		$settings_manager->add_setting( 'google_places_api_key', '' );
		$settings_manager->add_setting( 'user_matching', 'enabled' );
		$settings_manager->add_setting( 'hide_optional_address_fields_behind_link', 'yes' );
		$settings_manager->add_setting( 'enable_pickup_ship_option', 'yes' );
		$settings_manager->add_setting( 'enable_coupon_code_link', 'yes' );
		$settings_manager->add_setting( 'enable_cart_editing', 'yes' );
		$settings_manager->add_setting( 'enable_order_bumps', 'yes' );
		$settings_manager->add_setting( 'max_bumps', '10' );
		$settings_manager->add_setting( 'max_after_checkout_bumps', '1' );
		$settings_manager->add_setting( 'shake_floating_cart_button', 'no' );
		$settings_manager->add_setting( 'enable_beta_version_updates', 'no' );
		$settings_manager->add_setting( 'show_item_remove_button', 'no' );
		$settings_manager->add_setting( 'enable_promo_codes_on_side_cart', 'no' );
		$settings_manager->add_setting( 'enable_side_cart_totals', 'no' );
		$settings_manager->add_setting( 'side_cart_icon', 'cart-outline.svg' );
		$settings_manager->add_setting( 'footer_text_editor_mode', 'WYSIWYG' );
		$settings_manager->add_setting( 'disable_domain_autocomplete', 'no' );
		$settings_manager->add_setting( 'auto_select_free_shipping_method', 'no' );
		$settings_manager->add_setting( 'show_cart_item_discount', 'yes' );
		$settings_manager->add_setting( 'acr_simulate_only', 'no' );
		$settings_manager->add_setting( 'pickup_methods', array() );
		$settings_manager->add_setting( 'hide_billing_address_for_free_orders', 'no' );
		$settings_manager->add_setting( 'enable_free_shipping_progress_bar_at_checkout', 'no' );
		$settings_manager->add_setting( 'header_scripts', '' );
		$settings_manager->add_setting( 'footer_scripts', '' );
		$settings_manager->add_setting( 'php_snippets', '' );
		$settings_manager->add_setting( 'header_scripts_checkout', '' );
		$settings_manager->add_setting( 'footer_scripts_checkout', '' );
		$settings_manager->add_setting( 'header_scripts_thank_you', '' );
		$settings_manager->add_setting( 'footer_scripts_thank_you', '' );
		$settings_manager->add_setting( 'header_scripts_order_pay', '' );
		$settings_manager->add_setting( 'footer_scripts_order_pay', '' );

		$settings_manager->add_setting(
			'enabled_billing_address_fields',
			array(
				'billing_first_name',
				'billing_last_name',
				'billing_address_1',
				'billing_address_2',
				'billing_company',
				'billing_country',
				'billing_postcode',
				'billing_state',
				'billing_city',
				'billing_phone',
			)
		);

		$custom_logo_id = get_theme_mod( 'custom_logo' );

		// Init templates and template settings
		foreach ( cfw_get_available_templates() as $template ) {
			if ( $custom_logo_id ) {
				$settings_manager->add_setting( 'logo_attachment_id', $custom_logo_id, array( $template->get_slug() ) );
			}

			$settings_manager->add_setting( 'label_style', 'floating', array( $template->get_slug() ) );
			$settings_manager->add_setting( 'footer_text', '', array( $template->get_slug() ) );
			$settings_manager->add_setting( 'custom_css', '', array( $template->get_slug() ) );

			$template->init();
		}
	}
}
