<?php

/**
 *
 * This file is dynamically generated by the WordpressEnqueueChunksPlugin for Webpack.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

namespace WordpressEnqueueChunksPlugin;

class AssetRegistrationException extends \Exception
{
}

;

/**
 * Get a user-defined config setting
 *
 * @param string $key
 * @return mixed
 */
function get($key)
{
    static $config = null;
    if (defined('WPECP_TEST') && WPECP_TEST) {
        return WPECP_TEST_CONFIG[$key];
    }
    if (is_null($config)) {
        $config = json_decode('{"assetsDir":"build","context":"plugin","delimiter":"-","namespace":"cfw","phpScriptDir":"sources/php","manifest":{"chunks":{"cfw-grid":{"file":"css/cfw-grid.css","hash":"b52b1aee0f2fb217a9d9790aea314e6c"},"default-selectwoo":{"file":"js/default-selectwoo.js","hash":"cea6596bf364b1fb6c85dcddfbd13bea"},"selectwoo-styles":{"file":"css/selectwoo-styles.css","hash":"bc77e78ccc6b9a655a3178dcb5d3ab9e"},"selectwoo":{"file":"js/selectwoo.js","hash":"92b071086558288296fbff5f42cd8820"},"default-checkout-admin-order-bumps-editor-side-cart":{"file":"js/default-checkout-admin-order-bumps-editor-side-cart.js","hash":"b322f55ef71d619572f901747b6ee202"},"default-checkout-order-pay-thank-you":{"file":"js/default-checkout-order-pay-thank-you.js","hash":"dc4ad19fdcee1ba947c2d38e8e0ff346"},"default-checkout-536eaa00":{"file":"js/default-checkout-536eaa00.js","hash":"88e2b39a8b00224caa9e209efc535b07"},"default-checkout-e96e9bea":{"file":"js/default-checkout-e96e9bea.js","hash":"0076406721b8f949426f72eb4f7459d3"},"default-checkout-b8c0ddfc":{"file":"js/default-checkout-b8c0ddfc.js","hash":"4cf3ef8456d1fe5eced910a5d86a71bd"},"default-checkout-fcc4d44c":{"file":"js/default-checkout-fcc4d44c.js","hash":"1302b5b24d664692b26fd66a006fa4ca"},"checkout-styles":{"file":"css/checkout-styles.css","hash":"818e840dac6a228dbb4697c1349118e2"},"checkout":{"file":"js/checkout.js","hash":"01db2e68c244efe718c8601696eacac7"},"order-pay-styles":{"file":"css/order-pay-styles.css","hash":"e5c3f7d7e48dd32cae7ccffa7123ca73"},"order-pay":{"file":"js/order-pay.js","hash":"e53b3a1b43d8fbce9b3b6a23a36d45eb"},"thank-you-styles":{"file":"css/thank-you-styles.css","hash":"4acc0cb305ea097c5ed7a3e4a9bca88b"},"thank-you":{"file":"js/thank-you.js","hash":"9951c2676b74ba66cea44875c871e97e"},"admin-mce":{"file":"js/mce.js","hash":"bd06dfde8a0c0a7a9d006e4b72b9aa2e"},"default-admin":{"file":"js/default-admin.js","hash":"68338a022d0c430d0ba4f7177d9cc994"},"admin-styles":{"file":"css/admin-styles.css","hash":"d9dcdeb502a625bcf3d35e94dbb1d041"},"admin":{"file":"js/admin.js","hash":"de492c11caca0865b1dccc1f211ad833"},"default-admin-settings-d2eb5610":{"file":"js/default-admin-settings-d2eb5610.js","hash":"61c1cc508454e10e52ece92774c4905f"},"default-admin-settings-fcd58341":{"file":"js/default-admin-settings-fcd58341.js","hash":"be4faf41bc82e05f6a259018f5295b88"},"default-admin-settings-f82e0cd2":{"file":"js/default-admin-settings-f82e0cd2.js","hash":"3febcc9f14394358d1b28a14ca88feb0"},"default-admin-settings-0bc0478e":{"file":"js/default-admin-settings-0bc0478e.js","hash":"b9a3f967dc26d3926070a7804d844a7f"},"default-admin-settings-b1fb8c12":{"file":"js/default-admin-settings-b1fb8c12.js","hash":"f546b1c29b014bf12b2477cb41022447"},"default-admin-settings-2a46b080":{"file":"js/default-admin-settings-2a46b080.js","hash":"82ae4d9253e6e71ec7f389fa121fb1ed"},"default-admin-settings-67b8a3cc":{"file":"js/default-admin-settings-67b8a3cc.js","hash":"0b0ca5692bd3d96d8063fd43b9d17f22"},"default-admin-settings-27545368":{"file":"js/default-admin-settings-27545368.js","hash":"affeeefec598494779ff23714b702f3d"},"default-admin-settings-a73daea6":{"file":"js/default-admin-settings-a73daea6.js","hash":"b6f79c64e77e588a50208d89d4e8c295"},"default-admin-settings-dbd2ef5d":{"file":"js/default-admin-settings-dbd2ef5d.js","hash":"f92b1a9811f8a03189f81963992ad2f1"},"admin-settings":{"file":"js/admin-settings.js","hash":"6efa315fa06dfe33ef2113572e485f53"},"admin-order-bumps-editor":{"file":"js/admin-order-bumps-editor.js","hash":"6b2df586a3377d89de5eb292aeec41e0"},"admin-plugins-styles":{"file":"css/admin-plugins-styles.css","hash":"0c82fd1126c9263eaf7918c0b34d62b1"},"admin-plugins":{"file":"js/admin-plugins.js","hash":"979c9c58a3572ad0ffc68f80aa7b1c26"},"default-side-cart-2b4841d6":{"file":"js/default-side-cart-2b4841d6.js","hash":"a5a8269d1b2e4e870d903c4757d7b32e"},"default-side-cart-e96e9bea":{"file":"js/default-side-cart-e96e9bea.js","hash":"bad0c11c02c68dfd91cb672de3bdcbe7"},"side-cart-styles":{"file":"css/side-cart-styles.css","hash":"4983648af07ca6f57800caf2b37f194d"},"side-cart":{"file":"js/side-cart.js","hash":"5e8682fef378e6edd683f23dfd741066"},"blocks-styles":{"file":"css/blocks-styles.css","hash":"27212a3cfebe639d41fc2517679420b4"},"blocks":{"file":"js/blocks.js","hash":"c11ba6136f3e553f21444d97dda5dce4"},"default-utils-script":{"file":"js/default-utils-script.js","hash":"22f259cd5622da15fc110d56b09479f0"},"utils-script":{"file":"js/utils.js","hash":"1b73997c715b9986ebb300f8a67ccb59"}},"entries":{"cfw-grid":{"deps":[]},"selectwoo":{"deps":["default-selectwoo","selectwoo-styles"]},"checkout":{"deps":["default-checkout-admin-order-bumps-editor-side-cart","default-checkout-order-pay-thank-you","default-checkout-536eaa00","default-checkout-e96e9bea","default-checkout-b8c0ddfc","default-checkout-fcc4d44c","checkout-styles"]},"order-pay":{"deps":["default-checkout-order-pay-thank-you","order-pay-styles"]},"thank-you":{"deps":["default-checkout-order-pay-thank-you","thank-you-styles"]},"admin-mce":{"deps":[]},"admin":{"deps":["default-admin","admin-styles"]},"admin-settings":{"deps":["default-admin-settings-d2eb5610","default-admin-settings-fcd58341","default-admin-settings-f82e0cd2","default-admin-settings-0bc0478e","default-admin-settings-b1fb8c12","default-admin-settings-2a46b080","default-admin-settings-67b8a3cc","default-admin-settings-27545368","default-admin-settings-a73daea6","default-admin-settings-dbd2ef5d"]},"admin-order-bumps-editor":{"deps":["default-checkout-admin-order-bumps-editor-side-cart"]},"admin-plugins":{"deps":["admin-plugins-styles"]},"side-cart":{"deps":["default-checkout-admin-order-bumps-editor-side-cart","default-side-cart-2b4841d6","default-side-cart-e96e9bea","side-cart-styles"]},"blocks":{"deps":["blocks-styles"]},"utils-script":{"deps":["default-utils-script"]}}},"prefix":"cfw-"}', true);
    }
    return isset($config[$key]) ? $config[$key] : null;
}

/**
 * Get an array of chunks and chunk meta from an array of script names
 *
 * @param array $assets
 * @param array $manifest
 * @return array
 */
function getChunks(array $assets, array $manifest)
{
    if (empty($assets)) {
        return $manifest['chunks'];
    }
    $deps = array_reduce($assets, function ($acc, $asset) use ($manifest) {
        if (isset($manifest['entries'][$asset])) {
            return array_merge($acc, $manifest['entries'][$asset]['deps']);
        }
        return $acc;
    }, []);
    $keys = array_flip(array_unique(array_merge($assets, $deps)));
    return array_intersect_key($manifest['chunks'], $keys);
}

/**
 * Builds a script handle
 *
 * @param string $asset
 * @return string
 */
function makeHandle($asset)
{
    $namespace = get('namespace');
    $delimiter = get('delimiter');
    return "{$namespace}{$delimiter}{$asset}";
}

/**
 * Check if a script has already been registered
 *
 * @param string $asset
 * @return boolean
 */
function isRegistered($asset)
{
    return wp_script_is(makeHandle($asset), 'registered');
}

/**
 * Get the full url to an asset
 *
 * @param string $file
 * @param string $context
 * @return string
 */
function getAssetUrl($file, $context)
{
    $dir = trailingslashit(get('assetsDir'));
    if ($context === 'plugin') {
        return plugins_url($dir . $file);
    }
    return get_theme_file_uri($dir . $file);
}

/**
 * Maps an asset's dependencies by handle
 *
 * @param string $asset
 * @return array
 */
function mapDependencies($asset)
{
    $manifest = get('manifest');
    if (isset($manifest['entries'][$asset])) {
        $deps = $manifest['entries'][$asset]['deps'];
        return array_map(__NAMESPACE__ . '\\makeHandle', $deps);
    }
    return [];
}

/**
 * Generates arguments to be passed to wp_register_script
 *
 * @param string $asset
 * @param array $data
 * @return array
 */
function makeScriptArgs($asset, array $data)
{
    $handle = makeHandle($asset);
    $src = getAssetUrl($data['file'], get('context'));
    $deps = mapDependencies($asset);
    $version = $data['hash'];
    $inFooter = true; // @TODO: expose this to the user
    return compact('handle', 'src', 'deps', 'version', 'inFooter');
}

/**
 * Register an asset
 *
 * @param string $asset
 * @param array $args
 * @return boolean
 */
function register($asset, array $args)
{
    if (isRegistered($asset)) {
        return true;
    }
    $filtered = apply_filters("wpecp/register", $args, $asset);
    $filtered = apply_filters("wpecp/register/$asset", $filtered);
    $success = call_user_func_array('wp_register_script', array_values($filtered));
    if (!$success) {
        throw new AssetRegistrationException("Unable to register asset $asset!");
    }
    return true;
}

/**
 * Registers all or just some of the assets in a manifest
 *
 * @param array $scripts
 * @return void
 */
function registerScripts(array $scripts = [])
{
    $manifest = get('manifest');
    foreach (getChunks($scripts, $manifest) as $chunk => $data) {
        if (isRegistered($chunk)) {
            continue;
        }
        $args = makeScriptArgs($chunk, $data);
        register($chunk, $args);
    }
}
