<?php
namespace Objectiv\Plugins\Checkout\Compatibility\Plugins;

use Objectiv\Plugins\Checkout\Compatibility\CompatibilityAbstract;

class AllProductsForSubscriptions extends CompatibilityAbstract {
	protected $side_cart_feature_active = false;
	public function is_available(): bool {
		return function_exists( 'WCS_ATT' );
	}

	public function pre_init() {
		if ( ! $this->is_available() || ! $this->side_cart_feature_active ) {
			return;
		}

		add_filter( 'wcsatt_enqueue_cart_script', '__return_true' );
		add_filter( 'cfw_enable_side_cart_woocommerce_after_cart_totals_hook', '__return_true' );
	}

	public function setup( bool $side_cart_feature_active ): AllProductsForSubscriptions {
		$this->side_cart_feature_active = $side_cart_feature_active;

		return $this;
	}
}
