<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
if (!class_exists('FP_RAC_Previous_Orders_Tab')) {

    /**
     * FP_RAC_Previous_Orders_Tab Class.
     */
    class FP_RAC_Previous_Orders_Tab {

        public static function init() {
            add_action('woocommerce_fprac_settings_tabs_fpracupdate', array(__CLASS__, 'fp_rac_admin_setting_previous_orders'));
            add_action('woocommerce_admin_field_rac_display_check_previous_orders', array(__CLASS__, 'rac_display_check_previous_orders'));
            add_action('woocommerce_update_options_fpracupdate', array(__CLASS__, 'fp_rac_cron_time_save'));
        }

        public static function fp_rac_menu_options_previous_orders() {
            return apply_filters('woocommerce_fpracemail_settings', array(
                array(
                    'type' => 'rac_display_check_previous_orders',
                )
                    )
            );
        }

        public static function fp_rac_cron_time_save() {
            if(isset($_POST['rac_auto_recover_previous_order']))
                update_option('rac_auto_recover_previous_order', $_POST['rac_auto_recover_previous_order']);
            
            if(isset($_POST['rac_previous_order_cron_time']))
                update_option('rac_previous_order_cron_time', $_POST['rac_previous_order_cron_time']);
            
            if(isset($_POST['rac_previous_cart_cron_type']))
                update_option('rac_previous_cart_cron_type', $_POST['rac_previous_cart_cron_type']);
            
            if(isset($_POST['rac_auto_order_status']))
                update_option('rac_auto_order_status', $_POST['rac_auto_order_status']);
        }

        public static function fp_rac_admin_setting_previous_orders() {
            woocommerce_admin_fields(FP_RAC_Previous_Orders_Tab::fp_rac_menu_options_previous_orders());
        }

        public static function rac_display_check_previous_orders() {

            include_once RAC_PLUGIN_PATH . '/inc/fp-rac-previous-order.php';
            $automatic_previous_order   = get_option("rac_auto_recover_previous_order", "1");
            $previous_order_status      = get_option('rac_auto_order_status', array());
            ?>
            <h2><?php esc_html_e('Automatic', 'recoverabandoncart'); ?></h2>
            <table class="form-table">
                <tr>
                    <th><?php esc_html_e('Automatic Cron Job', 'recoverabandoncart'); ?></th>
                    <td>
                        <select id="rac_auto_recover_previous_order" name="rac_auto_recover_previous_order">
                            <option value = "1" <?php selected($automatic_previous_order, "1") ?> ><?php esc_html_e("Disable", "recoverabandoncart"); ?></option>
                            <option value = "2" <?php selected($automatic_previous_order, "2") ?> ><?php esc_html_e("Enable", "recoverabandoncart"); ?></option>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th class="titledesc" scope="row">
                        <label for="rac_previous_order_cron_time"><?php esc_html_e('Check Previous Order After', 'recoverabandoncart'); ?></label>
                    </th>
                    <td class="forminp forminp-select">
                        <input type="text" id="rac_previous_order_cron_time" class="rac_automatic_pre_orders_fields" style="width:45px;height:28px" data-min = "0.01" name="rac_previous_order_cron_time" class="fp_text_min_max" value="<?php echo get_option('rac_previous_order_cron_time', 12); ?>"/>
                        <select id="rac_previous_cart_cron_type" class="rac_automatic_pre_orders_fields" name="rac_previous_cart_cron_type" style="width:100px;margin-top: -2px;">
                            <?php echo FP_RAC_Email_Template::rac_mail_duration_select_options(get_option('rac_previous_cart_cron_type', 'hours') , true) ?>
                        </select>
                        <?php
                        $tooltip_html = esc_html__('of placing the order', 'recoverabandoncart');
                        echo '<b>'. $tooltip_html.'</b>';
                        ?>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Add Old WooCommerce Orders to Cart List which are in', 'recoverabandoncart'); ?></th>
                    <td class="rac_automatic_pre_orders_fields">
                        <p><input type = "checkbox" <?php echo (in_array('wc-on-hold', $previous_order_status)) ? 'checked="checked"' : ''; ?>name = "rac_auto_order_status[]" value = "wc-on-hold"><?php esc_html_e("On hold status", "recoverabandoncart") ?></p>
                        <p><input type = "checkbox" <?php echo (in_array('wc-pending', $previous_order_status)) ? 'checked="checked"' : ''; ?>name = "rac_auto_order_status[]" value = "wc-pending"><?php esc_html_e("Pending payment status", "recoverabandoncart"); ?></p>
                        <p><input type = "checkbox" <?php echo (in_array('wc-failed', $previous_order_status)) ? 'checked="checked"' : ''; ?>name = "rac_auto_order_status[]" value = "wc-failed" ><?php esc_html_e("Failed status", "recoverabandoncart"); ?></p>
                        <p><input type = "checkbox" <?php echo (in_array('wc-cancelled', $previous_order_status)) ? 'checked="checked"' : ''; ?>name = "rac_auto_order_status[]" value = "wc-cancelled"><?php esc_html_e("Cancelled status", "recoverabandoncart"); ?></p>
                    </td>
                </tr>
                <tr>
                    <td><span class = "submit" style = "margin-left: 25px;">
                            <?php if (!isset($GLOBALS['hide_save_button'])) :
                                ?>
                                <input name="save" class="button-primary" style="margin-top:15px;" type="submit" value="<?php esc_html_e('Save', 'recoverabandoncart'); ?>" />
                            <?php endif; ?>
                            <input type="hidden" name="subtab" id="last_tab" />
                            <?php wp_nonce_field('woocommerce-settings'); ?>
                        </span></td>
                </tr>
            </table>
            <h2><?php esc_html_e('Manual', 'recoverabandoncart') ?></h2>
            <table class="form-table">

                <tr>
                    <th><?php esc_html_e('Add Old WooCommerce Orders to Cart List which are in', 'recoverabandoncart'); ?></th>
                    <td>
                        <p><input type = "checkbox" name = "order_status[]" value = "wc-on-hold"><?php esc_html_e("On hold status", "recoverabandoncart") ?></p>
                        <p><input type = "checkbox" name = "order_status[]" value = "wc-pending"><?php esc_html_e("Pending payment status", "recoverabandoncart"); ?></p>
                        <p><input type = "checkbox" name = "order_status[]" value = "wc-failed" checked><?php esc_html_e("Failed status", "recoverabandoncart"); ?></p>
                        <p><input type = "checkbox" name = "order_status[]" value = "wc-cancelled"><?php esc_html_e("Cancelled status", "recoverabandoncart"); ?></p>
                    </td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Time Duration', 'recoverabandoncart'); ?></th>
                    <td>
                        <select id = "order_time">
                            <option value = "all"><?php esc_html_e("All time", "recoverabandoncart"); ?></option>
                            <option value = "specific"><?php esc_html_e("Specific", "recoverabandoncart"); ?></option>
                        </select>
                    </td>
                </tr>
                <tr style = "display: none" id = "specific_row">
                    <th><?php esc_html_e("Specific Time", "recoverabandoncart"); ?></th>
                    <td>
                        <label><?php esc_html_e("From", "recoverabandoncart"); ?></label>
                        <input type = "text" name = "from_date" id = "from_time" class = "rac_date">
                        <label><?php esc_html_e("To", "recoverabandoncart"); ?></label>
                        <input type = "text" id = "to_time" name = "to_date" class = "rac_date">
                    </td>
                </tr>
                <tr>
                    <td>
                        <input type = "button" class = "button button-primary" name = "update_order" id = "update_order" value = "<?php esc_html_e("Check for Abandoned Cart", "recoverabandoncart"); ?>">
                    </td>
                    <td>
                        <img style = "width: 30px;height: 30px;display: none;" class = "perloader_image" src = "<?php echo RAC_PLUGIN_URL ?>/assets/images/update.gif"/>
                        <p id = "update_response"></p>
                    </td>
                </tr>
            </table>
            <?php
        }

    }

    FP_RAC_Previous_Orders_Tab::init();
}