/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./source/admin/js/ace-editor.js":
/*!***************************************!*\
  !*** ./source/admin/js/ace-editor.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ace_editor_init)
/* harmony export */ });
/**
 * Ace Editor.
 * 
 * The settings page uses a CSS code editor for custom CSS.
 * Initiate the 'Ace Editor' so that it shows as CSS syntax.
 */
function ace_editor_init() {
  var editor = ace.edit('styles_checkout_custom_css_ace_editor');
  var textarea = document.getElementById('styles_checkout_custom_css');
  editor.setTheme("ace/theme/chrome");
  editor.session.setMode("ace/mode/css");
  editor.setOptions({
    showPrintMargin: false
  });
  editor.getSession().setValue(textarea.value);
  editor.getSession().on('change', function () {
    textarea.value = editor.getSession().getValue();
  });
}

/***/ }),

/***/ "./source/admin/js/dynamic-settings.js":
/*!*********************************************!*\
  !*** ./source/admin/js/dynamic-settings.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "colour_type_init": () => (/* binding */ colour_type_init),
/* harmony export */   "header_background_init": () => (/* binding */ header_background_init),
/* harmony export */   "header_type_init": () => (/* binding */ header_type_init),
/* harmony export */   "init_gradient_field": () => (/* binding */ init_gradient_field),
/* harmony export */   "modern_colour_options_init": () => (/* binding */ modern_colour_options_init),
/* harmony export */   "option_reset_init": () => (/* binding */ option_reset_init)
/* harmony export */ });
/**
 * Header Type.
 * 
 * Show and hides controls based on the Header Type chosen.
 */
function header_type_init() {
  var header_type = document.getElementsByClassName('header-type');
  if (!header_type.length) {
    return;
  }
  Array.from(header_type).forEach(function (object) {
    var header_type_text_elements = object.closest('.wpsf-tab').getElementsByClassName('header-type--text');
    var header_type_image_elements = object.closest('.wpsf-tab').getElementsByClassName('header-type--image');
    if (!object.classList.contains('flux-field-init')) {
      object.classList.add('flux-field-init');
      object.addEventListener('change', function () {
        header_type_init();
        modern_colour_options_init();
      });
    }
    Array.from(header_type_text_elements).forEach(function (el) {
      el.closest('tr').style.display = object.value === 'text' ? '' : 'none';
    });
    Array.from(header_type_image_elements).forEach(function (el) {
      el.closest('tr').style.display = object.value === 'image' ? '' : 'none';
    });
  });
}

/**
 * Header Background.
 * 
 * Show and hides controls based on the Header Background chosen.
 */
function header_background_init() {
  var header_background = document.querySelectorAll('.header-background');
  var header_background_checked = document.querySelectorAll('.header-background:checked');
  if (!header_background_checked.length) {
    return;
  }
  Array.from(header_background).forEach(function (object) {
    if (!object.classList.contains('flux-field-init')) {
      object.classList.add('flux-field-init');
      object.addEventListener('change', function () {
        header_background_init();
        modern_colour_options_init();
      });
    }
  });
  Array.from(header_background_checked).forEach(function (object) {
    var header_background_custom_elements = object.closest('.wpsf-tab').getElementsByClassName('header-background--custom');
    var header_background_gradient_elements = object.closest('.wpsf-tab').getElementsByClassName('header-background--gradient');
    Array.from(header_background_custom_elements).forEach(function (el) {
      el.closest('tr').style.display = object.value === 'custom' ? '' : 'none';
    });
    Array.from(header_background_gradient_elements).forEach(function (el) {
      console.log(el.closest('tr'));
      console.log(object.value === 'gradient' ? '' : 'none');
      el.closest('tr').style.display = object.value === 'gradient' ? '' : 'none';
    });
  });
}

/**
 * Colour Type.
 * 
 * Show and hides controls based on the Colour Type chosen.
 */
function colour_type_init() {
  var colour_type = document.querySelectorAll('.colour-type');
  var colour_type_checked = document.querySelectorAll('.colour-type:checked');
  if (!colour_type_checked.length) {
    return;
  }

  // Add event listner only once.
  Array.from(colour_type).forEach(function (object) {
    if (!object.classList.contains('flux-field-init')) {
      object.classList.add('flux-field-init');
      object.addEventListener('change', function () {
        colour_type_init();
      });
    }
  });
  Array.from(colour_type_checked).forEach(function (object) {
    var colour_type_palette_elements = object.closest('.wpsf-tab').getElementsByClassName('colour-type--palette');
    var colour_type_primary_elements = object.closest('.wpsf-tab').getElementsByClassName('colour-type--primary');
    Array.from(colour_type_palette_elements).forEach(function (el) {
      el.closest('tr').style.display = object.value === 'mdl' ? '' : 'none';
    });
    Array.from(colour_type_primary_elements).forEach(function (el) {
      el.closest('tr').style.display = object.value === 'custom' ? '' : 'none';
    });
  });
}

/**
 * Modern Colour Options.
 * 
 * Alter the colour options available for the modern theme.
 */
function modern_colour_options_init() {
  let theme = jQuery('.flux-theme-type:checked').val();
  if ('modern' !== theme) {
    return;
  }
  document.getElementById('styles_header_header_font_family').closest('tr').style.display = 'none';
  document.getElementById('styles_header_header_font_size').closest('tr').style.display = 'none';
  document.getElementById('styles_header_header_font_colour').closest('tr').style.display = 'none';
  document.getElementById('styles_header_header_background_primary-color').closest('tr').style.display = 'none';
  document.getElementById('styles_header_background').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_primary_color_#f44336').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_accent_color_#f44336').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_custom_primary_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_custom_accent_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_modern_custom_placeholder_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_modern_custom_link_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_modern_custom_primary_button_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_modern_custom_secondary_button_color').closest('tr').style.display = '';
  document.getElementById('styles_header_cart_icon_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_use_custom_colors_custom').closest('tr').style.display = 'none';
  document.getElementById('styles_theme_show_sidebar').closest('tr').style.display = 'none';
}
function option_reset_init() {
  let theme = jQuery('.flux-theme-type:checked').val();
  if (!jQuery('.flux-theme-type').hasClass('flux-field-init')) {
    jQuery('.flux-theme-type').addClass('flux-field-init');
    jQuery('.flux-theme-type').change(option_reset_init);
    jQuery('.flux-theme-type').change(modern_colour_options_init);
  }
  if ('modern' === theme) {
    return;
  }
  document.getElementById('styles_header_header_font_family').closest('tr').style.display = '';
  document.getElementById('styles_header_header_font_size').closest('tr').style.display = '';
  document.getElementById('styles_header_header_font_colour').closest('tr').style.display = '';
  document.getElementById('styles_header_header_background_primary-color').closest('tr').style.display = '';
  document.getElementById('styles_header_background').closest('tr').style.display = '';
  document.getElementById('styles_checkout_primary_color_#f44336').closest('tr').style.display = '';
  document.getElementById('styles_checkout_accent_color_#f44336').closest('tr').style.display = '';
  document.getElementById('styles_checkout_custom_primary_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_custom_accent_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_modern_custom_placeholder_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_modern_custom_link_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_modern_custom_primary_button_color').closest('tr').style.display = 'none';
  document.getElementById('styles_checkout_modern_custom_secondary_button_color').closest('tr').style.display = 'none';
  document.getElementById('styles_header_cart_icon_color').closest('tr').style.display = '';
  document.getElementById('styles_checkout_use_custom_colors_custom').closest('tr').style.display = '';
  document.getElementById('styles_theme_show_sidebar').closest('tr').style.display = '';
}

/**
 * Initialize gradient picker field.
 */
function init_gradient_field() {
  const option_html = function (data) {
    var gradient = jQuery(data.element).attr('value');
    var css = `background: linear-gradient(to left, ${gradient} )`;
    return `<span class='flux-gradient-preview-dot' style='${css}'></span> ${data.text}`;
  };
  jQuery("#styles_header_background").select2({
    templateSelection: option_html,
    templateResult: option_html,
    escapeMarkup: function (m) {
      return m;
    }
  });
}

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!*********************************!*\
  !*** ./source/admin/js/main.js ***!
  \*********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ace_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ace-editor */ "./source/admin/js/ace-editor.js");
/* harmony import */ var _dynamic_settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dynamic-settings */ "./source/admin/js/dynamic-settings.js");


document.addEventListener('DOMContentLoaded', function () {
  (0,_ace_editor__WEBPACK_IMPORTED_MODULE_0__["default"])();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.option_reset_init)();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.header_type_init)();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.header_background_init)();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.colour_type_init)();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.modern_colour_options_init)();
  (0,_dynamic_settings__WEBPACK_IMPORTED_MODULE_1__.init_gradient_field)();
});
})();

/******/ })()
;
//# sourceMappingURL=main.js.map