<?php
/**
 * Plugin Name: Flux Checkout
 * Description: Optimised multi-step checkout plugin for WooCommerce.
 * Plugin URI: https://iconicwp.com/products/flux-checkout-for-woocommerce/
 * Author: Iconic
 * Version: 2.3.2
 * Update URI: https://api.freemius.com
 * WC requires at least: 3.4.2
 * WC tested up to: 7.4.1
 * Author URI: https://iconicwp.com/
 * Text Domain: flux-checkout
 * Domain Path: /languages/
 *
 * @package Iconic_Flux
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Iconic_Flux
 */
class Iconic_Flux_Checkout {
	/**
	 * Plugin version.
	 *
	 * @var string
	 */
	public static $version = '2.3.2';

	/**
	 * Settings array.
	 *
	 * @var array
	 */
	public $settings = array();

	/**
	 * Plugin initiated.
	 *
	 * @var bool
	 */
	public $initiated = false;

	/**
	 * Construct the plugin
	 */
	public function __construct() {
		load_plugin_textdomain( 'iconic-flux', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

		$this->define_constants();
		$this->setup_autoloader();

		if ( ! Iconic_Flux_Core_Helpers::is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
			return;
		}

		$this->load_classes();
		$this->initiated = true;
	}

	/**
	 * Run on activation.
	 */
	public static function activate() {
		if ( ! get_option( 'iconic_flux_flush_rewrite_rules_flag' ) ) {
			add_option( 'iconic_flux_flush_rewrite_rules_flag', true );
		}

		self::clear_wc_template_cache();
	}

	/**
	 * Deactivate plugin.
	 *
	 * @return void
	 */
	public static function deactivate() {
		self::clear_wc_template_cache();
	}

	/**
	 * Clear WooCommerce template cache.
	 *
	 * @return void
	 */
	public static function clear_wc_template_cache() {
		if ( function_exists( 'wc_clear_template_cache' ) ) {
			wc_clear_template_cache();
		}
	}

	/**
	 * Define Constants.
	 */
	private function define_constants() {
		$this->define( 'ICONIC_FLUX_FILE', __FILE__ );
		$this->define( 'ICONIC_FLUX_PATH', plugin_dir_path( __FILE__ ) );
		$this->define( 'ICONIC_FLUX_URL', plugin_dir_url( __FILE__ ) );
		$this->define( 'ICONIC_FLUX_INC_PATH', ICONIC_FLUX_PATH . 'inc/' );
		$this->define( 'ICONIC_FLUX_VENDOR_PATH', ICONIC_FLUX_INC_PATH . 'vendor/' );
		$this->define( 'ICONIC_FLUX_TPL_PATH', ICONIC_FLUX_PATH . 'templates/' );
		$this->define( 'ICONIC_FLUX_BASENAME', plugin_basename( __FILE__ ) );
		$this->define( 'ICONIC_FLUX_VERSION', self::$version );

		$this->define( 'FLUX_PLUGIN_VERSION', ICONIC_FLUX_VERSION ); // Needed for third party compatibility (IE Sales Booster).
	}

	/**
	 * Setup autoloader.
	 */
	private function setup_autoloader() {
		require_once ICONIC_FLUX_INC_PATH . 'class-core-autoloader.php';

		Iconic_Flux_Core_Autoloader::run(
			array(
				'prefix'   => 'Iconic_Flux_',
				'inc_path' => ICONIC_FLUX_INC_PATH,
			)
		);
	}

	/**
	 * Define constant if not already set.
	 *
	 * @param string      $name Name.
	 * @param string|bool $value Value.
	 */
	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}

	/**
	 * Load classes
	 */
	private function load_classes() {
		$this->init_licence();

		// @todo Set correct paths.
		// @todo Set correct cross sells.
		Iconic_Flux_Core_Settings::run(
			array(
				'basename'      => ICONIC_FLUX_BASENAME,
				'vendor_path'   => ICONIC_FLUX_VENDOR_PATH,
				'title'         => 'Flux Checkout for WooCommerce',
				'version'       => self::$version,
				'menu_title'    => 'Flux Checkout',
				'settings_path' => ICONIC_FLUX_INC_PATH . 'admin/settings.php',
				'option_group'  => 'iconic_flux',
				'docs'          => array(
					'collection'      => '/docs/flux-checkout-for-woocommerce/',
					'troubleshooting' => '/docs/flux-checkout-for-woocommerce/flux-user-guides/',
					'getting-started' => '/docs/flux-checkout-for-woocommerce/flux-getting-started/',
				),
			)
		);

		if ( ! Iconic_Flux_Core_Licence::has_valid_licence() ) {
			return;
		}

		Iconic_Flux_Upgrade::run();
		Iconic_Flux_Core::run();
		Iconic_Flux_Assets::run();

		add_action( 'plugins_loaded', array( 'Iconic_Flux_Core_Onboard', 'run' ), 10 );
	}

	/**
	 * Init licence class.
	 */
	public function init_licence() {
		Iconic_Flux_Core_Licence::run(
			array(
				'basename' => ICONIC_FLUX_BASENAME,
				'urls'     => array(
					'product'  => 'https://iconicwp.com/products/', // Product page on iconicwp.com.
					'settings' => admin_url( 'admin.php?page=iconic-flux-settings' ), // Admin settings page.
					'account'  => admin_url( 'admin.php?page=iconic-flux-settings-account' ), // Admin account page.
				),
				'paths'    => array(
					'inc'    => ICONIC_FLUX_INC_PATH,
					'plugin' => ICONIC_FLUX_PATH,
					'file'   => __FILE__,
				),
				'freemius' => array(
					'id'               => '5383',
					'slug'             => 'flux-checkout',
					'type'             => 'plugin',
					'public_key'       => 'pk_62e3953ae5e35b8b1163a29e035a7',
					'is_premium'       => true,
					'is_premium_only'  => true,
					'has_addons'       => false,
					'has_paid_plans'   => true,
					'is_org_compliant' => false,
					'trial'            => array(
						'days'               => 14,
						'is_require_payment' => true,
					),
					'menu'             => array(
						'slug'       => 'iconic-flux-settings',
						'first-path' => 'admin.php?page=iconic-flux-settings',
						'contact'    => false,
						'support'    => false,
						'parent'     => array(
							'slug' => 'woocommerce',
						),
					),
				),
			)
		);
	}
}

$iconic_flux_checkout = new Iconic_Flux_Checkout();

if ( $iconic_flux_checkout->initiated ) {
	register_activation_hook( __FILE__, array( $iconic_flux_checkout, 'activate' ) );
	register_deactivation_hook( __FILE__, array( $iconic_flux_checkout, 'deactivate' ) );

	if ( ! Iconic_Flux_Core_Licence::has_valid_licence() ) {
		return;
	}

	require_once ICONIC_FLUX_PATH . 'inc/compatibility.php';
}
