<?php
/**
 * Google fonts functions.
 *
 * @package Iconic_Flux
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'iconic_flux_get_google_fonts' ) ) {
	/**
	 * Get Google Fonts
	 *
	 * @return array
	 */
	function iconic_flux_get_google_fonts() {
		return array(
			array(
				'name'     => 'ABeeZee',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Abel',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Abril Fatface',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Aclonica',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Acme',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Actor',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Adamina',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Advent Pro',
				'subsets'  => array( 'greek', 'latin-ext', 'latin' ),
				'variants' => array( '100', '200', '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Aguafina Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Akronim',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Aladin',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Aldrich',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Alef',
				'subsets'  => array( 'latin', 'hebrew' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Alegreya',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Alegreya SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Alegreya Sans',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Alegreya Sans SC',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Alex Brush',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Alfa Slab One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Alice',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Alike',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Alike Angular',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Allan',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Allerta',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Allerta Stencil',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Allura',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Almendra',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Almendra Display',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Almendra SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Amarante',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Amaranth',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Amatic SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Amethysta',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Amiri',
				'subsets'  => array( 'arabic', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Amita',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Anaheim',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Andada',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Andika',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Angkor',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Annie Use Your Telescope',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Anonymous Pro',
				'subsets'  => array( 'greek', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Antic',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Antic Didone',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Antic Slab',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Anton',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Arapey',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Arbutus',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Arbutus Slab',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Architects Daughter',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Archivo Black',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Archivo Narrow',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Arimo',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'hebrew', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Arizonia',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Armata',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Artifika',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Arvo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Arya',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Asap',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Asar',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Asset',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Astloch',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Asul',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Atomic Age',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Aubrey',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Audiowide',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Autour One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Average',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Average Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Averia Gruesa Libre',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Averia Libre',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Averia Sans Libre',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Averia Serif Libre',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Bad Script',
				'subsets'  => array( 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Balthazar',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bangers',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Basic',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Battambang',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Baumans',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bayon',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Belgrano',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Belleza',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'BenchNine',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Bentham',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Berkshire Swash',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bevan',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bigelow Rules',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bigshot One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bilbo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bilbo Swash Caps',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Biryani',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '200', '300', '400', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Bitter',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Black Ops One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bokor',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bonbon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Boogaloo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bowlby One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bowlby One SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Brawler',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bree Serif',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bubblegum Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Bubbler One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Buda',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300' ),
			),
			array(
				'name'     => 'Buenard',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Butcherman',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Butterfly Kids',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cabin',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Cabin Condensed',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Cabin Sketch',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Caesar Dressing',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cagliostro',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Calligraffitti',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cambay',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Cambo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Candal',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cantarell',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Cantata One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cantora One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Capriola',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cardo',
				'subsets'  => array( 'greek-ext', 'greek', 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Carme',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Carrois Gothic',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Carrois Gothic SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Carter One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Catamaran',
				'subsets'  => array( 'latin-ext', 'latin', 'tamil' ),
				'variants' => array( '100', '200', '300', '400', '500', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Caudex',
				'subsets'  => array( 'greek-ext', 'greek', 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Cedarville Cursive',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ceviche One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Changa One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Chango',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Chau Philomene One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Chela One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Chelsea Market',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Chenla',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cherry Cream Soda',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cherry Swash',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Chewy',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Chicle',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Chivo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Chonburi',
				'subsets'  => array( 'latin-ext', 'latin', 'thai', 'vietnamese' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cinzel',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700', '900' ),
			),
			array(
				'name'     => 'Cinzel Decorative',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700', '900' ),
			),
			array(
				'name'     => 'Clicker Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Coda',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '800' ),
			),
			array(
				'name'     => 'Coda Caption',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '800' ),
			),
			array(
				'name'     => 'Codystar',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400' ),
			),
			array(
				'name'     => 'Combo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Comfortaa',
				'subsets'  => array( 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Coming Soon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Concert One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Condiment',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Content',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Contrail One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Convergence',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cookie',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Copse',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Corben',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Courgette',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cousine',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'hebrew', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Coustard',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '900' ),
			),
			array(
				'name'     => 'Covered By Your Grace',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Crafty Girls',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Creepster',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Crete Round',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Crimson Text',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '600', '600italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Croissant One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Crushed',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cuprum',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Cutive',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Cutive Mono',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Damion',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dancing Script',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Dangrek',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dawning of a New Day',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Days One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dekko',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Delius',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Delius Swash Caps',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Delius Unicase',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Della Respira',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Denk One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Devonshire',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dhurjati',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Didact Gothic',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Diplomata',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Diplomata SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Domine',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Donegal One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Doppio One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dorsa',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dosis',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '200', '300', '400', '500', '600', '700', '800' ),
			),
			array(
				'name'     => 'Dr Sugiyama',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Droid Sans',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Droid Sans Mono',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Droid Serif',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Duru Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Dynalight',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'EB Garamond',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Eagle Lake',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Eater',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Economica',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Eczar',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '500', '600', '700', '800' ),
			),
			array(
				'name'     => 'Ek Mukta',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '200', '300', '400', '500', '600', '700', '800' ),
			),
			array(
				'name'     => 'Electrolize',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Elsie',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '900' ),
			),
			array(
				'name'     => 'Elsie Swash Caps',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '900' ),
			),
			array(
				'name'     => 'Emblema One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Emilys Candy',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Engagement',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Englebert',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Enriqueta',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Erica One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Esteban',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Euphoria Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ewert',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Exo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Exo 2',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Expletus Sans',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Fanwood Text',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Fascinate',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fascinate Inline',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Faster One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fasthand',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fauna One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Federant',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Federo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Felipa',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fenix',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Finger Paint',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fira Mono',
				'subsets'  => array( 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Fira Sans',
				'subsets'  => array( 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Fjalla One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fjord One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Flamenco',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '400' ),
			),
			array(
				'name'     => 'Flavors',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fondamento',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Fontdiner Swanky',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Forum',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Francois One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Freckle Face',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fredericka the Great',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fredoka One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Freehand',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fresca',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Frijole',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fruktur',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Fugaz One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'GFS Didot',
				'subsets'  => array( 'greek' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'GFS Neohellenic',
				'subsets'  => array( 'greek' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Gabriela',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gafata',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Galdeano',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Galindo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gentium Basic',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Gentium Book Basic',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Geo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Geostar',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Geostar Fill',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Germania One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gidugu',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gilda Display',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Give You Glory',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Glass Antiqua',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Glegoo',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Gloria Hallelujah',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Goblin One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gochi Hand',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gorditas',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Goudy Bookletter 1911',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Graduate',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Grand Hotel',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gravitas One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Great Vibes',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Griffy',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gruppo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Gudea',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Gurajada',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Habibi',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Halant',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Hammersmith One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Hanalei',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Hanalei Fill',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Handlee',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Hanuman',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Happy Monkey',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Headland One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Henny Penny',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Herr Von Muellerhoff',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Hind',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Hind Siliguri',
				'subsets'  => array( 'bengali', 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Hind Vadodara',
				'subsets'  => array( 'latin-ext', 'latin', 'gujarati' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Holtwood One SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Homemade Apple',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Homenaje',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'IM Fell DW Pica',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'IM Fell DW Pica SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'IM Fell Double Pica',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'IM Fell Double Pica SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'IM Fell English',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'IM Fell English SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'IM Fell French Canon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'IM Fell French Canon SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'IM Fell Great Primer',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'IM Fell Great Primer SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Iceberg',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Iceland',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Imprima',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Inconsolata',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Inder',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Indie Flower',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Inika',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Inknut Antiqua',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Irish Grover',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Istok Web',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Italiana',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Italianno',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Itim',
				'subsets'  => array( 'latin-ext', 'latin', 'thai', 'vietnamese' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jacques Francois',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jacques Francois Shadow',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jaldi',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Jim Nightshade',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jockey One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jolly Lodger',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Josefin Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Josefin Slab',
				'subsets'  => array( 'latin' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Joti One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Judson',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Julee',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Julius Sans One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Junge',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Jura',
				'subsets'  => array( 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '300', '400', '500', '600' ),
			),
			array(
				'name'     => 'Just Another Hand',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Just Me Again Down Here',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kadwa',
				'subsets'  => array( 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Kalam',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Kameron',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Kantumruy',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Karla',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Karma',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Kaushan Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kavoon',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kdam Thmor',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Keania One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kelly Slab',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kenia',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Khand',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Khmer',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Khula',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '600', '700', '800' ),
			),
			array(
				'name'     => 'Kite One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Knewave',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kotta One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Koulen',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kranky',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kreon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Kristi',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Krona One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Kurale',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'La Belle Aurore',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Laila',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Lakki Reddy',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lancelot',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lateef',
				'subsets'  => array( 'arabic', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lato',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'League Script',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Leckerli One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ledger',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lekton',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Lemon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Libre Baskerville',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Life Savers',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Lilita One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lily Script One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Limelight',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Linden Hill',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Lobster',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lobster Two',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Londrina Outline',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Londrina Shadow',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Londrina Sketch',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Londrina Solid',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lora',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Love Ya Like A Sister',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Loved by the King',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lovers Quarrel',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Luckiest Guy',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Lusitana',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Lustria',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Macondo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Macondo Swash Caps',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Magra',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Maiden Orange',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mako',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mallanna',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mandali',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Marcellus',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Marcellus SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Marck Script',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Margarine',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Marko One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Marmelad',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Martel',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '200', '300', '400', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Martel Sans',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '200', '300', '400', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Marvel',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Mate',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Mate SC',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Maven Pro',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '500', '700', '900' ),
			),
			array(
				'name'     => 'McLaren',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Meddon',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'MedievalSharp',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Medula One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Megrim',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Meie Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Merienda',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Merienda One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Merriweather',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Merriweather Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic', '800', '800italic' ),
			),
			array(
				'name'     => 'Metal',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Metal Mania',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Metamorphous',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Metrophobic',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Michroma',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Milonga',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Miltonian',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Miltonian Tattoo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Miniver',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Miss Fajardose',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Modak',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Modern Antiqua',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Molengo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Molle',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( 'italic' ),
			),
			array(
				'name'     => 'Monda',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Monofett',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Monoton',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Monsieur La Doulaise',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Montaga',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Montez',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Montserrat',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Montserrat Alternates',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Montserrat Subrayada',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Moul',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Moulpali',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mountains of Christmas',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Mouse Memoirs',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mr Bedfort',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mr Dafoe',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mr De Haviland',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mrs Saint Delafield',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Mrs Sheppards',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Muli',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '300italic', '400', 'italic' ),
			),
			array(
				'name'     => 'Mystery Quest',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'NTR',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Neucha',
				'subsets'  => array( 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Neuton',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '200', '300', '400', 'italic', '700', '800' ),
			),
			array(
				'name'     => 'New Rocker',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'News Cycle',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Niconne',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nixie One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nobile',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Nokora',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Norican',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nosifer',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nothing You Could Do',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Noticia Text',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Noto Sans',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic', 'devanagari' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Noto Serif',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Nova Cut',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Flat',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Mono',
				'subsets'  => array( 'greek', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Oval',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Round',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Script',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Slim',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nova Square',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Numans',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Nunito',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Odor Mean Chey',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Offside',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Old Standard TT',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Oldenburg',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Oleo Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Oleo Script Swash Caps',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Open Sans',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '800', '800italic' ),
			),
			array(
				'name'     => 'Open Sans Condensed',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '300', '300italic', '700' ),
			),
			array(
				'name'     => 'Oranienbaum',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Orbitron',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '500', '700', '900' ),
			),
			array(
				'name'     => 'Oregano',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Orienta',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Original Surfer',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Oswald',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Over the Rainbow',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Overlock',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Overlock SC',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ovo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Oxygen',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Oxygen Mono',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'PT Mono',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'PT Sans',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'PT Sans Caption',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'PT Sans Narrow',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'PT Serif',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'PT Serif Caption',
				'subsets'  => array( 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Pacifico',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Palanquin',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '100', '200', '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Palanquin Dark',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Paprika',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Parisienne',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Passero One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Passion One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700', '900' ),
			),
			array(
				'name'     => 'Pathway Gothic One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Patrick Hand',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Patrick Hand SC',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Patua One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Paytone One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Peddana',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Peralta',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Permanent Marker',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Petit Formal Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Petrona',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Philosopher',
				'subsets'  => array( 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Piedra',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Pinyon Script',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Pirata One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Plaster',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Play',
				'subsets'  => array( 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Playball',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Playfair Display',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Playfair Display SC',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Podkova',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Poiret One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Poller One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Poly',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Pompiere',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Pontano Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Poppins',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Port Lligat Sans',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Port Lligat Slab',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Pragati Narrow',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Prata',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Preahvihear',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Press Start 2P',
				'subsets'  => array( 'greek', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Princess Sofia',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Prociono',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Prosto One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Puritan',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Purple Purse',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Quando',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Quantico',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Quattrocento',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Quattrocento Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Questrial',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Quicksand',
				'subsets'  => array( 'latin' ),
				'variants' => array( '300', '400', '700' ),
			),
			array(
				'name'     => 'Quintessential',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Qwigley',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Racing Sans One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Radley',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Rajdhani',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Raleway',
				'subsets'  => array( 'latin' ),
				'variants' => array( '100', '200', '300', '400', '500', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Raleway Dots',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ramabhadra',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ramaraja',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rambla',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Rammetto One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ranchers',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rancho',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ranga',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Rationale',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ravi Prakash',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Redressed',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Reenie Beanie',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Revalia',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rhodium Libre',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ribeye',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ribeye Marrow',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Righteous',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Risque',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Roboto',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Roboto Condensed',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '300', '300italic', '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Roboto Mono',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Roboto Slab',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'vietnamese', 'cyrillic' ),
				'variants' => array( '100', '300', '400', '700' ),
			),
			array(
				'name'     => 'Rochester',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rock Salt',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rokkitt',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Romanesco',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ropa Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Rosario',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Rosarivo',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Rouge Script',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rozha One',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rubik',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Rubik Mono One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rubik One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ruda',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700', '900' ),
			),
			array(
				'name'     => 'Rufina',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Ruge Boogie',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ruluko',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rum Raisin',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ruslan Display',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Russo One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ruthie',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Rye',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sacramento',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sahitya',
				'subsets'  => array( 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Sail',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Salsa',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sanchez',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Sancreek',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sansita One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sarala',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Sarina',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sarpanch',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '500', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Satisfy',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Scada',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Scheherazade',
				'subsets'  => array( 'arabic', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Schoolbell',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Seaweed Script',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sevillana',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Seymour One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Shadows Into Light',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Shadows Into Light Two',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Shanti',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Share',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Share Tech',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Share Tech Mono',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Shojumaru',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Short Stack',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Siemreap',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sigmar One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Signika',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '600', '700' ),
			),
			array(
				'name'     => 'Signika Negative',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400', '600', '700' ),
			),
			array(
				'name'     => 'Simonetta',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Sintony',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Sirin Stencil',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Six Caps',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Skranji',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Slabo 13px',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Slabo 27px',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Slackey',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Smokum',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Smythe',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sniglet',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '800' ),
			),
			array(
				'name'     => 'Snippet',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Snowburst One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sofadi One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sofia',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sonsie One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sorts Mill Goudy',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', 'italic' ),
			),
			array(
				'name'     => 'Source Code Pro',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '200', '300', '400', '500', '600', '700', '900' ),
			),
			array(
				'name'     => 'Source Sans Pro',
				'subsets'  => array( 'latin-ext', 'latin', 'vietnamese' ),
				'variants' => array( '200', '200italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '900', '900italic' ),
			),
			array(
				'name'     => 'Source Serif Pro',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400', '600', '700' ),
			),
			array(
				'name'     => 'Special Elite',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Spicy Rice',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Spinnaker',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Spirax',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Squada One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sree Krushnadevaraya',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Stalemate',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Stalinist One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Stardos Stencil',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Stint Ultra Condensed',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Stint Ultra Expanded',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Stoke',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '300', '400' ),
			),
			array(
				'name'     => 'Strait',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sue Ellen Francisco',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sumana',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Sunshiney',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Supermercado One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Sura',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Suranna',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Suravaram',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Suwannaphum',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Swanky and Moo Moo',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Syncopate',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Tangerine',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Taprom',
				'subsets'  => array( 'khmer' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tauri',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Teko',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '300', '400', '500', '600', '700' ),
			),
			array(
				'name'     => 'Telex',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tenali Ramakrishna',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tenor Sans',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Text Me One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'The Girl Next Door',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tienne',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700', '900' ),
			),
			array(
				'name'     => 'Tillana',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '500', '600', '700', '800' ),
			),
			array(
				'name'     => 'Timmana',
				'subsets'  => array( 'latin', 'telugu' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tinos',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'hebrew', 'vietnamese', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Titan One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Titillium Web',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '200', '200italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '900' ),
			),
			array(
				'name'     => 'Trade Winds',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Trocchi',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Trochut',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700' ),
			),
			array(
				'name'     => 'Trykker',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Tulpen One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ubuntu',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Ubuntu Condensed',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Ubuntu Mono',
				'subsets'  => array( 'greek-ext', 'greek', 'cyrillic-ext', 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Ultra',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Uncial Antiqua',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Underdog',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Unica One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'UnifrakturCook',
				'subsets'  => array( 'latin' ),
				'variants' => array( '700' ),
			),
			array(
				'name'     => 'UnifrakturMaguntia',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Unkempt',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', '700' ),
			),
			array(
				'name'     => 'Unlock',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Unna',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'VT323',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Vampiro One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Varela',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Varela Round',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Vast Shadow',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Vesper Libre',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '400', '500', '700', '900' ),
			),
			array(
				'name'     => 'Vibur',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Vidaloka',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Viga',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Voces',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Volkhov',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Vollkorn',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400', 'italic', '700', '700italic' ),
			),
			array(
				'name'     => 'Voltaire',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Waiting for the Sunrise',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Wallpoet',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Walter Turncoat',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Warnes',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Wellfleet',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Wendy One',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Wire One',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Work Sans',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '100', '200', '300', '400', '500', '600', '700', '800', '900' ),
			),
			array(
				'name'     => 'Yanone Kaffeesatz',
				'subsets'  => array( 'latin-ext', 'latin' ),
				'variants' => array( '200', '300', '400', '700' ),
			),
			array(
				'name'     => 'Yantramanav',
				'subsets'  => array( 'latin-ext', 'latin', 'devanagari' ),
				'variants' => array( '100', '300', '400', '500', '700', '900' ),
			),
			array(
				'name'     => 'Yellowtail',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Yeseva One',
				'subsets'  => array( 'latin-ext', 'latin', 'cyrillic' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Yesteryear',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
			array(
				'name'     => 'Zeyada',
				'subsets'  => array( 'latin' ),
				'variants' => array( '400' ),
			),
		);
	}
}
