<?php
/**
 * Iconic_Flux_Compat_Divi.
 *
 * Compatibility with Divi.
 *
 * @package Iconic_Flux
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( class_exists( 'Iconic_Flux_Compat_Divi' ) ) {
	return;
}

/**
 * Iconic_Flux_Compat_Divi.
 *
 * @class    Iconic_Flux_Compat_Divi.
 * @version  2.0.0.0
 * @package  Iconic_Flux
 */
class Iconic_Flux_Compat_Divi {
	/**
	 * Run.
	 */
	public static function run() {
		add_action( 'template_redirect', array( __CLASS__, 'compat_divi' ) );
	}

	/**
	 * Disable Divi checkout customisations.
	 */
	public static function compat_divi() {
		if ( ! function_exists( 'et_divi_print_stylesheet' ) || ! Iconic_Flux_Core::is_checkout() ) {
			return;
		}

		remove_action( 'wp_enqueue_scripts', 'et_divi_print_stylesheet', 99999998 );
		remove_action( 'wp_enqueue_scripts', 'et_requeue_child_theme_styles', 99999999 );
		remove_action( 'wp_enqueue_scripts', 'et_divi_enqueue_stylesheet' );
	}
}
