<?php
/**
 * Migrate EDD licenses to Freemius.
 *
 * @package Iconic_Flux
 */

/**
 * Migrate EDD license to FS.
 */
function flux_license_key_migration() {
	if ( ! flux_fs()->has_api_connectivity() || flux_fs()->is_registered() ) {
		// No connectivity OR the user already opted-in to Freemius.
		return;
	}

	if ( 'pending' != get_option( 'flux_migrated2fs', 'pending' ) ) {
		return;
	}

	// Get the license key from the previous eCommerce platform's storage.
	$license_key = get_option( 'flux_license', '' );

	if ( empty( $license_key ) ) {
		// No key to migrate.
		return;
	}

	// Get the first 32 characters.
	$license_key = substr( $license_key, 0, 32 );

	try {
		$next_page = flux_fs()->activate_migrated_license( $license_key );
	} catch ( Exception $e ) {
		update_option( 'flux_migrated2fs', 'unexpected_error' );

		return;
	}

	if ( flux_fs()->can_use_premium_code() ) {
		update_option( 'flux_migrated2fs', 'done' );

		if ( is_string( $next_page ) ) {
			fs_redirect( $next_page );
		}
	} else {
		update_option( 'flux_migrated2fs', 'failed' );
	}
}

add_action( 'admin_init', 'flux_license_key_migration' );
