<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * WooCS compatibility.
 */
class Iconic_WAS_Compat_WooCS {

	/**
	 * Run.
	 */
	public static function run() {
		add_action( 'plugins_loaded', array( __CLASS__, 'hooks' ) );
	}

	/**
	 * Hooks.
	 */
	public static function hooks() {
		// PHPCS:disable WordPress.NamingConventions.ValidVariableName.VariableNotSnakeCase
		global $WOOCS;

		if ( empty( $WOOCS ) || is_admin() ) {
			return;
		}

		add_filter( 'iconic_was_fees', array( __CLASS__, 'currency_convert_fees' ), 10, 2 );
		add_filter( 'woocommerce_before_calculate_totals', array( __CLASS__, 'remove_currency_convert_fees' ) );
		add_filter( 'woocommerce_after_calculate_totals', array( __CLASS__, 'add_currency_convert_fees' ) );
	}

	/**
	 * Convert fees.
	 *
	 * @param array      $fees    Fees.
	 * @param WC_Product $product Product.
	 *
	 * @return array $fees Updated fees.
	 */
	public static function currency_convert_fees( $fees, $product ) {
		global $WOOCS;

		foreach ( $fees as $attribute_key => &$attribute_fees ) {
			foreach ( $attribute_fees as $term => $term_fee ) {
				$attribute_fees[ $term ] = floatval( $WOOCS->woocs_exchange_value( $term_fee ) );
			}
		}

		return $fees;
	}

	/**
	 * Don't convert fees when calculating cart totals.
	 * WOOCS does this automatically.
	 */
	public static function remove_currency_convert_fees() {
		remove_filter( 'iconic_was_fees', array( __CLASS__, 'currency_convert_fees' ), 10 );
	}

	/**
	 * Add the fee conversion back in after calculating totals.
	 */
	public static function add_currency_convert_fees() {
		add_filter( 'iconic_was_fees', array( __CLASS__, 'currency_convert_fees' ), 10, 2 );
	}
}
