/**
 * jQuery.Conditional
 * @version   0.1
 * @author    biohzrdmx <github.com/biohzrdmx>
 * @requires  jQuery 1.8+
 * @license   MIT
 * @copyright Copyright © 2015 biohzrdmx. All rights reserved.
 */
;(function( $ ) {
	var isMatch = function( match, value ) {
		return match === value || $.inArray( value, match ) >= 0;
	};

	$.fn.iconicConditional = function( options ) {
		if ( ! this.length ) {
			return this;
		}
		var opts = $.extend( true, {}, $.iconicConditional.defaults, options );
		this.each( function() {
			var el = $( this ),
				conditional = el.data( 'conditional' );

			el.on( opts.eventName, function() {
				var value = el.val(),
					elements = $( "[data-condition*='\"" + conditional + "\"'], [data-condition='" + conditional + "']" );
				// Hide all
				opts.onDeactivate( elements, opts, function() {
					// Show the one(s) that match
					elements.each( function() {
						var element = $( this ),
							match = element.data( 'match' ),
							condition = element.data( 'condition' );

						if ( ! $.isArray( condition ) ) {
							if ( isMatch( match, value ) ) {
								opts.onActivate( element, opts );
							}
							return;
						}

						var valueMatched = true;

						$.each( condition, function( index, conditional ) {
							var value = $( '[data-conditional="' + conditional + '"]' ).val();

							if ( ! isMatch( match[ index ], value ) ) {
								valueMatched = false;
								return false;
							}
						} );

						if ( valueMatched ) {
							opts.onActivate( element, opts );
						}
					} );

				} );
			} );
			el.trigger( opts.eventName );
		} );
		return this;
	};
	$.iconicConditional = {
		defaults: {
			className: 'iconic-was-u-hide',
			eventName: 'change',
			onActivate: function( element, opts ) {
				element.removeClass( opts.className );
			},
			onDeactivate: function( elements, opts, callback ) {
				elements.addClass( opts.className );
				callback.call();
			},
			autoBind: true
		}
	};
	// Auto-binding via HTML5 datas
	if ( $.iconicConditional.defaults.autoBind ) {
		$( '[data-conditional]' ).iconicConditional();
	}
})( jQuery );