<?php
/**
 * Compatiblity with WeGlot.
 *
 * @package Iconic_WLV
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * WeGlot compatibility.
 *
 * @class          Iconic_WLV_Compat_Weglot
 * @version        1.0.0
 */
class Iconic_WLV_Compat_Weglot {
	/**
	 * Run.
	 */
	public static function run() {
		add_action( 'init', array( __CLASS__, 'hooks' ) );
	}

	/**
	 * Hooks.
	 *
	 * @return void
	 */
	public static function hooks() {
		if ( ! function_exists( 'weglot_plugin_loaded' ) ) {
			return;
		}

		add_filter( 'iconic_wlv_variation_permalink', array( __CLASS__, 'permalink' ), 10, 2 );
	}

	/**
	 * Translate the variation URL.
	 *
	 * @param string $permalink    Variation Permalink.
	 * @param string $variation_id Variation ID.
	 *
	 * @return string
	 */
	public static function permalink( $permalink, $variation_id ) {
		return weglot_create_url_object( $permalink )->getForLanguage( weglot_get_request_url_service()->get_current_language() );
	}
}
