<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Class Iconic_WLV_Linked_Variations_Group
 */
class Iconic_WLV_Linked_Variations_Group {
	/**
	 * Post object.
	 *
	 * @var null|WP_Post
	 */
	public $post = null;

	/**
	 * Meta object.
	 *
	 * @var null|bool|object
	 */
	public $meta = null;

	/**
	 * Terms to select product by.
	 *
	 * @var array
	 */
	public $select_by_terms = null;

	/**
	 * Attributes.
	 *
	 * @var array
	 */
	public $attributes = array(
		'array'  => array(),
		'string' => '',
	);

	/**
	 * Product IDs.
	 *
	 * @var array
	 */
	public $product_ids = array(
		'array'  => array(),
		'string' => '',
	);

	/**
	 * Iconic_WLV_Linked_Variations_Group constructor.
	 *
	 * @param WP_Post|int $post Post object or post ID.
	 */
	public function __construct( $post ) {
		$this->post = is_int( $post ) ? get_post( $post ) : $post;
		$this->meta = Iconic_WLV_Database::get_linked_variations_meta( $this->post->ID );

		if ( ! empty( $this->meta ) ) {
			$this->select_by_terms = Iconic_WLV_Database::get_select_by_terms( $this->meta->id );
		}
	}

	/**
	 * Get product IDs.
	 *
	 * @param bool   $array   Return in array or comma seperated.
	 * @param string $context Context, it could be front or admin.
	 *
	 * @return array|string|bool
	 */
	public function get_product_ids( $array = true, $context = 'front' ) {
		$type = $array ? 'array' : 'string';

		if ( ! empty( $this->product_ids[ $type ] ) || ! $this->meta ) {
			return $this->product_ids[ $type ];
		}

		if ( 'front' === $context && ! empty( $this->select_by_terms ) && 'specific_products' !== $this->meta->link_by ) {
			$products_ids = array();
			foreach ( $this->select_by_terms as $term_id ) {
				$products_ids = array_merge( $products_ids, Iconic_WLV_Helpers::get_all_products_for_term( $term_id, $this->meta->link_by ) );
			}

			$this->product_ids['array']  = $products_ids;
			$this->product_ids['string'] = implode( ',', $products_ids );
		} else {
			$products_ids = (array) maybe_unserialize( $this->meta->product_ids );

			$this->product_ids['array']  = $products_ids;
			$this->product_ids['string'] = implode( ',', $products_ids );
		}

		return $this->product_ids[ $type ];
	}

	/**
	 * Get attributes.
	 *
	 * @param bool $array
	 *
	 * @return array|string
	 */
	public function get_attributes( $array = true ) {
		$type = $array ? 'array' : 'string';

		if ( ! empty( $this->attributes[ $type ] ) || ! $this->meta ) {
			return $this->attributes[ $type ];
		}

		$unserialized_attributes = (array) maybe_unserialize( $this->meta->attributes );

		$this->attributes['array']  = $unserialized_attributes;
		$this->attributes['string'] = implode( ',', $unserialized_attributes );

		return $this->attributes[ $type ];
	}

	/**
	 * Is show image checked?
	 *
	 * @return bool
	 */
	public function is_show_image() {
		if ( ! $this->meta ) {
			return false;
		}

		return (bool) $this->meta->show_image;
	}

	/**
	 * Is show image checked?
	 *
	 * @return bool
	 */
	public function get_style() {
		if ( ! $this->meta ) {
			return false;
		}

		return $this->meta->style ? $this->meta->style : 'buttons';
	}

	/**
	 * Get link_by.
	 *
	 * @return string
	 */
	public function get_link_by() {
		if ( ! $this->meta ) {
			return false;
		}

		return ! empty( $this->meta->link_by ) ? $this->meta->link_by : 'specific_products';
	}

	/**
	 * Get terms.
	 *
	 * @return array
	 */
	public function get_select_by_terms() {
		if ( ! $this->select_by_terms ) {
			return array();
		}

		return $this->select_by_terms;
	}

}
