<?php
if ( ! defined( 'WPINC' ) ) {
	wp_die();
}

/**
 * Class Iconic_WLV_Helpers
 */
class Iconic_WLV_Helpers {
	/**
	 * Get attribute taxonomies.
	 *
	 * @param null|array $sort
	 *
	 * @return array
	 */
	public static function get_attribute_taxonomies( $sort = null ) {
		$attribute_taxonomies = wc_get_attribute_taxonomies();

		if ( is_null( $sort ) || empty( $attribute_taxonomies ) ) {
			return $attribute_taxonomies;
		}

		$return = array();

		foreach ( $attribute_taxonomies as $attribute_taxonomy ) {
			$key = sprintf( 'pa_%s', $attribute_taxonomy->attribute_name );
			$return[ $key ] = $attribute_taxonomy->attribute_label;
		}

		$return = array_merge( array_flip( $sort ), $return );

		return $return;
	}

	/**
	 * Clean and unique array.
	 *
	 * @param array $array
	 *
	 * @return array
	 */
	public static function get_clean_and_unique_array( $array ) {
		return array_unique( array_filter( $array ) );
	}

	/**
	 * Get all products IDs for give term.
	 *
	 * @param int    $term_id       Term ID.
	 * @param string $taxonomy_slug Taxonomy slug.
	 *
	 * @return array
	 */
	public static function get_all_products_for_term( $term_ids, $taxonomy_slug ) {
		global $iconic_wlv;

		$args = array(
			'post_type'      => 'product',
			'posts_per_page' => -1,
			'fields'         => 'ids',
			'post_status'    => $iconic_wlv->get_allowed_post_status(),
			'no_found_rows'  => true,
			'tax_query'      => array(
				array(
					'taxonomy' => $taxonomy_slug,
					'field'    => 'term_id',
					'terms'    => $term_ids,
				),
			),
		);

		return get_posts( $args );
	}

	/**
	 * Allowed tags for kses.
	 *
	 * @return array
	 */
	public static function get_kses_allowed_tags() {
		/**
		 * Allowed tags for kses.
		 *
		 * @since 1.7.0
		 */
		return apply_filters(
			'iconic_wlv_kses_allowed_tags',
			array(
				'a'      => array(
					'href'  => array(),
					'class' => array(),
				),
				'br'     => array(),
				'em'     => array(),
				'strong' => array(),
			)
		);
	}
}
