<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * API Interface class.
 */
class Iconic_WLV_Api {
	/**
	 * Init
	 */
	public static function run() {
		add_action( 'rest_api_init', array( __CLASS__, 'register_custom_fields' ) );
	}

	/**
	 * Prepare shop order API response.
	 *
	 * @param WP_REST_Response $response The response object.
	 * @param WC_Data          $object   Object data.
	 * @param WP_REST_Request  $request  Request object.
	 *
	 * @return WP_REST_Response
	 */
	public static function prepare_cpt_iconic_wlv( $response, $object, $request ) {
		if ( empty( $response->data ) ) {
			return $response;
		}
	}

	/**
	 * Register REST API field.
	 *
	 * @return void
	 */
	public static function register_custom_fields() {
		register_rest_field(
			'cpt_iconic_wlv',
			'linked_variation_data',
			array(
				'get_callback'    => function ( $object ) {
					if ( empty( $object['id'] ) ) {
						return;
					}
					$group = new Iconic_WLV_Linked_Variations_Group( $object['id'] );

					return array(
						'product_ids' => $group->get_product_ids(),
						'attributes'  => $group->get_attributes(),
						'show_images' => $group->is_show_image(),
						'style'       => $group->get_style(),
					);
				},
				'update_callback' => null,
				'schema'          => array(
					'type' => 'array',
				),
			)
		);
	}
}
