<?php

namespace PixelYourSite;

class PinterestEventHandler
{
    private $pageVisitEvent = false;

    public function handleInitEvent(&$event, $pageVisitEvent, $getPageViewEventParams) {
        if (!$pageVisitEvent) {
            $eventData = $getPageViewEventParams(true);
            if ($eventData) {
                $ajaxFire = method_exists(Consent(), 'checkConsent') ? !Consent()->checkConsent('pinterest') : false;
                $event->addPayload(["ajaxFire" => $ajaxFire]);
                $this->addDataToEvent($eventData, $event);
                return true;
            }
        }
        return false;
    }

    public function handleAutomaticEvent(&$event, $getOption) {
        $eventName = str_replace('automatic_event_', '', $event->getId());
        if($eventName === 'search' && !empty( $_GET['s'] )){
            $event->addParams(["search_string" => $_GET['s']]);
        }
        $event->addPayload(["name" => $eventName]);
        return $getOption($event->getId() . '_enabled');
    }


    public function handleSimpleAutomaticEvent(&$event, $getOption) {
        if($event->getId() === 'automatic_event_video') {
            $event->addPayload(["name" => 'watchvideo']);
        }
        return $getOption($event->getId() . '_enabled');
    }

    public function handleWooViewContentEvent(&$event, $getWooPageVisitEventParams) {
        $eventData = $getWooPageVisitEventParams();
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            $this->pageVisitEvent = true;
            return true;
        }
        return false;
    }

    public function handleWooAddToCartOnCartPageEvent(&$event, $getWooAddToCartOnCartEventParams, $setWooAddToCartOnCartEventParams) {
        if ($event->args == null) {
            $eventData = $getWooAddToCartOnCartEventParams();
            if ($eventData) {
                $this->addDataToEvent($eventData, $event);
                return true;
            }
        } else {
            return $setWooAddToCartOnCartEventParams($event);
        }
        return false;
    }

    public function handleWooRemoveFromCartEvent(&$event, $getWooRemoveFromCartParams, $setWooRemoveFromCartParams) {
        if (is_a($event, GroupedEvent::class)) {
            $isActive = false;
            foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
                $eventData = $getWooRemoveFromCartParams($cart_item);
                if ($eventData) {
                    $child = new SingleEvent($cart_item_key, EventTypes::$DYNAMIC);
                    $isActive = true;
                    $this->addDataToEvent($eventData, $child);
                    $event->addEvent($child);
                }
            }
            return $isActive;
        } else {
            return $setWooRemoveFromCartParams($event);
        }
    }

    public function handleWooViewCategoryEvent(&$event, $getWooViewCategoryEventParams) {
        $eventData = $getWooViewCategoryEventParams($event);
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            return true;
        }
        return false;
    }

    public function handleWooInitiateCheckoutEvent(&$event, $getWooInitiateCheckoutEventParams, $setWooInitiateCheckoutEventParams) {
        if ($event->args == null) {
            $eventData = $getWooInitiateCheckoutEventParams();
            if ($eventData) {
                $this->addDataToEvent($eventData, $event);
                return true;
            }
        } else {
            return $setWooInitiateCheckoutEventParams($event);
        }
        return false;
    }

    public function handleWooPurchaseEvent(&$event, $getWooCheckoutEventParams, $addWooCheckoutEventParams) {
        if (empty($event->args['order_id'])) {
            return $getWooCheckoutEventParams($event);
        } else {
            return $addWooCheckoutEventParams($event);
        }
    }

    public function handleWooPayPalEvent(&$event, $setWooPayPalEventParams) {
        return $setWooPayPalEventParams($event);
    }

    public function handleWooAdvancedMarketingEvent(&$event, $getWooAdvancedMarketingEventParams) {
        $eventData = $getWooAdvancedMarketingEventParams($event->getId());
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            return true;
        }
        return false;
    }

    public function handleEddViewContentEvent(&$event, $getEddPageVisitEventParams) {
        $eventData = $getEddPageVisitEventParams();
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            $this->pageVisitEvent = true;
            return true;
        }
        return false;
    }

    public function handleEddAddToCartOnCheckoutPageEvent(&$event, $setEddCartEventParams) {
        return $setEddCartEventParams($event);
    }

    public function handleEddRemoveFromCartEvent(&$event, $getEddRemoveFromCartParams, $setEddRemoveFromCartParams) {
        if (is_a($event, GroupedEvent::class)) {
            $isActive = false;
            foreach (edd_get_cart_contents() as $cart_item_key => $cart_item) {
                $eventData = $getEddRemoveFromCartParams($cart_item);
                if ($eventData) {
                    $child = new SingleEvent($cart_item_key, EventTypes::$DYNAMIC);
                    $isActive = true;
                    $this->addDataToEvent($eventData, $child);
                    $event->addEvent($child);
                }
            }
            return $isActive;
        } else {
            return $setEddRemoveFromCartParams($event);
        }
    }

    public function handleEddViewCategoryEvent(&$event, $getEddViewCategoryEventParams) {
        $eventData = $getEddViewCategoryEventParams($event);
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            return true;
        }
        return false;
    }

    public function handleEddInitiateCheckoutEvent(&$event, $setEddCartEventParams) {
        return $setEddCartEventParams($event);
    }

    public function handleEddPurchaseEvent(&$event, $setEddCartEventParams) {
        return $setEddCartEventParams($event);
    }

    public function handleEddAdvancedMarketingEvent(&$event, $setEddCartEventParams) {
        return $setEddCartEventParams($event);
    }

    public function handleCustomEvent(&$event, $getCustomEventParams) {
        $eventData = $getCustomEventParams($event);
        if ($eventData) {
            $this->addDataToEvent($eventData, $event);
            return true;
        }
        return false;
    }

    public function handleWooAddToCartOnButtonClickEvent(&$event, $getOption, $getWooAddToCartOnButtonClickEventParams) {
        if ($getOption('woo_add_to_cart_enabled') && PYS()->getOption('woo_add_to_cart_on_button_click')) {
            if (isset($event->args['productId'])) {
                $productId = $event->args['productId'];
                $quantity = $event->args['quantity'];
                $eventData = $getWooAddToCartOnButtonClickEventParams($productId, $quantity);

                if ($eventData) {
                    $event->addParams($eventData["params"]);
                    unset($eventData["params"]);
                    $event->addPayload($eventData);
                }
            }

            $event->addPayload(['name' => "addtocart"]);
            return true;
        }
        return false;
    }

    public function handleWooAffiliateEvent(&$event, $getOption, $getWooAffiliateEventParams) {
        if ($getOption('woo_affiliate_enabled')) {
            if (isset($event->args['productId'])) {
                $productId = $event->args['productId'];
                $quantity = $event->args['quantity'];
                $eventData = $getWooAffiliateEventParams($productId, $quantity);
                if ($eventData) {
                    $event->addParams($eventData["params"]);
                    unset($eventData["params"]);
                    $event->addPayload($eventData);
                }
            }
            return true;
        }
        return false;
    }

    public function handleEddAddToCartOnButtonClickEvent(&$event, $getOption, $getEddAddToCartOnButtonClickEventParams) {
        if ($getOption('edd_add_to_cart_enabled') && PYS()->getOption('edd_add_to_cart_on_button_click')) {
            if ($event->args != null) {
                $event->addParams($getEddAddToCartOnButtonClickEventParams($event->args));
            }
            $event->addPayload(['name' => "addtocart"]);
            return true;
        }
        return false;
    }

    public function handleWcfViewContentEvent(&$event, $getWcfViewContentEventParams) {
        $isActive = $getWcfViewContentEventParams($event);
        $this->pageVisitEvent = true;
        return $isActive;
    }

    public function handleWcfAddToCartEvent(&$event, $prepareWcfAddToCart) {
        return $prepareWcfAddToCart($event);
    }

    public function handleWcfRemoveFromCartEvent(&$event, $prepareWcfRemoveFromCart) {
        return $prepareWcfRemoveFromCart($event);
    }


    public function handleSimpleWcfEvent(&$event, $getOption) {
        $eventMappings = [
            'wcf_step_page' => 'wcf_step_event_enabled',
            'wcf_bump' => 'wcf_bump_event_enabled',
            'wcf_page' => 'wcf_cart_flows_event_enabled',
        ];

        $optionKey = $eventMappings[$event->getId()] ?? ($event->getId() . '_enabled');
        return $getOption($optionKey);
    }

    private function addDataToEvent($eventData, &$event) {
        $params = $eventData["data"];
        unset($eventData["data"]);
        $event->addParams($params);
        $event->addPayload($eventData);
    }

    public function getPageVisitEvent() {
        return $this->pageVisitEvent;
    }

    public function setPageVisitEvent($value) {
        $this->pageVisitEvent = $value;
    }
}
// End of PinterestEventHandler.php
