<?php

namespace PixelYourSite;

class PinterestMainHelper
{
    
    private $pinterest;
    
    public function __construct($pinterest = null) {
        $this->pinterest = $pinterest;
    }

    public function shouldProcessWooCommercePageView($cpt) {
        return ($cpt === "product" || $cpt === "product_variation") &&
            isWooCommerceActive() &&
            !is_shop() &&
            !is_checkout() &&
            !is_cart() &&
            !PYS()->woo_is_order_received_page(is_order_received_page()) &&
            !is_tax( 'product_cat' ) &&
            $this->pinterest->getOption( "page_view_woo_products_pages" );
    }

    public function shouldProcessEddPageView($cpt)
    {
        return isEddActive() &&
        $cpt == "download" &&
        !edd_is_checkout() &&
        !edd_is_success_page() &&
        !is_tax( 'download_category' ) &&
        $this->pinterest->getOption( "page_view_edd_products_pages" );
    }

    public function shouldProcessPageView($cpt) {
        return
	         ( !isWooCommerceActive() ||
	           ( $cpt != "product" &&
	             !is_checkout() &&
	             !is_cart() &&
	             !PYS()->woo_is_order_received_page(is_order_received_page()) &&
	             !is_tax( 'product_cat' ) ) ) &&
	         ( !isEddActive() ||
	           ( $cpt != "download" &&
	             !edd_is_checkout() &&
	             !edd_is_success_page() &&
	             !is_tax( 'download_category' ) ) );
    }

    public function shouldProcessCustomPostType($cpt) {
        if (($cpt === "post" || $cpt === "page") && !$this->pinterest->getOption("page_view_post_enabled")) {
            return false;
        }

        if ($cpt !== "post" && $cpt !== "page") {
            $enabledCustom = (array) $this->pinterest->getOption("page_view_custom_post_enabled");
            if (!in_array("index_" . $cpt, $enabledCustom)) {
                return false;
            }
        }

        return true;
    }

    public function applyFeeEddToTotals( $event, &$total, &$totalAsIs, &$tax ) {
        $fee    = isset( $event->args['fee'] ) ? $event->args['fee'] : 0;
        $feeTax = isset( $event->args['fee_tax'] ) ? $event->args['fee_tax'] : 0;

        $tax += $feeTax;

        $isCustom = PYS()->getOption( 'edd_event_value' ) === 'custom';
        $taxIncluded = PYS()->getOption( 'edd_tax_option' ) === 'included';
        $eddPricesIncludeTax = edd_prices_include_tax();

        if ( $isCustom ) {
            $total += $taxIncluded ? $fee + $feeTax : $fee;
        } else {
            $totalAsIs += $eddPricesIncludeTax ? $fee + $feeTax : $fee;
        }
    }

    public function getEddCartEventData($eventId) {
        $data = [];
        $value_enabled = false;
        $value_option = '';
        $percents_value = 100;
        $global_value = 0;
        $shouldRun = true;

        switch ($eventId) {
            case 'edd_frequent_shopper':
                if (!$this->pinterest->getOption($eventId . '_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'FrequentShopper';
                break;

            case 'edd_vip_client':
                if (!$this->pinterest->getOption($eventId . '_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'VipClient';
                break;

            case 'edd_big_whale':
                if (!$this->pinterest->getOption($eventId . '_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'BigWhale';
                break;

            case 'edd_add_to_cart_on_checkout_page':
                if (!$this->pinterest->getOption('edd_add_to_cart_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'AddToCart';
                $value_enabled = PYS()->getOption('edd_add_to_cart_value_enabled');
                $value_option = PYS()->getOption('edd_add_to_cart_value_option');
                $percents_value = PYS()->getOption('edd_add_to_cart_value_percent', 100);
                $global_value = PYS()->getOption('edd_add_to_cart_value_global', 0);
                break;

            case 'edd_initiate_checkout':
                if (!$this->pinterest->getOption('edd_initiate_checkout_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'InitiateCheckout';
                $value_enabled = PYS()->getOption('edd_initiate_checkout_value_enabled');
                $value_option = PYS()->getOption('edd_initiate_checkout_value_option');
                $percents_value = PYS()->getOption('edd_initiate_checkout_value_percent', 100);
                $global_value = PYS()->getOption('edd_initiate_checkout_global', 0);
                break;

            case 'edd_purchase':
                if (!$this->pinterest->getOption('edd_checkout_enabled')) {
                    $shouldRun = false;
                }
                $data['name'] = 'Checkout';
                $value_enabled = PYS()->getOption('edd_purchase_value_enabled');
                $value_option = PYS()->getOption('edd_purchase_value_option');
                $percents_value = PYS()->getOption('edd_purchase_value_percent', 100);
                $global_value = PYS()->getOption('edd_purchase_value_global', 0);
                break;

            default:
                $shouldRun = false;
        }

        return $shouldRun ? [
            'data' => $data,
            'value_enabled' => $value_enabled,
            'value_option' => $value_option,
            'percents_value' => $percents_value,
            'global_value' => $global_value,
        ] : false;
    }

    public function processSetEddCartEventProducts($event, &$total, &$totalAsIs, &$tax, &$licenses)
    {
        $line_items = [];
        $num_items = 0;

        foreach ($event->args['products'] as $product) {
            $download_id = (int) $product['product_id'];
            $price_index = $product['price_index'];

            $line_items[] = [
                'product_id'       => Pinterest\getEddDownloadContentId($download_id),
                'product_quantity' => $product['quantity'],
                'product_price'    => getEddDownloadPriceToDisplay($download_id, $price_index),
                'product_name'     => $product['name'],
                'product_category' => implode(', ', array_column($product['categories'], 'name')),
                'tags'             => implode(', ', $product['tags']),
            ];

            $num_items += $product['quantity'];

            $this->calculateEddTotals($event->getId(), $product, $download_id, $price_index, $product['cart_item_key'], $total, $totalAsIs, $tax);

            // get download license data
            array_walk( $licenses, function ( &$value, $key, $license ) {
                if ( !isset( $license[ $key ] ) ) {
                    return;
                }
                if ( $value ) {
                    $value = $value . ', ' . $license[ $key ];
                } else {
                    $value = $license[ $key ];
                }
            }, getEddDownloadLicenseData( $download_id ) );
        }

        return [
            'line_items' => $line_items,
            'num_items' => $num_items,
        ];
    }

    public function processGetEddCartEventProducts($cart,&$total, &$total_as_is, &$licenses, $context, $value_enabled)
    {
        $line_items = [];
        $num_items = 0;

        foreach ( $cart as $cart_item_key => $cart_item ) {

            $download_id = (int) $cart_item[ 'id' ];

            $price_index = !empty( $cart_item[ 'options' ] ) && !empty( $cart_item[ 'options' ][ 'price_id' ] ) ? $cart_item[ 'options' ][ 'price_id' ] : null;

            // content_name, category_name, tags
            $cd_params = Pinterest\getEddCustomAudiencesOptimizationParams( $download_id );
            $tags = getObjectTerms( 'download_tag', $download_id );

            $line_item = array(
                'product_id'       => Pinterest\getEddDownloadContentId( $download_id ),
                'product_quantity' => $cart_item[ 'quantity' ],
                'product_price'    => getEddDownloadPriceToDisplay( $download_id, $price_index ),
                'product_name'     => $cd_params[ 'content_name' ],
                'product_category' => $cd_params[ 'category_name' ],
                'tags'             => implode( ', ', $tags )
            );

            $line_items[] = $line_item;

            $num_items += $cart_item[ 'quantity' ];

            // calculate cart items total
            if ( $value_enabled ) {

                $this->calculateEddTotals($context, $cart_item, $download_id, $price_index, $cart_item_key, $total, $total_as_is);

            }

            // get download license data
            array_walk( $licenses, function ( &$value, $key, $license ) {

                if ( !isset( $license[ $key ] ) ) {
                    return;
                }

                if ( $value ) {
                    $value = $value . ', ' . $license[ $key ];
                } else {
                    $value = $license[ $key ];
                }

            }, getEddDownloadLicenseData( $download_id ) );

        }
        return [
            'line_items' => $line_items,
            'num_items' => $num_items,
        ];
    }

    private function calculateEddTotals($context, $product, $downloadId, $priceIndex, $cartItemKey, &$total, &$totalAsIs, &$tax = null) {

        if ($context === 'Checkout' || $context === 'edd_purchase') {
            if ( PYS()->getOption( 'edd_tax_option' ) === 'included' ) {
                $total += $product[ 'subtotal' ] + $product[ 'tax' ] - $product[ 'discount' ];
            } else {
                $total += $product[ 'subtotal' ] - $product[ 'discount' ];
            }
            $tax += $product[ 'tax' ];
            $totalAsIs += $product[ 'price' ];
        } else {
            $total += getEddDownloadPrice($downloadId, $priceIndex) * $product['quantity'];
            $totalAsIs += edd_get_cart_item_final_price($cartItemKey);
        }
    }


    public function processUserAddress($user)
    {
        $addressData = [];

        if (isset($user['address'])) {
            if (!empty($user['address']['city'])) {
                $addressData['town'] = $user['address']['city'];
            }

            if (!empty($user['address']['state'])) {
                $addressData['state'] = $user['address']['state'];
            }

            if (!empty($user['address']['country'])) {
                $addressData['country'] = $user['address']['country'];
            }
        }

        return $addressData;
    }

    public function processPurchaseParams($event, $total, $total_as_is, $tax)
    {
        $payment_id = (int) $event->args['order_id'];
        $session = edd_get_purchase_session();
        $user = edd_get_payment_meta_user_info($payment_id);
        $params = $this->processUserAddress($user);

        if ( isset($session['gateway']) ) {
            $params['payment'] = $session['gateway'];
        }

        if(isset($event->args['coupon'])){
            $params['promo_code'] = $event->args['coupon'];
            $params['promo_code_used'] = 'yes';
        } else {
            $params['promo_code_used'] = 'no';
        }

        $meta = edd_get_payment_meta($payment_id);
        $params['transaction_year'] = date('Y', strtotime($meta['date']));
        $params['transaction_day'] = date('d', strtotime($meta['date']));

        $params['order_id'] = Pinterest\eddMapOrderId($payment_id);
        $params['currency'] = edd_get_currency();
        $params['value'] = PYS()->getOption('edd_event_value') === 'custom' ? $total : $total_as_is;
        $params['tax'] = edd_use_taxes() ? $tax : 0;

        return $params;
    }

    public function processCheckoutParams( &$params ) {
        $payment_key = getEddPaymentKey();
        $payment_id  = (int) edd_get_purchase_id_by_key( $payment_key );
        $session     = edd_get_purchase_session();
        $user        = edd_get_payment_meta_user_info( $payment_id );

        // Town, state, country
        $params += $this->processUserAddress( $user );

        // Payment method
        if ( isset( $session['gateway'] ) ) {
            $params['payment'] = $session['gateway'];
        }

        // Coupon
        $coupons = isset( $user['discount'] ) && $user['discount'] !== 'none' ? $user['discount'] : null;
        if ( !empty( $coupons ) ) {
            $coupons = explode( ', ', $coupons );
            $params['coupon'] = $coupons[0];
        }

        // Transaction metadata
        $meta = edd_get_payment_meta( $payment_id );
        $params['transaction_year'] = date( 'Y', strtotime( $meta['date'] ) );
        $params['transaction_day']  = date( 'd', strtotime( $meta['date'] ) );

        $params['order_id'] = Pinterest\eddMapOrderId( $payment_id );
        $params['currency'] = edd_get_currency();

        // Value
        $params['value'] = PYS()->getOption( 'edd_event_value' ) === 'custom'
            ? getEddOrderTotal( $payment_id )
            : edd_get_payment_amount( $payment_id );

        // Tax
        $params['tax'] = edd_use_taxes()
            ? edd_get_payment_tax( $payment_id )
            : 0;
    }
}
