<?php

namespace PixelYourSite;

class PinterestNoScriptHelper
{
    private $pixelIDs;

    public function __construct($pixelIDs) {
        $this->pixelIDs = $pixelIDs;
    }

    public function outputNoScriptEvents($eventsManager) {
        foreach ($eventsManager->getStaticEvents('pinterest') as $events) {
            foreach ($events as $event) {
                foreach ($this->pixelIDs as $pixelID) {
                    $this->renderNoScriptEvent($pixelID, $event);
                }
            }
        }
    }

    private function renderNoScriptEvent($pixelID, $event) {
        $args = $this->buildEventArgs($pixelID, $event);
        $src = $this->buildEventSrc($args);

        printf(
            '<noscript><img height="1" width="1" style="display: none;" src="%s" alt="pinterest_pixel"></noscript>',
            $src
        );
        echo "\r\n";
    }

    private function buildEventArgs($pixelID, $event) {
        $args = $this->initializeArgs($pixelID, $event);

        if ($this->isProductEvent($event)) {
            $args = array_merge($args, $this->handleProductEvent($event));
        } else {
            foreach ($event['params'] as $param => $value) {
                if (is_array($value)) {
                    $value = json_encode($value);
                }
                @$args['ed[' . $param . ']'] = urlencode($value);
            }
            $args = array_merge($args, $this->handleGenericEvent($event));
        }

        return $args;
    }

    private function initializeArgs($pixelID, $event) {
        return array(
            'tid'      => $pixelID,
            'event'    => urlencode($event['name']),
            'noscript' => 1,
        );
    }
    private function isProductEvent($event) {
        return isset($event['params']['post_type'], $event['params']['line_items'])
            && $event['params']['post_type'] === "product";
    }
    private function handleProductEvent($event) {
        $args = [];
        $lineItems = $event['params']['line_items'];
        foreach ($lineItems as $index => $product) {
            foreach ($product as $param => $value) {
                @$args['ed[line_items][' . $index . '][' . $param . ']'] = urlencode($value);
            }
        }
        $args = array_merge($args, $this->extractProductParams($event));

        return $args;
    }

    private function extractProductParams($event) {
        $lineItems = $event['params']['line_items'];
        foreach ($lineItems as $index => $product) {
            foreach ($product as $param => $value) {
                @$args['ed[line_items][' . $index . '][' . $param . ']'] = urlencode($value);
            }
        }

        $params = ['num_items', 'subtotal', 'order_quantity', 'total', 'currency'];
        $args = [];

        foreach ($params as $param) {
            if (isset($event['params'][$param])) {
                switch ($param){
                    case 'subtotal':
                    case 'total':
                        $key = 'ed[value]';
                        break;
                    case 'num_items':
                        $key = 'ed[order_quantity]';
                        break;
                    default:
                        $key = 'ed[' . $param . ']';
                        break;
                }
                @$args[$key] = urlencode($event['params'][$param]);
            }
        }

        return $args;
    }

    private function handleGenericEvent($event) {
        $args = [];

        foreach ($event['params'] as $param => $value) {
            if (is_array($value)) {
                $value = json_encode($value);
            }
            @$args['ed[' . $param . ']'] = urlencode($value);
        }

        return $args;
    }
    private function buildEventSrc($args) {
        $src = add_query_arg($args, 'https://ct.pinterest.com/v3/');
        $src = str_replace(['[', ']'], ['%5B', '%5D'], $src);

        return $src;
    }
}
