<?php

namespace PixelYourSite\Pinterest;

use PixelYourSite;
use function PixelYourSite\renderProBadge;
use function PixelYourSite\SuperPack;

require_once PYS_PINTEREST_PATH . '/modules/pinterest/views/html-settings.php';
require_once __DIR__ . '/views/UI/properties-button-off.php';

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function renderPixelIdField() {
	?>

    <div class="line"></div>

    <?php renderPixelHeader(); ?>

    <div class="settings_content_wrap">
        <div class="settings_content">
            <div class="plate pixel_info">
				<?php if (PixelYourSite\isSuperPackActive() && SuperPack()->getOption( 'additional_ids_enabled' ) ): ?>
					<?php PixelYourSite\Pinterest()->render_text_input_array_item( 'main_pixel', "", 0, true ); ?>
				<?php endif; ?>

                    <div class="d-flex align-items-center pixel-switcher-enabled mb-24">
						<?php
						PixelYourSite\Pinterest()->render_switcher_input( "main_pixel_enabled" );
						?>
                        <h4 class="switcher-label secondary_heading">Enable Pixel</h4>
                    </div>

                <div class="pixel-data-wrap">
                        <div class="d-flex align-items-center">
							<?php PixelYourSite\Pinterest()->render_switcher_input( "use_server_api" ); ?>
                            <h4 class="switcher-label secondary_heading">Enable Pinterest API</h4>
                        </div>

                        <div>
                            <h4 class="primary_heading mb-4">Pinterest Pixel ID:</h4>
							<?php PixelYourSite\Pinterest()->render_pixel_id( 'pixel_id', 'Pinterest Pixel ID' ); ?>
                            <div class="form-text mt-4">
								<?php if ( isPysProActive() ) : ?>
                                    <a href="https://www.pixelyoursite.com/documentation/add-your-pinterest-tag"
                                       class="link link-small" target="_blank" rel="noopener">How to get it?</a>
								<?php else : ?>
                                    <a href="https://www.pixelyoursite.com/pixelyoursite-free-version/add-your-pinterest-tag"
                                       class="link link-small" target="_blank" rel="noopener">How to get it?</a>
								<?php endif; ?>
                            </div>
                        </div>

                        <div>
                            <h4 class="primary_heading mb-4">Your Ad Account ID</h4>
							<?php PixelYourSite\Pinterest()->render_text_input_array_item( 'ad_account_id', 'Add your Ad account ID there' ); ?>
                        </div>

                        <div>
                            <h4 class="primary_heading mb-4">Access Token:</h4>
							<?php PixelYourSite\Pinterest()->render_text_area_array_item( "server_access_api_token", "Access token" ) ?>
                            <div class="form-text mt-4">
                                <a href="https://www.youtube.com/watch?v=PhtnAEYoCuY"
                                   class="link link-small" target="_blank" rel="noopener">Lean how to configure Pinterest API</a>
                            </div>
                        </div>

                    <div class="line-dark"></div>
                    <div>
                        <?php PixelYourSite\Pinterest()->render_checkbox_input( 'test_mode', 'Enable Test Mode for API events' ); ?>
                        <p class="text-gray mt-6">
                            <?php _e('Avoid sending a large volume of test events from your staging environment. Test events will not be counted as real events in the Event overview.', 'pys'); ?>
                        </p>
                    </div>
                    <div class="line-dark"></div>

					<?php if (isPysProActive() && PixelYourSite\isSuperPackActive() ) {
                        PixelYourSite\Pinterest()->renderSPOptionForPixel();
                    } ?>

                </div>
            </div>

            <div class="line mb-24"></div>

			<?php
			if ( function_exists( "PixelYourSite\addMetaTagFields" ) ) {
				if ( isPysProActive() ) {
					$url = "https://www.pixelyoursite.com/documentation/add-your-pinterest-tag";
				} else {
					$url = "https://www.pixelyoursite.com/pixelyoursite-free-version/add-your-pinterest-tag";
				}

				PixelYourSite\addMetaTagFields( PixelYourSite\Pinterest(), $url );
				?>

                <div class="line mb-20"></div>
				<?php
			}
			?>
        </div>
    </div>

	<?php
}

function renderPixelHeader() {
    ?>
    <input type="checkbox" class="general-settings-checkbox" id="pin_settings_switch" style="display: none">
    <div class="d-flex pixel-wrap align-items-center justify-content-between">
        <div class="pixel-heading d-flex justify-content-start align-items-center">
            <img class="tag-logo" src="<?php echo PYS_PINTEREST_URL; ?>/dist/images/pinterest-logo.svg" alt="pinterest-logo">
            <h3 class="secondary_heading">Your Pinterest Tag</h3>
        </div>
        <div>
            <label for="pin_settings_switch">
                <?php PixelYourSite\renderPropertiesButtonOff(); ?>
            </label>
        </div>
    </div>
    <?php
}


function adminSecondaryNavTabs( $tabs ) {

	$tabs[ 'pinterest_settings' ] = array(
		'url'  => PixelYourSite\buildAdminUrl( 'pixelyoursite', 'pinterest_settings' ),
		'name' => 'Pinterest Settings',
		'icon' => PYS_PINTEREST_URL . '/dist/images/pinterest-logo.svg'
	);

	return $tabs;

}

function renderSettingsPage() {

	/** @noinspection PhpIncludeInspection */
    PixelYourSite\renderSettingPinterest();

}

function adminNoticePysCoreNotActive() {

	if ( current_user_can( 'manage_options' ) ) : ?>

        <div class="notice notice-error pys-notice">
            <p>PixelYourSite Pinterest Add-on needs PixelYourSite PRO or Free in order to work. Activate it now.</p>
        </div>

	<?php endif;

}

function adminNoticePysProOutdated() {

	if ( current_user_can( 'manage_options' ) ) : ?>

        <div class="notice notice-error pys-notice">
            <p>PixelYourSite Pinterest Add-on requires PixelYourSite PRO
                version <?php echo PYS_PINTEREST_PRO_MIN_VERSION; ?> or newer.</p>
        </div>

	<?php endif;

}

function adminNoticePysFreeOutdated() {

	if ( current_user_can( 'manage_options' ) ) : ?>

        <div class="notice notice-error pys-notice">
            <p>PixelYourSite Pinterest Add-on requires PixelYourSite Free
                version <?php echo PYS_PINTEREST_FREE_MIN_VERSION; ?> or newer.</p>
        </div>

	<?php endif;

}
