<?php

namespace PixelYourSite\Pinterest;

use PixelYourSite;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function isPysProActive() {

	if ( !function_exists( 'is_plugin_active' ) ) {
		include_once WP_PLUGIN_INCLUDE;
	}

	return is_plugin_active( 'pixelyoursite-pro/pixelyoursite-pro.php' );

}

function isWPMLActive() {

	if ( ! function_exists( 'is_plugin_active' ) ) {
		include_once WP_PLUGIN_INCLUDE;
	}
	if ( ! file_exists( WP_PLUGIN_DIR . '/sitepress-multilingual-cms/sitepress.php' ) ) {
		return false;
	}
	return is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' );
}

function pinterest_round( $val, $precision = 2, $mode = PHP_ROUND_HALF_UP ) {
	if ( !is_numeric( $val ) ) {
		$val = (float) $val;
	}
	return (string) round( $val, $precision, $mode );
}

function pysProVersionIsCompatible() {

	if ( !function_exists( 'get_plugin_data' ) ) {
		include_once WP_PLUGIN_INCLUDE;
	}

	$data = get_plugin_data( WP_PLUGIN_DIR . '/pixelyoursite-pro/pixelyoursite-pro.php', false, false );

	return version_compare( $data[ 'Version' ], PYS_PINTEREST_PRO_MIN_VERSION, '>=' );

}

function isPysFreeActive() {

	if ( !function_exists( 'is_plugin_active' ) ) {
		include_once WP_PLUGIN_INCLUDE;
	}

	return is_plugin_active( 'pixelyoursite/facebook-pixel-master.php' );

}

function pysFreeVersionIsCompatible() {

	if ( !function_exists( 'get_plugin_data' ) ) {
		include_once WP_PLUGIN_INCLUDE;
	}

	$data = get_plugin_data( WP_PLUGIN_DIR . '/pixelyoursite/facebook-pixel-master.php', false, false );

	return version_compare( $data[ 'Version' ], PYS_PINTEREST_FREE_MIN_VERSION, '>=' );

}

/**
 * Retrieves parameters values for for current queried object
 *
 * @return array
 */


function getEnhancedMatchingParams() {
    $params = array();
    $params = array_merge($params, getUserParams());
    $params = array_merge($params, getWooCommerceParams());
    $params = array_merge($params, getEDDParams());

    return sanitizeParams($params);
}

function getUserParams() {
    $user = wp_get_current_user();
    $params = array();

    if ($user->ID) {
        $params['em'] = $user->get('user_email');
    }

    if (PixelYourSite\EventsManager::isTrackExternalId() && PixelYourSite\PYS()->get_pbid()) {
        $params['external_id'] = PixelYourSite\PYS()->get_pbid();
    }

    return $params;
}

function getWooCommerceParams() {
    $params = array();

    if (
        PixelYourSite\isWooCommerceActive() &&
        PixelYourSite\PYS()->getOption('woo_enabled') &&
        PixelYourSite\PYS()->woo_is_order_received_page(is_order_received_page()) &&
        isset($_REQUEST['key'])
    ) {
        $order_id = PixelYourSite\wooGetOrderIdFromRequest();
        if ($order_id > 0) {
            $order = wc_get_order($order_id);
            if ($order) {
                $params['em'] = $order->get_billing_email();
                $params['ph'] = $order->get_billing_phone();
            }
        }
    }

    return $params;
}

function getEDDParams() {
    $params = array();

    if (
        PixelYourSite\isEddActive() &&
        PixelYourSite\PYS()->getOption('edd_enabled') &&
        edd_is_success_page() &&
        !isset($_GET['payment-confirmation'])
    ) {
        $payment_key = PixelYourSite\getEddPaymentKey();

        if (isset($payment_key)) {
            $payment_id = edd_get_purchase_id_by_key($payment_key);
            if ($payment = edd_get_payment($payment_id)) {
                $params['em'] = $payment->email;
            }
        }
    }

    return $params;
}

function sanitizeParams($params) {
    $sanitized = array();

    foreach ($params as $key => $value) {
        if (!empty($value)) {
            $sanitized[$key] = sanitizeEnhancedMatchingParam($value, $key);
        }
    }

    return $sanitized;
}

function sanitizeEnhancedMatchingParam( $value, $key ) {

    $value = strtolower($value);

    switch ($key) {
        case 'ph':
            $value = preg_replace('/\D/', '', $value);
            break;
        case 'em':
            $value = preg_replace('/[^a-z0-9._+\-@]+/i', '', $value);
            break;
        case 'external_id':
            // No transformation needed for external_id
            break;
        default:
            $value = preg_replace('/[^a-z]/', '', $value);
            break;
    }

    return $value;

}
function wooMapOrderId( $orderId ) {
	return PixelYourSite\PYS()->getOption( "woo_order_id_prefix" ) . $orderId;
}

function eddMapOrderId( $orderId ) {
	return PixelYourSite\PYS()->getOption( "edd_order_id_prefix" ) . $orderId;
}

function getDisabledPixels($slug) {
    $disabledPixel = apply_filters('pys_pixel_disabled', array(), $slug);
    $hide_pixels = apply_filters('hide_pixels', array());
    return array_merge($disabledPixel, $hide_pixels);
}

function filterDisabledPixels($pixelIds, $disabledPixel) {
    if (!empty($disabledPixel)) {
        if (is_array($disabledPixel)) {
            $pixelIds = array_filter($pixelIds, static function ($element) use ($disabledPixel) {
                return !in_array($element, $disabledPixel);
            });
            $pixelIds = array_values($pixelIds);
        } else {
            foreach ($pixelIds as $key => $value) {
                if ($value == $disabledPixel) {
                    array_splice($pixelIds, $key, 1);
                }
            }
        }
    }
    return $pixelIds;
}

function pys_generate_token( $length = 36 ) {
	$characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
	$charactersLength = strlen( $characters );
	$randomString = '';
	for ( $i = 0; $i < $length; $i++ ) {
		$randomString .= $characters[ random_int( 0, $charactersLength - 1 ) ];
	}
	return $randomString;
}
