<?php
namespace PixelYourSite\Pinterest;

use PixelYourSite;
use PixelYourSite\SuperPack;

use PixelYourSite\PinterestMainHelper;
use function PixelYourSite\SuperPack;

function filterEventsPixel($event, $pixel, &$pixelEvents)
{
    $cloneEvent = clone $event;
    $main_pixel_ids = $pixel->getPixelIDs();
    $isWoo = isEventWithProducts($event->getID(), 'woo');
    $isEdd = isEventWithProducts($event->getID(), 'edd');

    $pixelsForFilter = getPixelsForFilter($pixel, $main_pixel_ids);
    foreach ($pixelsForFilter as $_pixel) {
        if (!shouldProcessPixel($_pixel, $event, $pixel)) {
            continue;
        }

        $filteredProducts = getFilteredProducts($event, $_pixel, $isWoo, $isEdd);
        if ($filteredProducts !== null) {
            $cloneEvent->args['products'] = $filteredProducts;
            if (!empty($filteredProducts) && $pixel->addParamsToEvent($cloneEvent)) {
                addPixelPayload($cloneEvent, $_pixel->pixel, $pixelEvents);
            }
        } elseif ($pixel->addParamsToEvent($cloneEvent)) {
            addPixelPayload($cloneEvent, $_pixel->pixel, $pixelEvents);
        }
    }

}

function isEventWithProducts($eventId, $type = 'both') {
    $listOfEddEventWithProducts = [
        'edd_add_to_cart_on_checkout_page',
        'edd_initiate_checkout',
        'edd_purchase',
        'edd_frequent_shopper',
        'edd_vip_client',
        'edd_big_whale'
    ];

    $listOfWooEventWithProducts = [
        'woo_purchase',
        'woo_initiate_checkout',
        'woo_paypal',
        'woo_add_to_cart_on_checkout_page',
        'woo_add_to_cart_on_cart_page'
    ];

    switch ($type) {
        case 'woo':
            return in_array($eventId, $listOfWooEventWithProducts);
        case 'edd':
            return in_array($eventId, $listOfEddEventWithProducts);
        case 'both':
        default:
            return in_array($eventId, $listOfWooEventWithProducts) || in_array($eventId, $listOfEddEventWithProducts);
    }
}

function getPixelsForFilter($pixel, $main_pixel_ids) {
    $pixels = [];
    if (empty($main_pixel_ids)) {
        return $pixels;
    }

    $options = $pixel->getOption('main_pixel');
    $normalized = !empty($options) && isset($options[0])
        ? $pixel->normalizeSPOptions($main_pixel_ids[0], $options[0])
        : $pixel->normalizeSPOptions($main_pixel_ids[0], '');

    $pixels[] = SuperPack\SPPixelId::fromArray($normalized);
    return $pixels;
}

function shouldProcessPixel($spPixel, $event, $pixel) {
    return $spPixel->isValidForEvent($event)
        && !in_array($spPixel->pixel, getDisabledPixels($pixel->getSlug()));
}

function getFilteredProducts($event, $spPixel, $isWoo, $isEdd) {
    $filter = null;

    if ($isWoo) {
        $filter = $spPixel->getWooFilter();
    } elseif ($isEdd) {
        $filter = $spPixel->getEddFilter();
    }

    $products = [];

    if ($filter === null) {
        return null;
    }

    $containsAll = array_filter($filter, fn($f) => $f['filter'] === 'all');

    if (!empty($containsAll)) {
        $products = $event->args['products'];
    } elseif ($isWoo) {
        $products = PixelYourSite\EventsWoo()->filterEventProductsBy($event, $filter, $spPixel);
    } elseif ($isEdd) {
        $products = PixelYourSite\EventsEdd()->filterEventProductsBy($event, $filter, $spPixel);
    }

    return $products;
}

function addPixelPayload(&$event, $pixelId, &$pixelEvents) {
    $event->addPayload(['pixelIds' => [$pixelId]]);
    $pixelEvents[] = $event;
}