<?php

namespace PixelYourSite;
defined('ABSPATH') || exit;

class Pinterest_logger extends PYS_Logger {

	protected $log_path = null;
    const LOGS_DIR = 'logs/';

	public function __construct( ) {
        parent::__construct(); // Call the parent constructor
		$this->log_path = trailingslashit( PYS_PINTEREST_PATH ).self::LOGS_DIR;
	}

	public function init() {
		$this->isEnabled = Pinterest()->getOption('logs_enable');
	}

	public static function get_log_file_name( ) {
		return 'pinterest_debug.log';
	}

	public static function get_log_file_path( ) {
		return trailingslashit( PYS_PINTEREST_PATH ).self::LOGS_DIR . self::get_log_file_name( );
	}

	public static function get_log_file_url( ) {
		return trailingslashit( PYS_PINTEREST_URL ) .self::LOGS_DIR. static::get_log_file_name( );
	}

}
