<?php

namespace PixelYourSite;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * @var CustomEvent $event
 */

?>

<?php
$pinterest_configured = Pinterest()->enabled() && !empty( Pinterest()->getPixelIDs() );
?>

<div class="card card-style4" data-configured="<?php echo $pinterest_configured ? '1' : '0' ?>">
    <input type="checkbox" class="event-settings-checkbox" id="pinterest_custom_event_switch"
           style="display: none">

    <div class="card-header card-header-style3 d-flex justify-content-between align-items-center">
        <div class="custom-event-pixel-header">
            <img src="<?php echo PYS_PINTEREST_URL; ?>/dist/images/pinterest-logo.svg" alt="pinterest-logo"
                 class="pixel-logo">
            <h4 class="font-semibold main-switcher">Pinterest</h4>
        </div>

        <div class="custom-event-pixel-status">
			<?php
			$enabled = $event->pinterest_enabled && $pinterest_configured;
			?>
            <div class="pixel-status">
                <p class="status pixel-enabled" style="<?php echo $enabled ? '' : 'display: none' ?>">
                    Active
                </p>

                <p class="status pixel-disabled" style="<?php echo $enabled ? 'display: none' : '' ?>">
                    Inactive
                </p>
            </div>

            <label class="card-header-label" for="pinterest_custom_event_switch">
				<?php include_once __DIR__ . '/UI/properties-button-off.php'; ?>
                <?php renderPropertiesButtonOff(); ?>
            </label>
        </div>
    </div>

    <div class="card-body">
        <div class="pinterest-not-configured-error mb-24">
            <div class="event_error critical_message">Error: Pinterest is not configured</div>
        </div>

        <div class="d-flex align-items-center mb-24">
			<?php Events\renderSwitcherInput( $event, 'pinterest_enabled' ); ?>
            <h4 class="switcher-label secondary_heading">Enable on Pinterest</h4>
        </div>

        <div id="pinterest_panel" class="pixel_panel">
            <div>
                <div class="mb-8">
                    <label class="custom-event-label control-label" for="pys_event_pinterest_event_type">Event type:</label>
                </div>

				<?php Events\renderPinterestEventTypeInput( $event, 'pinterest_event_type' ); ?>

                <div class="pinterest-custom-event-type mt-16">
					<?php Events\renderTextInput( $event, 'pinterest_custom_event_type', 'Enter name' ); ?>
                </div>
            </div>

            <div class="d-flex align-items-center mt-24">
				<?php Events\renderSwitcherInput( $event, 'pinterest_params_enabled' ); ?>
                <h4 class="switcher-label secondary_heading">Add Parameters</h4>
            </div>

            <div id="pinterest_params_panel">

                <!-- Custom Pinterest Params -->
                <div class="pinterest-custom-param" data-param_id="0" style="display: none;">
                    <div class="mt-24 d-flex align-items-center">
                        <div>
                            <input name="" placeholder="Enter name" class="custom-param-name input-standard"
                                   type="text">
                        </div>

                        <div class="ml-16">
                            <input name="" placeholder="Enter value" class="custom-param-value input-standard"
                                   type="text">
                        </div>

                        <div>
							<?php include_once __DIR__ . '/UI/button-remove-row.php'; ?>
                        </div>
                    </div>
                </div>

				<?php foreach ( $event->getPinterestCustomParams() as $key => $custom_param ) : ?>

					<?php $param_id = $key + 1; ?>

                    <div class="pinterest-custom-param" data-param_id="<?php echo $param_id; ?>">
                        <div class="mt-24 d-flex align-items-center">
                            <div>
                                <input type="text" placeholder="Enter name"
                                       class="custom-param-name input-standard"
                                       name="pys[event][pinterest_custom_params][<?php echo $param_id; ?>][name]"
                                       value="<?php esc_attr_e( $custom_param[ 'name' ] ); ?>">
                            </div>

                            <div class="ml-16">
                                <input type="text" placeholder="Enter value"
                                       class="custom-param-value input-standard"
                                       name="pys[event][pinterest_custom_params][<?php echo $param_id; ?>][value]"
                                       value="<?php esc_attr_e( $custom_param[ 'value' ] ); ?>">
                            </div>

                            <div>
								<?php include_once __DIR__ . '/UI/button-remove-row.php'; ?>
                            </div>
                        </div>
                    </div>
				<?php endforeach; ?>

                <div class="insert-marker"></div>

                <div class="mt-24">
					<?php renderAddCustomParameterButton( 'pinterest' ); ?>
                </div>
            </div>
            <?php if(Pinterest\isPysProActive()){ ?>
                <div class="d-flex align-items-center mt-24 mb-24">
                    <?php Events\renderSwitcherInput( $event, 'pinterest_track_single_woo_data' ); ?>
                    <h4 class="switcher-label secondary_heading">Track WooCommerce product data on single product pages</h4>
                </div>
                <div class="d-flex align-items-center mb-24">
                    <?php Events\renderSwitcherInput( $event, 'pinterest_track_cart_woo_data' ); ?>
                    <h4 class="switcher-label secondary_heading">Track WooCommerce cart data when possible</h4>
                </div>
            <?php } else {?>
                <div class="pro-feature-container mb-24 mt-24">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center justify-content-start">
                            <?php renderDummySwitcher(); ?>
                            <h4 class="switcher-label secondary_heading">Track WooCommerce product data on single product pages</h4>
                        </div>
                        <?php renderProBadge( 'https://www.pixelyoursite.com/?utm_source=pys-free-plugin&utm_medium=pro-badge&utm_campaign=pro-feature' ); ?>
                    </div>
                </div>
                <div class="pro-feature-container mb-24">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center justify-content-start">
                            <?php renderDummySwitcher(); ?>
                            <h4 class="switcher-label secondary_heading">Track WooCommerce cart data when possible</h4>
                        </div>
                        <?php renderProBadge( 'https://www.pixelyoursite.com/?utm_source=pys-free-plugin&utm_medium=pro-badge&utm_campaign=pro-feature' ); ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
