<?php

namespace PixelYourSite;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
function renderSettingPinterest() {
?>
    <div class="cards-wrapper cards-wrapper-style2 gap-24 settings-wrapper">
        <!-- General -->
        <div class="card card-style6 card-static">
            <div class="card-header card-header-style2 d-flex justify-content-between align-items-center">
                <h4 class="secondary_heading_type2"><?php _e('General', 'pys');?></h4>
            </div>
            <div class="card-body">
                <div class="gap-24">
                    <div>
                        <div class="d-flex align-items-center">
                            <?php Pinterest()->render_switcher_input( 'enhanced_matching_enabled' ); ?>
                            <h4 class="switcher-label secondary_heading"><?php _e('Enable Enhanced Matching', 'pys');?></h4>
                        </div>
                    </div>
                    <div>
                        <div class="d-flex align-items-center mb-4">
                            <?php Pinterest()->render_switcher_input( "disable_noscript"); ?>
                            <h4 class="switcher-label secondary_heading"><?php _e('Disable noscript', 'pys');?></h4>
                        </div>
                    </div>
                    <div class="line"></div>
                    <div>
                        <h4 class="secondary_heading"><?php _e( 'Fire the PageVisit  event on custom post type:', 'pys' );?></h4>
                    </div>
                    <?php if ( isWooCommerceActive() ) : ?>
                        <div>
                            <div class="d-flex align-items-center mb-4">
                                <?php Pinterest()->render_switcher_input( 'page_view_woo_products_pages' ); ?>
                                <h4 class="switcher-label secondary_heading">WooCommerce products pages</h4>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ( isEddActive() ) : ?>
                        <div>
                            <div class="d-flex align-items-center mb-4">
                                <?php Pinterest()->render_switcher_input( 'page_view_edd_products_pages' ); ?>
                                <h4 class="switcher-label secondary_heading">Easy Digital Downloads product pages</h4>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div>
                        <div class="d-flex align-items-center mb-4">
                            <?php Pinterest()->render_switcher_input( 'page_view_post_enabled' ); ?>
                            <h4 class="switcher-label secondary_heading">Posts</h4>
                        </div>
                    </div>
                    <div>
                        <div class="d-flex align-items-center mb-4">
                            <?php Pinterest()->render_switcher_input( 'page_view_page_enabled' ); ?>
                            <h4 class="switcher-label secondary_heading">Pages</h4>
                        </div>
                    </div>
                    <div>
                        <div class="mb-24">
                            <h4 class="secondary_heading"><?php _e( 'Custom Post Type:', 'pys' );?></h4>
                        </div>
                        <input type="checkbox" class="custom-control-input"
                               name="pys[pinterest][page_view_custom_post_enabled][-1]" value="0" checked/>
                        <div class="custom-controls-stacked gap-24">
                            <?php
                            $args = array(
                                'public' => true
                            );
                            $exclude = array(
                                "post",
                                "page"
                            );
                            if ( isWooCommerceActive() ) {
                                $exclude[] = "product";
                            }
                            if ( isEddActive() ) {
                                $exclude[] = "download";
                            }
                            $post_types = get_post_types( $args, 'objects' );
                            foreach ( $post_types as $type ) {
                                if ( !in_array( $type->name, $exclude ) ) {
                                    ?>
                                    <div class="d-flex align-items-center">
                                        <?php
                                        Pinterest()->render_switcher_input_array( 'page_view_custom_post_enabled', $type->name );
                                        ?>
                                        <h4 class="switcher-label secondary_heading"><?=$type->label?></h4>
                                    </div>
                                    <?php
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
