<?php

namespace PixelYourSite;

use PixelYourSite\GA\Helpers;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<div class="cards-wrapper cards-wrapper-style2 gap-24 settings-wrapper">
    <!-- General -->
    <div class="card card-style6 card-static">
        <div class="card-header card-header-style2 d-flex justify-content-between align-items-center">
            <h4 class="secondary_heading_type2"><?php _e('General', 'pys');?></h4>
        </div>
        <div class="card-body">
            <div class="gap-24">
                <div>
                    <div class="d-flex align-items-center mb-24">
                        <?php PYS()->render_switcher_input('google_consent_mode'); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Fire Google tags with consent mode granted', 'pys');?></h4>
                    </div>
                    <p class="text-gray">
                        <?php _e('How to enable Google Consent Mode V2', 'pys');?>
                        <a class="link" href="https://www.pixelyoursite.com/google-consent-mode-v2-wordpress?utm_source=plugin&utm_medium=pro&utm_campaign=google-consent" target="_blank"><?php _e('click here', 'pys');?></a>
                    </p>
                </div>
                <div class="line"></div>
                <div>
                    <div class="d-flex align-items-center mb-24">
                        <h4 class="secondary_heading"><?php echo esc_html( __('DataLayer Setting:', 'pys') ); ?></h4>
                    </div>
                    <div class="radio-inputs-wrap mb-16">
                        <?php GATags()->render_radio_input('gtag_datalayer_type', 'default', 'Use PYS recommended name for data layer variable (recommended).'); ?>
                        <?php GATags()->render_radio_input('gtag_datalayer_type', 'disable', 'Disable name transformation for the data layer (use dataLayer).'); ?>
                        <?php GATags()->render_radio_input('gtag_datalayer_type', 'custom', 'Use this custom name for the data layer variable.'); ?>
                    </div>
                    <div class="d-flex align-items-center">
                        <?php GATags()->render_text_input('gtag_datalayer_name', 'custom name for the data layer'); ?>
                    </div>
                </div>
                <div class="line"></div>
                <div>
                    <div class="d-flex align-items-center mb-4">
                        <?php GA()->render_switcher_input('url_passthrough'); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Pass through ad click, client ID, and session ID information in URLs (url_passthrough)', 'pys');?></h4>
                    </div>
                </div>
                <div>
                    <div class="d-flex align-items-center mb-24">
                        <?php GA()->render_switcher_input('url_passthrough_filter'); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Overwrite this option with the dedicated filter', 'pys');?></h4>
                    </div>
                    <div class="example-block mb-24">
                        <label><?php _e('Example:', 'pys');?></label>
                        <pre class="copy_text">
add_filter('pys_url_passthrough_mode',function ($status) {
    if(get_current_user_id() == 0) {
        return true;
    }
    return $status;
});<div class="copy-icon" data-toggle="pys-popover"
        data-tippy-trigger="click" data-tippy-placement="bottom"
        data-popover_id="copied-popover"></div></pre>

                    </div>
                    <p class="text-gray pb-8">
                        <?php _e('Reference:', 'pys');?>
                        <a class="link" href="https://developers.google.com/tag-platform/security/guides/consent?consentmode=advanced#gtag.js_5" target="_blank"><?php _e('click here', 'pys');?></a>
                    </p>
                    <p class="text-gray">
                        <?php _e('This option can improve tracking when cookies are denied:', 'pys');?> <a class="link" href="https://www.youtube.com/watch?v=wsNAbaoD5pM" target="_blank"><?php _e('watch video', 'pys');?></a>
                    </p>
                </div>
                <div class="line"></div>
                <div>
                    <div class="d-flex align-items-center mb-24">
                        <?php GA()->render_switcher_input('send_user_provided_data'); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Send user provided data when possible', 'pys');?></h4>
                    </div>
                    <div class="gap-24">
                        <div>
                            <?php GA()->render_checkbox_input("use_multiple_provided_data", "Send multiple values when possible (up to 3 emails and phone numbers, up to 2 address fields)"); ?>
                        </div>
                        <div>
                            <?php GA()->render_checkbox_input("use_encoding_provided_data", "Use encoding"); ?>
                        </div>
                        <p class="text-gray">
                            <?php _e('Learn how to configure it: ', 'pys');?>
                            <a class="link" href="https://www.youtube.com/watch?v=uQ8t7RJhVvI" target="_blank"><?php _e('watch video', 'pys');?></a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Google Analytics Settings -->
    <div class="card card-style6 card-static">
        <div class="card-header card-header-style2 d-flex justify-content-between align-items-center">
            <h4 class="secondary_heading_type2"><?php _e('Google Analytics', 'pys');?></h4>
        </div>
        <div class="card-body">
            <div class="gap-24">
                <div>
                    <div class="d-flex align-items-center mb-4">
                        <?php GA()->render_switcher_input( 'custom_page_view_event' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Control the page_view event', 'pys');?></h4>
                    </div>
                    <p class="text-gray">
                        <?php _e('Enable it if you use a GTM server container to fire API events. When we control the page_view event we can sent an event_id that is used for deduplication of API events.', 'pys');?>
                    </p>
                </div>
                <div>
                    <div class="d-flex align-items-center">
                        <?php GA()->render_switcher_input( 'disable_noscript' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Disable noscript', 'pys');?></h4>
                    </div>
                </div>
                <div>
                    <div class="d-flex align-items-center">
                        <?php GA()->render_switcher_input( 'disable_advertising_personalization' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Disable advertising personalization', 'pys');?></h4>
                    </div>
                </div>
                <div>
                    <div class="d-flex align-items-center">
                        <?php GA()->render_switcher_input( 'track_user_id' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Track User-ID for logged-in users', 'pys');?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Ads Settings -->
    <div class="card card-style6 card-static">
        <div class="card-header card-header-style2 d-flex justify-content-between align-items-center">
            <h4 class="secondary_heading_type2"><?php _e('Google Ads', 'pys');?></h4>
        </div>
        <div class="card-body">
            <div class="gap-24">
                <div>
                    <div class="d-flex align-items-center">
                        <?php Ads()->render_switcher_input( 'page_view_post_enabled' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Fire the page_view_event on posts', 'pys');?></h4>
                    </div>
                </div>
                <div>
                    <div class="d-flex align-items-center">
                        <?php Ads()->render_switcher_input( 'page_view_page_enabled' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Fire the page_view event on pages', 'pys');?></h4>
                    </div>
                </div>
                <div>
                    <div class="mb-24">
                        <label class="secondary_heading"><?php _e('Fire the page_view event on custom post type:', 'pys');?></label>
                    </div>
                    <input type="checkbox" class="custom-control-input" name="pys[google_ads][page_view_custom_post_enabled][-1]" value="0" checked />
                    <div class="custom-controls-stacked offset-block gap-24">
                        <?php
                        $args = array(
                            'public' => true
                        );
                        $exclude = array("post","page");
                        if(isWooCommerceActive()){
                            $exclude[] = "product";
                        }
                        if(isEddActive()){
                            $exclude[] = "download";
                        }
                        $post_types = get_post_types( $args, 'objects' );
                        foreach ( $post_types as $type) {
                            if(in_array($type->name,$exclude)) continue;
                            ?>
                                <div class="d-flex align-items-center">
                                    <?php Ads()->render_switcher_input_array( 'page_view_custom_post_enabled', $type->name); ?>
                                    <h4 class="switcher-label secondary_heading"><?=$type->label?></h4>
                                </div>
                            <?php

                        }
                        ?>
                    </div>
                </div>
                <div>
                    <div class="mb-24">
                        <div class="mb-8">
                            <label class="primary_heading"><?php _e('google_business_vertical:', 'pys');?></label>
                        </div>
                        <?php Ads()->render_text_input( 'page_view_business_vertical','google_business_vertical', false, false, false, 'short' ); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Cross-Domain Tracking -->
    <!-- @link: https://developers.google.com/analytics/devguides/collection/gtagjs/cross-domain -->
    <div class="card card-style6 card-static">
        <div class="card-header card-header-style2 d-flex justify-content-between align-items-center">
            <h4 class="secondary_heading_type2"><?php _e('Cross-Domain Tracking', 'pys');?></h4>
        </div>
        <div class="card-body">
            <div class="gap-24">
                <div>
                    <div class="d-flex align-items-center">
                        <?php GA()->render_switcher_input( 'cross_domain_enabled' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Enable Cross-Domain Tracking', 'pys');?></h4>
                        <?php renderPopoverButton( 'ga_cross_domain_tracking' ); ?>
                    </div>
                </div>
                <div class="offset-block gap-24">
                    <div class="d-flex align-items-center">
                        <?php GA()->render_switcher_input( 'cross_domain_accept_incoming' ); ?>
                        <h4 class="switcher-label secondary_heading"><?php _e('Accept incoming', 'pys');?></h4>
                    </div>
                    <div class="d-flex align-items-center">
                        <?php Helpers\renderCrossDomainDomain( 0 ); ?>
                    </div>

                    <?php foreach ( GA()->getOption('cross_domain_domains') as $index => $domain ) : ?>

                        <?php

                        if ( $index === 0 ) {
                            continue; // skip default ID
                        }

                        ?>

                    <div class="d-flex align-items-center cross-domain-block">
                        <?php Helpers\renderCrossDomainDomain( $index ); ?>
                        <div>
                            <button type="button" class="button-remove-row remove-row">
                                <i class="icon-delete" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>

                    <?php endforeach; ?>

                    <div class="d-flex align-items-center cross-domain-block" id="pys_ga_cross_domain_domain" style="display: none;">
                        <input type="text" class="input-short" name="" id="" value="" placeholder="Enter domain">
                        <div>
                            <button type="button" class="button-remove-row remove-row">
                                <i class="icon-delete" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>

                    <div>
                        <button class="btn btn-primary btn-primary-type2" type="button"
                                id="pys_ga_add_cross_domain_domain">
                            <?php _e('Add Extra Domain', 'pys');?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script type="application/javascript">
    jQuery(document).ready(function ($) {

        $('#pys_ga_add_cross_domain_domain').click(function (e) {

            e.preventDefault();

            var $row = $('#pys_ga_cross_domain_domain').clone()
                .insertBefore('#pys_ga_cross_domain_domain')
                .attr('id', '')
                .css('display', 'flex');

            $('input[type="text"]', $row)
                .attr('name', 'pys[ga][cross_domain_domains][]');

        });

        $(document).on('click', '.remove-row', function () {
            $(this).closest('.cross-domain-block').remove();
        });

    });
</script>