<?php

/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
namespace PYS_PRO_GLOBAL\FacebookAds\Object\Search;

use PYS_PRO_GLOBAL\FacebookAds\Enum\AbstractEnum;
/**
 * @method static DemographicSearchClasses getInstance()
 */
class DemographicSearchClasses extends \PYS_PRO_GLOBAL\FacebookAds\Enum\AbstractEnum
{
    const LIFE_EVENTS = 'life_events';
    const POLITICS = 'politics';
    const MARKETS = 'markets';
    const INDUSTRIES = 'industries';
    const INCOME = 'income';
    const NET_WORTH = 'net_worth';
    const HOME_TYPE = 'home_type';
    const HOME_OWNERSHIP = 'home_ownership';
    const HOME_VALUE = 'home_value';
    const ETHNIC_AFFINITY = 'ethnic_affinity';
    const GENERATION = 'generation';
    const HOUSEHOLD_COMPOSITION = 'household_composition';
    const MOMS = 'moms';
    const OFFICE_TYPE = 'office_type';
    const FAMILY_STATUSES = 'family_statuses';
    const DEMOGRAPHICS = 'demographics';
}
