<?php

declare (strict_types=1);
namespace PYS_PRO_GLOBAL\GuzzleHttp\Psr7;

use PYS_PRO_GLOBAL\Psr\Http\Message\StreamInterface;
/**
 * Lazily reads or writes to a file that is opened only after an IO operation
 * take place on the stream.
 */
final class LazyOpenStream implements \PYS_PRO_GLOBAL\Psr\Http\Message\StreamInterface
{
    use StreamDecoratorTrait;
    /** @var string */
    private $filename;
    /** @var string */
    private $mode;
    /**
     * @param string $filename File to lazily open
     * @param string $mode     fopen mode to use when opening the stream
     */
    public function __construct(string $filename, string $mode)
    {
        $this->filename = $filename;
        $this->mode = $mode;
    }
    /**
     * Creates the underlying stream lazily when required.
     */
    protected function createStream() : \PYS_PRO_GLOBAL\Psr\Http\Message\StreamInterface
    {
        return \PYS_PRO_GLOBAL\GuzzleHttp\Psr7\Utils::streamFor(\PYS_PRO_GLOBAL\GuzzleHttp\Psr7\Utils::tryFopen($this->filename, $this->mode));
    }
}
